/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.Distribution;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.BuiltInMetricsProvider;
import com.google.monitoring.v3.DroppedLabels;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.SpanContext;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class SpannerCloudMonitoringExporterUtils {
    private static final Logger logger = Logger.getLogger(SpannerCloudMonitoringExporterUtils.class.getName());
    static final long NANO_PER_SECOND = 1000000000L;

    private SpannerCloudMonitoringExporterUtils() {
    }

    static String getProjectId(Resource resource) {
        return (String)resource.getAttributes().get(BuiltInMetricsConstant.PROJECT_ID_KEY);
    }

    static List<TimeSeries> convertToSpannerTimeSeries(List<MetricData> collection, String projectId) {
        ArrayList<TimeSeries> allTimeSeries = new ArrayList<TimeSeries>();
        for (MetricData metricData : collection) {
            if (!metricData.getInstrumentationScopeInfo().getName().equals("gax-java") && !metricData.getInstrumentationScopeInfo().getName().equals("spanner-java") && !metricData.getInstrumentationScopeInfo().getName().equals("grpc-java")) continue;
            MonitoredResource.Builder monitoredResourceBuilder = MonitoredResource.newBuilder().setType("spanner_instance_client");
            Attributes resourceAttributes = metricData.getResource().getAttributes();
            for (AttributeKey key : resourceAttributes.asMap().keySet()) {
                monitoredResourceBuilder.putLabels(key.getKey(), String.valueOf(resourceAttributes.get(key)));
            }
            metricData.getData().getPoints().stream().map(pointData -> SpannerCloudMonitoringExporterUtils.convertPointToSpannerTimeSeries(metricData, pointData, monitoredResourceBuilder, projectId)).forEach(allTimeSeries::add);
        }
        return allTimeSeries;
    }

    private static TimeSeries convertPointToSpannerTimeSeries(MetricData metricData, PointData pointData, MonitoredResource.Builder monitoredResourceBuilder, String projectId) {
        TimeSeries.Builder builder = TimeSeries.newBuilder().setMetricKind(SpannerCloudMonitoringExporterUtils.convertMetricKind(metricData)).setValueType(SpannerCloudMonitoringExporterUtils.convertValueType(metricData.getType()));
        Metric.Builder metricBuilder = Metric.newBuilder().setType(metricData.getName());
        Attributes attributes = pointData.getAttributes();
        for (AttributeKey key : attributes.asMap().keySet()) {
            if (BuiltInMetricsConstant.SPANNER_PROMOTED_RESOURCE_LABELS.contains(key)) {
                monitoredResourceBuilder.putLabels(key.getKey(), String.valueOf(attributes.get(key)));
                continue;
            }
            metricBuilder.putLabels(key.getKey().replace(".", "_"), String.valueOf(attributes.get(key)));
        }
        metricBuilder.putAllLabels(BuiltInMetricsProvider.INSTANCE.createClientAttributes());
        builder.setResource(monitoredResourceBuilder.build());
        builder.setMetric(metricBuilder.build());
        TimeInterval timeInterval = TimeInterval.newBuilder().setStartTime(Timestamps.fromNanos((long)pointData.getStartEpochNanos())).setEndTime(Timestamps.fromNanos((long)pointData.getEpochNanos())).build();
        builder.addPoints(SpannerCloudMonitoringExporterUtils.createPoint(metricData.getType(), pointData, timeInterval, projectId));
        return builder.build();
    }

    private static MetricDescriptor.MetricKind convertMetricKind(MetricData metricData) {
        switch (metricData.getType()) {
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return SpannerCloudMonitoringExporterUtils.convertHistogramType(metricData.getHistogramData());
            }
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return MetricDescriptor.MetricKind.GAUGE;
            }
            case LONG_SUM: {
                return SpannerCloudMonitoringExporterUtils.convertSumDataType(metricData.getLongSumData());
            }
            case DOUBLE_SUM: {
                return SpannerCloudMonitoringExporterUtils.convertSumDataType(metricData.getDoubleSumData());
            }
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.MetricKind convertHistogramType(HistogramData histogramData) {
        if (histogramData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.MetricKind convertSumDataType(SumData<?> sum) {
        if (!sum.isMonotonic()) {
            return MetricDescriptor.MetricKind.GAUGE;
        }
        if (sum.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.ValueType convertValueType(MetricDataType metricDataType) {
        switch (metricDataType) {
            case LONG_GAUGE: 
            case LONG_SUM: {
                return MetricDescriptor.ValueType.INT64;
            }
            case DOUBLE_GAUGE: 
            case DOUBLE_SUM: {
                return MetricDescriptor.ValueType.DOUBLE;
            }
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return MetricDescriptor.ValueType.DISTRIBUTION;
            }
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    private static Point createPoint(MetricDataType type, PointData pointData, TimeInterval timeInterval, String projectId) {
        Point.Builder builder = Point.newBuilder().setInterval(timeInterval);
        switch (type) {
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return builder.setValue(TypedValue.newBuilder().setDistributionValue(SpannerCloudMonitoringExporterUtils.convertHistogramData((HistogramPointData)pointData, projectId)).build()).build();
            }
            case DOUBLE_GAUGE: 
            case DOUBLE_SUM: {
                return builder.setValue(TypedValue.newBuilder().setDoubleValue(((DoublePointData)pointData).getValue()).build()).build();
            }
            case LONG_GAUGE: 
            case LONG_SUM: {
                return builder.setValue(TypedValue.newBuilder().setInt64Value(((LongPointData)pointData).getValue())).build();
            }
        }
        logger.log(Level.WARNING, "unsupported metric type");
        return builder.build();
    }

    private static Distribution convertHistogramData(HistogramPointData pointData, String projectId) {
        return Distribution.newBuilder().setCount(pointData.getCount()).setMean(pointData.getCount() == 0L ? 0.0 : pointData.getSum() / (double)pointData.getCount()).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addAllBounds((Iterable)pointData.getBoundaries()))).addAllBucketCounts((Iterable)pointData.getCounts()).addAllExemplars((Iterable)pointData.getExemplars().stream().map(e -> SpannerCloudMonitoringExporterUtils.mapExemplar((ExemplarData)e, projectId)).collect(Collectors.toList())).build();
    }

    private static Distribution.Exemplar mapExemplar(ExemplarData exemplar, String projectId) {
        double value = 0.0;
        if (exemplar instanceof DoubleExemplarData) {
            value = ((DoubleExemplarData)exemplar).getValue();
        } else if (exemplar instanceof LongExemplarData) {
            value = ((LongExemplarData)exemplar).getValue();
        }
        Distribution.Exemplar.Builder exemplarBuilder = Distribution.Exemplar.newBuilder().setValue(value).setTimestamp(SpannerCloudMonitoringExporterUtils.mapTimestamp(exemplar.getEpochNanos()));
        if (exemplar.getSpanContext().isValid()) {
            exemplarBuilder.addAttachments(Any.pack((Message)SpanContext.newBuilder().setSpanName(SpannerCloudMonitoringExporterUtils.makeSpanName(projectId, exemplar.getSpanContext().getTraceId(), exemplar.getSpanContext().getSpanId())).build()));
        }
        if (!exemplar.getFilteredAttributes().isEmpty()) {
            exemplarBuilder.addAttachments(Any.pack((Message)SpannerCloudMonitoringExporterUtils.mapFilteredAttributes(exemplar.getFilteredAttributes())));
        }
        return exemplarBuilder.build();
    }

    private static Timestamp mapTimestamp(long epochNanos) {
        return Timestamp.newBuilder().setSeconds(epochNanos / 1000000000L).setNanos((int)(epochNanos % 1000000000L)).build();
    }

    private static String makeSpanName(String projectId, String traceId, String spanId) {
        return String.format("projects/%s/traces/%s/spans/%s", projectId, traceId, spanId);
    }

    private static DroppedLabels mapFilteredAttributes(Attributes attributes) {
        DroppedLabels.Builder labels = DroppedLabels.newBuilder();
        attributes.forEach((k, v) -> labels.putLabel(SpannerCloudMonitoringExporterUtils.cleanAttributeKey(k.getKey()), v.toString()));
        return labels.build();
    }

    private static String cleanAttributeKey(String key) {
        return key.replace('.', '_');
    }
}

