/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.MethodName;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.tracing.MetricsTracer;
import com.google.cloud.spanner.BuiltInMetricsRecorder;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.TraceWrapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;

class BuiltInMetricsTracer
extends MetricsTracer
implements ApiTracer {
    private final BuiltInMetricsRecorder builtInOpenTelemetryMetricsRecorder;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private Float gfeLatency = null;
    private Float afeLatency = null;
    private TraceWrapper traceWrapper;
    private long gfeHeaderMissingCount = 0L;
    private long afeHeaderMissingCount = 0L;
    private final ISpan currentSpan;

    BuiltInMetricsTracer(MethodName methodName, BuiltInMetricsRecorder builtInOpenTelemetryMetricsRecorder, TraceWrapper traceWrapper, ISpan currentSpan) {
        super(methodName, (MetricsRecorder)builtInOpenTelemetryMetricsRecorder);
        this.builtInOpenTelemetryMetricsRecorder = builtInOpenTelemetryMetricsRecorder;
        this.attributes.put("method", methodName.toString());
        this.traceWrapper = traceWrapper;
        this.currentSpan = currentSpan;
    }

    public void attemptSucceeded() {
        try (IScope s = this.traceWrapper.withSpan(this.currentSpan);){
            super.attemptSucceeded();
            this.attributes.put("status", StatusCode.Code.OK.toString());
            this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
        }
    }

    public void attemptCancelled() {
        try (IScope s = this.traceWrapper.withSpan(this.currentSpan);){
            super.attemptCancelled();
            this.attributes.put("status", StatusCode.Code.CANCELLED.toString());
            this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
        }
    }

    public void attemptFailedDuration(Throwable error, Duration delay) {
        try (IScope s = this.traceWrapper.withSpan(this.currentSpan);){
            super.attemptFailedDuration(error, delay);
            this.attributes.put("status", BuiltInMetricsTracer.extractStatus(error));
            this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
        }
    }

    public void attemptFailedRetriesExhausted(Throwable error) {
        try (IScope s = this.traceWrapper.withSpan(this.currentSpan);){
            super.attemptFailedRetriesExhausted(error);
            this.attributes.put("status", BuiltInMetricsTracer.extractStatus(error));
            this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
        }
    }

    public void attemptPermanentFailure(Throwable error) {
        try (IScope s = this.traceWrapper.withSpan(this.currentSpan);){
            super.attemptPermanentFailure(error);
            this.attributes.put("status", BuiltInMetricsTracer.extractStatus(error));
            this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
        }
    }

    void recordGFELatency(Float gfeLatency) {
        this.gfeLatency = gfeLatency;
    }

    void recordAFELatency(Float afeLatency) {
        this.afeLatency = afeLatency;
    }

    void recordGfeHeaderMissingCount(Long value) {
        this.gfeHeaderMissingCount = value;
    }

    void recordAfeHeaderMissingCount(Long value) {
        this.afeHeaderMissingCount = value;
    }

    public void addAttributes(Map<String, String> attributes) {
        super.addAttributes(attributes);
        this.attributes.putAll(attributes);
    }

    public void addAttributes(String key, String value) {
        super.addAttributes(key, value);
        this.attributes.put(key, value);
    }

    private static String extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return StatusCode.Code.OK.toString();
        }
        String statusString = error instanceof CancellationException ? StatusCode.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : StatusCode.Code.UNKNOWN.toString());
        return statusString;
    }
}

