/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingStructReader;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.PartitionedQueryResultSet;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

class MergedResultSet
extends ForwardingStructReader
implements PartitionedQueryResultSet {
    private final RowProducer rowProducer;
    private boolean closed;

    MergedResultSet(Connection connection, List<String> partitions, int maxParallelism) {
        this(((List)Preconditions.checkNotNull(partitions)).isEmpty() ? new EmptyRowProducer() : new RowProducerImpl(connection, partitions, maxParallelism));
    }

    private MergedResultSet(RowProducer rowProducer) {
        super(rowProducer);
        this.rowProducer = rowProducer;
    }

    @Override
    protected void checkValidState() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"This result set has been closed");
    }

    @Override
    public boolean next() throws SpannerException {
        this.checkValidState();
        try {
            return this.rowProducer.nextRow();
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
        catch (Throwable throwable) {
            throw SpannerExceptionFactory.asSpannerException(throwable);
        }
    }

    @Override
    public Struct getCurrentRowAsStruct() {
        this.checkValidState();
        return (Struct)this.rowProducer.get();
    }

    @Override
    public void close() {
        this.closed = true;
        this.rowProducer.close();
    }

    @Override
    public ResultSetStats getStats() {
        throw new UnsupportedOperationException("ResultSetStats are available only for results returned from analyzeQuery() calls");
    }

    @Override
    public ResultSetMetadata getMetadata() {
        this.checkValidState();
        return this.rowProducer.getMetadata();
    }

    @Override
    public Type getType() {
        this.checkValidState();
        return this.rowProducer.getType();
    }

    @Override
    public int getColumnCount() {
        return this.getType().getStructFields().size();
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.getType().getFieldIndex(columnName);
    }

    @Override
    public Type getColumnType(int columnIndex) {
        return this.getType().getStructFields().get(columnIndex).getType();
    }

    @Override
    public Type getColumnType(String columnName) {
        return this.getType().getStructFields().get(this.getColumnIndex(columnName)).getType();
    }

    @Override
    public int getNumPartitions() {
        return this.rowProducer.getNumPartitions();
    }

    @Override
    public int getParallelism() {
        return this.rowProducer.getParallelism();
    }

    static class EmptyRowProducer
    implements RowProducer {
        EmptyRowProducer() {
        }

        public Struct get() {
            return Struct.newBuilder().build();
        }

        @Override
        public boolean nextRow() {
            return false;
        }

        @Override
        public Type getType() {
            return Type.struct(new Type.StructField[0]);
        }

        @Override
        public ResultSetMetadata getMetadata() {
            return ResultSetMetadata.getDefaultInstance();
        }

        @Override
        public int getNumPartitions() {
            return 0;
        }

        @Override
        public int getParallelism() {
            return 0;
        }

        @Override
        public void close() {
        }
    }

    private static class RowProducerImpl
    implements RowProducer {
        private static final int QUEUE_SIZE_PER_WORKER = 32;
        private final ExecutorService executor;
        private final int parallelism;
        private final List<PartitionExecutor> partitionExecutors;
        private final AtomicInteger finishedCounter;
        private final LinkedBlockingDeque<PartitionExecutorResult> queue;
        private ResultSetMetadata metadata;
        private final CountDownLatch metadataAvailableLatch = new CountDownLatch(1);
        private Type type;
        private Struct currentRow;
        private Throwable exception;

        RowProducerImpl(Connection connection, List<String> partitions, int maxParallelism) {
            Preconditions.checkArgument((maxParallelism >= 0 ? 1 : 0) != 0, (Object)"maxParallelism must be >= 0");
            Preconditions.checkArgument((!((List)Preconditions.checkNotNull(partitions)).isEmpty() ? 1 : 0) != 0, (Object)"partitions must not be empty");
            this.parallelism = maxParallelism == 0 ? Math.min(partitions.size(), Runtime.getRuntime().availableProcessors()) : Math.min(partitions.size(), maxParallelism);
            this.executor = Executors.newFixedThreadPool(this.parallelism, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("partitioned-query-row-producer");
                thread.setDaemon(true);
                return thread;
            });
            this.queue = new LinkedBlockingDeque(32 * this.parallelism);
            this.partitionExecutors = new ArrayList<PartitionExecutor>(partitions.size());
            this.finishedCounter = new AtomicInteger(partitions.size());
            for (String partition : partitions) {
                PartitionExecutor partitionExecutor = new PartitionExecutor(connection, partition, this.queue, this.metadataAvailableLatch);
                this.partitionExecutors.add(partitionExecutor);
                this.executor.submit(partitionExecutor);
            }
            this.executor.shutdown();
        }

        @Override
        public void close() {
            this.partitionExecutors.forEach(partitionExecutor -> ((PartitionExecutor)partitionExecutor).shouldStop.set(true));
            this.executor.shutdownNow();
        }

        @Override
        public boolean nextRow() throws Throwable {
            if (this.exception != null) {
                throw this.exception;
            }
            while (true) {
                PartitionExecutorResult next;
                if ((next = this.queue.peek()) != null && !next.isFinished() && this.setNextRow(this.queue.remove())) {
                    return true;
                }
                next = this.queue.take();
                if (next.isFinished()) {
                    this.finishedCounter.decrementAndGet();
                    if (this.finishedCounter.get() != 0) continue;
                    return false;
                }
                if (this.setNextRow(next)) break;
            }
            return true;
        }

        boolean setNextRow(PartitionExecutorResult next) throws Throwable {
            if (next.exception != null) {
                this.exception = next.exception;
                throw next.exception;
            }
            this.currentRow = next.data;
            if (this.metadata == null && next.metadata != null) {
                this.metadata = next.metadata;
            }
            if (this.type == null && next.type != null) {
                this.type = next.type;
            }
            return next.hasData();
        }

        public Struct get() {
            Preconditions.checkState((this.currentRow != null ? 1 : 0) != 0, (Object)"next() call required");
            return this.currentRow;
        }

        private PartitionExecutorResult getFirstResultWithMetadata() {
            try {
                this.metadataAvailableLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
            }
            PartitionExecutorResult result = this.queue.stream().filter(rs -> ((PartitionExecutorResult)rs).metadata != null || ((PartitionExecutorResult)rs).exception != null).findFirst().orElse(null);
            if (result == null) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Thread-unsafe access to ResultSet");
            }
            if (result.exception != null) {
                throw SpannerExceptionFactory.asSpannerException(result.exception);
            }
            return result;
        }

        @Override
        public ResultSetMetadata getMetadata() {
            if (this.metadata == null) {
                return this.getFirstResultWithMetadata().metadata;
            }
            return this.metadata;
        }

        @Override
        public int getNumPartitions() {
            return this.partitionExecutors.size();
        }

        @Override
        public int getParallelism() {
            return this.parallelism;
        }

        @Override
        public Type getType() {
            if (this.type == null) {
                return this.getFirstResultWithMetadata().type;
            }
            return this.type;
        }
    }

    static interface RowProducer
    extends Supplier<Struct> {
        public boolean nextRow() throws Throwable;

        public void close();

        public Type getType();

        public ResultSetMetadata getMetadata();

        public int getNumPartitions();

        public int getParallelism();
    }

    static class PartitionExecutorResult {
        private final Struct data;
        private final Throwable exception;
        private final Type type;
        private final ResultSetMetadata metadata;

        static PartitionExecutorResult data(@Nonnull Struct data) {
            return new PartitionExecutorResult((Struct)Preconditions.checkNotNull((Object)data), null, null, null);
        }

        static PartitionExecutorResult typeAndMetadata(@Nonnull Type type, @Nonnull ResultSetMetadata metadata) {
            return new PartitionExecutorResult(null, (Type)Preconditions.checkNotNull((Object)type), (ResultSetMetadata)Preconditions.checkNotNull((Object)metadata), null);
        }

        static PartitionExecutorResult dataAndMetadata(@Nonnull Struct data, @Nonnull Type type, @Nonnull ResultSetMetadata metadata) {
            return new PartitionExecutorResult((Struct)Preconditions.checkNotNull((Object)data), (Type)Preconditions.checkNotNull((Object)type), (ResultSetMetadata)Preconditions.checkNotNull((Object)metadata), null);
        }

        static PartitionExecutorResult exception(@Nonnull Throwable exception) {
            return new PartitionExecutorResult(null, null, null, (Throwable)Preconditions.checkNotNull((Object)exception));
        }

        static PartitionExecutorResult finished() {
            return new PartitionExecutorResult(null, null, null, null);
        }

        private PartitionExecutorResult(Struct data, Type type, ResultSetMetadata metadata, Throwable exception) {
            this.data = data;
            this.type = type;
            this.metadata = metadata;
            this.exception = exception;
        }

        boolean hasData() {
            return this.data != null;
        }

        boolean isFinished() {
            return this.data == null && this.type == null && this.metadata == null && this.exception == null;
        }
    }

    static class PartitionExecutor
    implements Runnable {
        private final Connection connection;
        private final String partitionId;
        private final LinkedBlockingDeque<PartitionExecutorResult> queue;
        private final CountDownLatch metadataAvailableLatch;
        private final AtomicBoolean shouldStop = new AtomicBoolean();

        PartitionExecutor(Connection connection, String partitionId, LinkedBlockingDeque<PartitionExecutorResult> queue, CountDownLatch metadataAvailableLatch) {
            this.connection = (Connection)Preconditions.checkNotNull((Object)connection);
            this.partitionId = (String)Preconditions.checkNotNull((Object)partitionId);
            this.queue = queue;
            this.metadataAvailableLatch = (CountDownLatch)Preconditions.checkNotNull((Object)metadataAvailableLatch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (ResultSet resultSet = this.connection.runPartition(this.partitionId);){
                boolean first = true;
                while (resultSet.next()) {
                    Struct row = resultSet.getCurrentRowAsStruct();
                    if (first) {
                        this.queue.put(PartitionExecutorResult.dataAndMetadata(row, resultSet.getType(), resultSet.getMetadata()));
                        this.metadataAvailableLatch.countDown();
                        first = false;
                    } else {
                        this.queue.put(PartitionExecutorResult.data(row));
                    }
                    if (!this.shouldStop.get()) continue;
                    break;
                }
                if (first && resultSet.getType().getCode() == Type.Code.STRUCT && !resultSet.getType().getStructFields().isEmpty()) {
                    this.queue.put(PartitionExecutorResult.typeAndMetadata(resultSet.getType(), resultSet.getMetadata()));
                    this.metadataAvailableLatch.countDown();
                }
            }
            catch (Throwable exception) {
                this.putWithoutInterruptPropagation(PartitionExecutorResult.exception(exception));
                this.metadataAvailableLatch.countDown();
            }
            finally {
                this.putWithoutInterruptPropagation(PartitionExecutorResult.finished());
            }
        }

        private void putWithoutInterruptPropagation(PartitionExecutorResult result) {
            try {
                this.queue.put(result);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

