/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;

public class TraceContextInterceptor
implements ClientInterceptor {
    private final TextMapPropagator textMapPropagator;

    public TraceContextInterceptor(OpenTelemetry openTelemetry) {
        this.textMapPropagator = openTelemetry.getPropagators().getTextMapPropagator();
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Context parentContext = Context.current();
                TraceContextInterceptor.this.textMapPropagator.inject(parentContext, (Object)headers, (TextMapSetter)MetadataSetter.INSTANCE);
                super.start(new NoopSimpleForwardingClientCallListener(responseListener), headers);
            }
        };
    }

    private static final class NoopSimpleForwardingClientCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        public NoopSimpleForwardingClientCallListener(ClientCall.Listener<RespT> responseListener) {
            super(responseListener);
        }
    }

    static enum MetadataSetter implements TextMapSetter<Metadata>
    {
        INSTANCE;


        public void set(Metadata carrier, String key, String value) {
            carrier.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        }
    }
}

