/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1beta1.AsyncRecognizeMetadata;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.AsyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.RecognitionAudio;
import com.google.cloud.speech.v1beta1.RecognitionConfig;
import com.google.cloud.speech.v1beta1.SpeechSettings;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.stub.SpeechStub;
import com.google.cloud.speech.v1beta1.stub.SpeechStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SpeechClient
implements BackgroundResource {
    private final SpeechSettings settings;
    private final SpeechStub stub;
    private final OperationsClient operationsClient;

    public static final SpeechClient create() throws IOException {
        return SpeechClient.create(SpeechSettings.newBuilder().build());
    }

    public static final SpeechClient create(SpeechSettings settings) throws IOException {
        return new SpeechClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SpeechClient create(SpeechStub stub) {
        return new SpeechClient(stub);
    }

    protected SpeechClient(SpeechSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpeechStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SpeechClient(SpeechStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final SpeechSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SpeechStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final SyncRecognizeResponse syncRecognize(RecognitionConfig config, RecognitionAudio audio) {
        SyncRecognizeRequest request = SyncRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.syncRecognize(request);
    }

    public final SyncRecognizeResponse syncRecognize(SyncRecognizeRequest request) {
        return (SyncRecognizeResponse)this.syncRecognizeCallable().call((Object)request);
    }

    public final UnaryCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable() {
        return this.stub.syncRecognizeCallable();
    }

    public final OperationFuture<AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeAsync(RecognitionConfig config, RecognitionAudio audio) {
        AsyncRecognizeRequest request = AsyncRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.asyncRecognizeAsync(request);
    }

    public final OperationFuture<AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeAsync(AsyncRecognizeRequest request) {
        return this.asyncRecognizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeOperationCallable() {
        return this.stub.asyncRecognizeOperationCallable();
    }

    public final UnaryCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable() {
        return this.stub.asyncRecognizeCallable();
    }

    public final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.stub.streamingRecognizeCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

