/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.speech.v2.BatchRecognizeRequest;
import com.google.cloud.speech.v2.BatchRecognizeResponse;
import com.google.cloud.speech.v2.Config;
import com.google.cloud.speech.v2.CreateCustomClassRequest;
import com.google.cloud.speech.v2.CreatePhraseSetRequest;
import com.google.cloud.speech.v2.CreateRecognizerRequest;
import com.google.cloud.speech.v2.CustomClass;
import com.google.cloud.speech.v2.DeleteCustomClassRequest;
import com.google.cloud.speech.v2.DeletePhraseSetRequest;
import com.google.cloud.speech.v2.DeleteRecognizerRequest;
import com.google.cloud.speech.v2.GetConfigRequest;
import com.google.cloud.speech.v2.GetCustomClassRequest;
import com.google.cloud.speech.v2.GetPhraseSetRequest;
import com.google.cloud.speech.v2.GetRecognizerRequest;
import com.google.cloud.speech.v2.ListCustomClassesRequest;
import com.google.cloud.speech.v2.ListCustomClassesResponse;
import com.google.cloud.speech.v2.ListPhraseSetsRequest;
import com.google.cloud.speech.v2.ListPhraseSetsResponse;
import com.google.cloud.speech.v2.ListRecognizersRequest;
import com.google.cloud.speech.v2.ListRecognizersResponse;
import com.google.cloud.speech.v2.OperationMetadata;
import com.google.cloud.speech.v2.PhraseSet;
import com.google.cloud.speech.v2.RecognizeRequest;
import com.google.cloud.speech.v2.RecognizeResponse;
import com.google.cloud.speech.v2.Recognizer;
import com.google.cloud.speech.v2.SpeechClient;
import com.google.cloud.speech.v2.StreamingRecognizeRequest;
import com.google.cloud.speech.v2.StreamingRecognizeResponse;
import com.google.cloud.speech.v2.UndeleteCustomClassRequest;
import com.google.cloud.speech.v2.UndeletePhraseSetRequest;
import com.google.cloud.speech.v2.UndeleteRecognizerRequest;
import com.google.cloud.speech.v2.UpdateConfigRequest;
import com.google.cloud.speech.v2.UpdateCustomClassRequest;
import com.google.cloud.speech.v2.UpdatePhraseSetRequest;
import com.google.cloud.speech.v2.UpdateRecognizerRequest;
import com.google.cloud.speech.v2.stub.HttpJsonSpeechCallableFactory;
import com.google.cloud.speech.v2.stub.SpeechStub;
import com.google.cloud.speech.v2.stub.SpeechStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSpeechStub
extends SpeechStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(OperationMetadata.getDescriptor()).add(CustomClass.getDescriptor()).add(Recognizer.getDescriptor()).add(PhraseSet.getDescriptor()).add(BatchRecognizeResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateRecognizerRequest, Operation> createRecognizerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/CreateRecognizer").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/recognizers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "recognizerId", (Object)request.getRecognizerId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("recognizer", (Message)request.getRecognizer(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListRecognizersRequest, ListRecognizersResponse> listRecognizersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/ListRecognizers").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/recognizers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRecognizersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRecognizerRequest, Recognizer> getRecognizerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/GetRecognizer").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/recognizers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Recognizer.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRecognizerRequest, Operation> updateRecognizerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UpdateRecognizer").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{recognizer.name=projects/*/locations/*/recognizers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "recognizer.name", (Object)request.getRecognizer().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("recognizer", (Message)request.getRecognizer(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteRecognizerRequest, Operation> deleteRecognizerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/DeleteRecognizer").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/recognizers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeleteRecognizerRequest, Operation> undeleteRecognizerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UndeleteRecognizer").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/recognizers/*}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RecognizeRequest, RecognizeResponse> recognizeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/Recognize").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{recognizer=projects/*/locations/*/recognizers/*}:recognize", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "recognizer", (Object)request.getRecognizer());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRecognizer().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RecognizeResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchRecognizeRequest, Operation> batchRecognizeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/BatchRecognize").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{recognizer=projects/*/locations/*/recognizers/*}:batchRecognize", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "recognizer", (Object)request.getRecognizer());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRecognizer().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetConfigRequest, Config> getConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/GetConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/config}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Config.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateConfigRequest, Config> updateConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UpdateConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{config.name=projects/*/locations/*/config}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "config.name", (Object)request.getConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("config", (Message)request.getConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Config.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCustomClassRequest, Operation> createCustomClassMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/CreateCustomClass").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/customClasses", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "customClassId", (Object)request.getCustomClassId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("customClass", (Message)request.getCustomClass(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/ListCustomClasses").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/customClasses", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCustomClassesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCustomClassRequest, CustomClass> getCustomClassMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/GetCustomClass").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/customClasses/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CustomClass.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCustomClassRequest, Operation> updateCustomClassMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UpdateCustomClass").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{customClass.name=projects/*/locations/*/customClasses/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "customClass.name", (Object)request.getCustomClass().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("customClass", (Message)request.getCustomClass(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteCustomClassRequest, Operation> deleteCustomClassMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/DeleteCustomClass").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/customClasses/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeleteCustomClassRequest, Operation> undeleteCustomClassMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UndeleteCustomClass").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/customClasses/*}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreatePhraseSetRequest, Operation> createPhraseSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/CreatePhraseSet").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/phraseSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "phraseSetId", (Object)request.getPhraseSetId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("phraseSet", (Message)request.getPhraseSet(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/ListPhraseSets").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/phraseSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPhraseSetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPhraseSetRequest, PhraseSet> getPhraseSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/GetPhraseSet").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/phraseSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PhraseSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdatePhraseSetRequest, Operation> updatePhraseSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UpdatePhraseSet").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{phraseSet.name=projects/*/locations/*/phraseSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "phraseSet.name", (Object)request.getPhraseSet().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("phraseSet", (Message)request.getPhraseSet(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeletePhraseSetRequest, Operation> deletePhraseSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/DeletePhraseSet").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/phraseSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeletePhraseSetRequest, Operation> undeletePhraseSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.speech.v2.Speech/UndeletePhraseSet").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/phraseSets/*}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateRecognizerRequest, Operation> createRecognizerCallable;
    private final OperationCallable<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationCallable;
    private final UnaryCallable<ListRecognizersRequest, ListRecognizersResponse> listRecognizersCallable;
    private final UnaryCallable<ListRecognizersRequest, SpeechClient.ListRecognizersPagedResponse> listRecognizersPagedCallable;
    private final UnaryCallable<GetRecognizerRequest, Recognizer> getRecognizerCallable;
    private final UnaryCallable<UpdateRecognizerRequest, Operation> updateRecognizerCallable;
    private final OperationCallable<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationCallable;
    private final UnaryCallable<DeleteRecognizerRequest, Operation> deleteRecognizerCallable;
    private final OperationCallable<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationCallable;
    private final UnaryCallable<UndeleteRecognizerRequest, Operation> undeleteRecognizerCallable;
    private final OperationCallable<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationCallable;
    private final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable;
    private final UnaryCallable<BatchRecognizeRequest, Operation> batchRecognizeCallable;
    private final OperationCallable<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationCallable;
    private final UnaryCallable<GetConfigRequest, Config> getConfigCallable;
    private final UnaryCallable<UpdateConfigRequest, Config> updateConfigCallable;
    private final UnaryCallable<CreateCustomClassRequest, Operation> createCustomClassCallable;
    private final OperationCallable<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationCallable;
    private final UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable;
    private final UnaryCallable<ListCustomClassesRequest, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesPagedCallable;
    private final UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable;
    private final UnaryCallable<UpdateCustomClassRequest, Operation> updateCustomClassCallable;
    private final OperationCallable<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationCallable;
    private final UnaryCallable<DeleteCustomClassRequest, Operation> deleteCustomClassCallable;
    private final OperationCallable<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationCallable;
    private final UnaryCallable<UndeleteCustomClassRequest, Operation> undeleteCustomClassCallable;
    private final OperationCallable<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationCallable;
    private final UnaryCallable<CreatePhraseSetRequest, Operation> createPhraseSetCallable;
    private final OperationCallable<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationCallable;
    private final UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsCallable;
    private final UnaryCallable<ListPhraseSetsRequest, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsPagedCallable;
    private final UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable;
    private final UnaryCallable<UpdatePhraseSetRequest, Operation> updatePhraseSetCallable;
    private final OperationCallable<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationCallable;
    private final UnaryCallable<DeletePhraseSetRequest, Operation> deletePhraseSetCallable;
    private final OperationCallable<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationCallable;
    private final UnaryCallable<UndeletePhraseSetRequest, Operation> undeletePhraseSetCallable;
    private final OperationCallable<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, SpeechClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSpeechStub create(SpeechStubSettings settings) throws IOException {
        return new HttpJsonSpeechStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSpeechStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSpeechStub(SpeechStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSpeechStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSpeechStub(SpeechStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSpeechStub(SpeechStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSpeechCallableFactory());
    }

    protected HttpJsonSpeechStub(SpeechStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v2/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings createRecognizerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRecognizerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listRecognizersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRecognizersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRecognizerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRecognizerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateRecognizerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRecognizerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteRecognizerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRecognizerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings undeleteRecognizerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeleteRecognizerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings recognizeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(recognizeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchRecognizeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchRecognizeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createCustomClassTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCustomClassMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCustomClassesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCustomClassesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getCustomClassTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCustomClassMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCustomClassTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCustomClassMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteCustomClassTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteCustomClassMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings undeleteCustomClassTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeleteCustomClassMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createPhraseSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPhraseSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listPhraseSetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPhraseSetsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getPhraseSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPhraseSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updatePhraseSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updatePhraseSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deletePhraseSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deletePhraseSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings undeletePhraseSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeletePhraseSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createRecognizerCallable = callableFactory.createUnaryCallable(createRecognizerTransportSettings, settings.createRecognizerSettings(), clientContext);
        this.createRecognizerOperationCallable = callableFactory.createOperationCallable(createRecognizerTransportSettings, settings.createRecognizerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listRecognizersCallable = callableFactory.createUnaryCallable(listRecognizersTransportSettings, settings.listRecognizersSettings(), clientContext);
        this.listRecognizersPagedCallable = callableFactory.createPagedCallable(listRecognizersTransportSettings, settings.listRecognizersSettings(), clientContext);
        this.getRecognizerCallable = callableFactory.createUnaryCallable(getRecognizerTransportSettings, settings.getRecognizerSettings(), clientContext);
        this.updateRecognizerCallable = callableFactory.createUnaryCallable(updateRecognizerTransportSettings, settings.updateRecognizerSettings(), clientContext);
        this.updateRecognizerOperationCallable = callableFactory.createOperationCallable(updateRecognizerTransportSettings, settings.updateRecognizerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteRecognizerCallable = callableFactory.createUnaryCallable(deleteRecognizerTransportSettings, settings.deleteRecognizerSettings(), clientContext);
        this.deleteRecognizerOperationCallable = callableFactory.createOperationCallable(deleteRecognizerTransportSettings, settings.deleteRecognizerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeleteRecognizerCallable = callableFactory.createUnaryCallable(undeleteRecognizerTransportSettings, settings.undeleteRecognizerSettings(), clientContext);
        this.undeleteRecognizerOperationCallable = callableFactory.createOperationCallable(undeleteRecognizerTransportSettings, settings.undeleteRecognizerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.recognizeCallable = callableFactory.createUnaryCallable(recognizeTransportSettings, settings.recognizeSettings(), clientContext);
        this.batchRecognizeCallable = callableFactory.createUnaryCallable(batchRecognizeTransportSettings, settings.batchRecognizeSettings(), clientContext);
        this.batchRecognizeOperationCallable = callableFactory.createOperationCallable(batchRecognizeTransportSettings, settings.batchRecognizeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getConfigCallable = callableFactory.createUnaryCallable(getConfigTransportSettings, settings.getConfigSettings(), clientContext);
        this.updateConfigCallable = callableFactory.createUnaryCallable(updateConfigTransportSettings, settings.updateConfigSettings(), clientContext);
        this.createCustomClassCallable = callableFactory.createUnaryCallable(createCustomClassTransportSettings, settings.createCustomClassSettings(), clientContext);
        this.createCustomClassOperationCallable = callableFactory.createOperationCallable(createCustomClassTransportSettings, settings.createCustomClassOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCustomClassesCallable = callableFactory.createUnaryCallable(listCustomClassesTransportSettings, settings.listCustomClassesSettings(), clientContext);
        this.listCustomClassesPagedCallable = callableFactory.createPagedCallable(listCustomClassesTransportSettings, settings.listCustomClassesSettings(), clientContext);
        this.getCustomClassCallable = callableFactory.createUnaryCallable(getCustomClassTransportSettings, settings.getCustomClassSettings(), clientContext);
        this.updateCustomClassCallable = callableFactory.createUnaryCallable(updateCustomClassTransportSettings, settings.updateCustomClassSettings(), clientContext);
        this.updateCustomClassOperationCallable = callableFactory.createOperationCallable(updateCustomClassTransportSettings, settings.updateCustomClassOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteCustomClassCallable = callableFactory.createUnaryCallable(deleteCustomClassTransportSettings, settings.deleteCustomClassSettings(), clientContext);
        this.deleteCustomClassOperationCallable = callableFactory.createOperationCallable(deleteCustomClassTransportSettings, settings.deleteCustomClassOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeleteCustomClassCallable = callableFactory.createUnaryCallable(undeleteCustomClassTransportSettings, settings.undeleteCustomClassSettings(), clientContext);
        this.undeleteCustomClassOperationCallable = callableFactory.createOperationCallable(undeleteCustomClassTransportSettings, settings.undeleteCustomClassOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createPhraseSetCallable = callableFactory.createUnaryCallable(createPhraseSetTransportSettings, settings.createPhraseSetSettings(), clientContext);
        this.createPhraseSetOperationCallable = callableFactory.createOperationCallable(createPhraseSetTransportSettings, settings.createPhraseSetOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listPhraseSetsCallable = callableFactory.createUnaryCallable(listPhraseSetsTransportSettings, settings.listPhraseSetsSettings(), clientContext);
        this.listPhraseSetsPagedCallable = callableFactory.createPagedCallable(listPhraseSetsTransportSettings, settings.listPhraseSetsSettings(), clientContext);
        this.getPhraseSetCallable = callableFactory.createUnaryCallable(getPhraseSetTransportSettings, settings.getPhraseSetSettings(), clientContext);
        this.updatePhraseSetCallable = callableFactory.createUnaryCallable(updatePhraseSetTransportSettings, settings.updatePhraseSetSettings(), clientContext);
        this.updatePhraseSetOperationCallable = callableFactory.createOperationCallable(updatePhraseSetTransportSettings, settings.updatePhraseSetOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deletePhraseSetCallable = callableFactory.createUnaryCallable(deletePhraseSetTransportSettings, settings.deletePhraseSetSettings(), clientContext);
        this.deletePhraseSetOperationCallable = callableFactory.createOperationCallable(deletePhraseSetTransportSettings, settings.deletePhraseSetOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeletePhraseSetCallable = callableFactory.createUnaryCallable(undeletePhraseSetTransportSettings, settings.undeletePhraseSetSettings(), clientContext);
        this.undeletePhraseSetOperationCallable = callableFactory.createOperationCallable(undeletePhraseSetTransportSettings, settings.undeletePhraseSetOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createRecognizerMethodDescriptor);
        methodDescriptors.add(listRecognizersMethodDescriptor);
        methodDescriptors.add(getRecognizerMethodDescriptor);
        methodDescriptors.add(updateRecognizerMethodDescriptor);
        methodDescriptors.add(deleteRecognizerMethodDescriptor);
        methodDescriptors.add(undeleteRecognizerMethodDescriptor);
        methodDescriptors.add(recognizeMethodDescriptor);
        methodDescriptors.add(batchRecognizeMethodDescriptor);
        methodDescriptors.add(getConfigMethodDescriptor);
        methodDescriptors.add(updateConfigMethodDescriptor);
        methodDescriptors.add(createCustomClassMethodDescriptor);
        methodDescriptors.add(listCustomClassesMethodDescriptor);
        methodDescriptors.add(getCustomClassMethodDescriptor);
        methodDescriptors.add(updateCustomClassMethodDescriptor);
        methodDescriptors.add(deleteCustomClassMethodDescriptor);
        methodDescriptors.add(undeleteCustomClassMethodDescriptor);
        methodDescriptors.add(createPhraseSetMethodDescriptor);
        methodDescriptors.add(listPhraseSetsMethodDescriptor);
        methodDescriptors.add(getPhraseSetMethodDescriptor);
        methodDescriptors.add(updatePhraseSetMethodDescriptor);
        methodDescriptors.add(deletePhraseSetMethodDescriptor);
        methodDescriptors.add(undeletePhraseSetMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateRecognizerRequest, Operation> createRecognizerCallable() {
        return this.createRecognizerCallable;
    }

    @Override
    public OperationCallable<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationCallable() {
        return this.createRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<ListRecognizersRequest, ListRecognizersResponse> listRecognizersCallable() {
        return this.listRecognizersCallable;
    }

    @Override
    public UnaryCallable<ListRecognizersRequest, SpeechClient.ListRecognizersPagedResponse> listRecognizersPagedCallable() {
        return this.listRecognizersPagedCallable;
    }

    @Override
    public UnaryCallable<GetRecognizerRequest, Recognizer> getRecognizerCallable() {
        return this.getRecognizerCallable;
    }

    @Override
    public UnaryCallable<UpdateRecognizerRequest, Operation> updateRecognizerCallable() {
        return this.updateRecognizerCallable;
    }

    @Override
    public OperationCallable<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationCallable() {
        return this.updateRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRecognizerRequest, Operation> deleteRecognizerCallable() {
        return this.deleteRecognizerCallable;
    }

    @Override
    public OperationCallable<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationCallable() {
        return this.deleteRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteRecognizerRequest, Operation> undeleteRecognizerCallable() {
        return this.undeleteRecognizerCallable;
    }

    @Override
    public OperationCallable<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationCallable() {
        return this.undeleteRecognizerOperationCallable;
    }

    @Override
    public UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.recognizeCallable;
    }

    @Override
    public UnaryCallable<BatchRecognizeRequest, Operation> batchRecognizeCallable() {
        return this.batchRecognizeCallable;
    }

    @Override
    public OperationCallable<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationCallable() {
        return this.batchRecognizeOperationCallable;
    }

    @Override
    public UnaryCallable<GetConfigRequest, Config> getConfigCallable() {
        return this.getConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateConfigRequest, Config> updateConfigCallable() {
        return this.updateConfigCallable;
    }

    @Override
    public UnaryCallable<CreateCustomClassRequest, Operation> createCustomClassCallable() {
        return this.createCustomClassCallable;
    }

    @Override
    public OperationCallable<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationCallable() {
        return this.createCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable() {
        return this.listCustomClassesCallable;
    }

    @Override
    public UnaryCallable<ListCustomClassesRequest, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesPagedCallable() {
        return this.listCustomClassesPagedCallable;
    }

    @Override
    public UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable() {
        return this.getCustomClassCallable;
    }

    @Override
    public UnaryCallable<UpdateCustomClassRequest, Operation> updateCustomClassCallable() {
        return this.updateCustomClassCallable;
    }

    @Override
    public OperationCallable<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationCallable() {
        return this.updateCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteCustomClassRequest, Operation> deleteCustomClassCallable() {
        return this.deleteCustomClassCallable;
    }

    @Override
    public OperationCallable<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationCallable() {
        return this.deleteCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteCustomClassRequest, Operation> undeleteCustomClassCallable() {
        return this.undeleteCustomClassCallable;
    }

    @Override
    public OperationCallable<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationCallable() {
        return this.undeleteCustomClassOperationCallable;
    }

    @Override
    public UnaryCallable<CreatePhraseSetRequest, Operation> createPhraseSetCallable() {
        return this.createPhraseSetCallable;
    }

    @Override
    public OperationCallable<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationCallable() {
        return this.createPhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsCallable() {
        return this.listPhraseSetsCallable;
    }

    @Override
    public UnaryCallable<ListPhraseSetsRequest, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsPagedCallable() {
        return this.listPhraseSetsPagedCallable;
    }

    @Override
    public UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable() {
        return this.getPhraseSetCallable;
    }

    @Override
    public UnaryCallable<UpdatePhraseSetRequest, Operation> updatePhraseSetCallable() {
        return this.updatePhraseSetCallable;
    }

    @Override
    public OperationCallable<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationCallable() {
        return this.updatePhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<DeletePhraseSetRequest, Operation> deletePhraseSetCallable() {
        return this.deletePhraseSetCallable;
    }

    @Override
    public OperationCallable<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationCallable() {
        return this.deletePhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<UndeletePhraseSetRequest, Operation> undeletePhraseSetCallable() {
        return this.undeletePhraseSetCallable;
    }

    @Override
    public OperationCallable<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationCallable() {
        return this.undeletePhraseSetOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, SpeechClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        throw new UnsupportedOperationException("Not implemented: streamingRecognizeCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

