/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.speech.v2.BatchRecognizeRequest;
import com.google.cloud.speech.v2.BatchRecognizeResponse;
import com.google.cloud.speech.v2.Config;
import com.google.cloud.speech.v2.CreateCustomClassRequest;
import com.google.cloud.speech.v2.CreatePhraseSetRequest;
import com.google.cloud.speech.v2.CreateRecognizerRequest;
import com.google.cloud.speech.v2.CustomClass;
import com.google.cloud.speech.v2.DeleteCustomClassRequest;
import com.google.cloud.speech.v2.DeletePhraseSetRequest;
import com.google.cloud.speech.v2.DeleteRecognizerRequest;
import com.google.cloud.speech.v2.GetConfigRequest;
import com.google.cloud.speech.v2.GetCustomClassRequest;
import com.google.cloud.speech.v2.GetPhraseSetRequest;
import com.google.cloud.speech.v2.GetRecognizerRequest;
import com.google.cloud.speech.v2.ListCustomClassesRequest;
import com.google.cloud.speech.v2.ListCustomClassesResponse;
import com.google.cloud.speech.v2.ListPhraseSetsRequest;
import com.google.cloud.speech.v2.ListPhraseSetsResponse;
import com.google.cloud.speech.v2.ListRecognizersRequest;
import com.google.cloud.speech.v2.ListRecognizersResponse;
import com.google.cloud.speech.v2.OperationMetadata;
import com.google.cloud.speech.v2.PhraseSet;
import com.google.cloud.speech.v2.RecognizeRequest;
import com.google.cloud.speech.v2.RecognizeResponse;
import com.google.cloud.speech.v2.Recognizer;
import com.google.cloud.speech.v2.SpeechClient;
import com.google.cloud.speech.v2.StreamingRecognizeRequest;
import com.google.cloud.speech.v2.StreamingRecognizeResponse;
import com.google.cloud.speech.v2.UndeleteCustomClassRequest;
import com.google.cloud.speech.v2.UndeletePhraseSetRequest;
import com.google.cloud.speech.v2.UndeleteRecognizerRequest;
import com.google.cloud.speech.v2.UpdateConfigRequest;
import com.google.cloud.speech.v2.UpdateCustomClassRequest;
import com.google.cloud.speech.v2.UpdatePhraseSetRequest;
import com.google.cloud.speech.v2.UpdateRecognizerRequest;
import com.google.cloud.speech.v2.stub.GrpcSpeechStub;
import com.google.cloud.speech.v2.stub.HttpJsonSpeechStub;
import com.google.cloud.speech.v2.stub.SpeechStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SpeechStubSettings
extends StubSettings<SpeechStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateRecognizerRequest, Operation> createRecognizerSettings;
    private final OperationCallSettings<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationSettings;
    private final PagedCallSettings<ListRecognizersRequest, ListRecognizersResponse, SpeechClient.ListRecognizersPagedResponse> listRecognizersSettings;
    private final UnaryCallSettings<GetRecognizerRequest, Recognizer> getRecognizerSettings;
    private final UnaryCallSettings<UpdateRecognizerRequest, Operation> updateRecognizerSettings;
    private final OperationCallSettings<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationSettings;
    private final UnaryCallSettings<DeleteRecognizerRequest, Operation> deleteRecognizerSettings;
    private final OperationCallSettings<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationSettings;
    private final UnaryCallSettings<UndeleteRecognizerRequest, Operation> undeleteRecognizerSettings;
    private final OperationCallSettings<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationSettings;
    private final UnaryCallSettings<RecognizeRequest, RecognizeResponse> recognizeSettings;
    private final StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;
    private final UnaryCallSettings<BatchRecognizeRequest, Operation> batchRecognizeSettings;
    private final OperationCallSettings<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationSettings;
    private final UnaryCallSettings<GetConfigRequest, Config> getConfigSettings;
    private final UnaryCallSettings<UpdateConfigRequest, Config> updateConfigSettings;
    private final UnaryCallSettings<CreateCustomClassRequest, Operation> createCustomClassSettings;
    private final OperationCallSettings<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationSettings;
    private final PagedCallSettings<ListCustomClassesRequest, ListCustomClassesResponse, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesSettings;
    private final UnaryCallSettings<GetCustomClassRequest, CustomClass> getCustomClassSettings;
    private final UnaryCallSettings<UpdateCustomClassRequest, Operation> updateCustomClassSettings;
    private final OperationCallSettings<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationSettings;
    private final UnaryCallSettings<DeleteCustomClassRequest, Operation> deleteCustomClassSettings;
    private final OperationCallSettings<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationSettings;
    private final UnaryCallSettings<UndeleteCustomClassRequest, Operation> undeleteCustomClassSettings;
    private final OperationCallSettings<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationSettings;
    private final UnaryCallSettings<CreatePhraseSetRequest, Operation> createPhraseSetSettings;
    private final OperationCallSettings<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationSettings;
    private final PagedCallSettings<ListPhraseSetsRequest, ListPhraseSetsResponse, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsSettings;
    private final UnaryCallSettings<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings;
    private final UnaryCallSettings<UpdatePhraseSetRequest, Operation> updatePhraseSetSettings;
    private final OperationCallSettings<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationSettings;
    private final UnaryCallSettings<DeletePhraseSetRequest, Operation> deletePhraseSetSettings;
    private final OperationCallSettings<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationSettings;
    private final UnaryCallSettings<UndeletePhraseSetRequest, Operation> undeletePhraseSetSettings;
    private final OperationCallSettings<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SpeechClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListRecognizersRequest, ListRecognizersResponse, Recognizer> LIST_RECOGNIZERS_PAGE_STR_DESC = new PagedListDescriptor<ListRecognizersRequest, ListRecognizersResponse, Recognizer>(){

        public String emptyToken() {
            return "";
        }

        public ListRecognizersRequest injectToken(ListRecognizersRequest payload, String token) {
            return ListRecognizersRequest.newBuilder((ListRecognizersRequest)payload).setPageToken(token).build();
        }

        public ListRecognizersRequest injectPageSize(ListRecognizersRequest payload, int pageSize) {
            return ListRecognizersRequest.newBuilder((ListRecognizersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRecognizersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRecognizersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Recognizer> extractResources(ListRecognizersResponse payload) {
            return payload.getRecognizersList();
        }
    };
    private static final PagedListDescriptor<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> LIST_CUSTOM_CLASSES_PAGE_STR_DESC = new PagedListDescriptor<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomClassesRequest injectToken(ListCustomClassesRequest payload, String token) {
            return ListCustomClassesRequest.newBuilder((ListCustomClassesRequest)payload).setPageToken(token).build();
        }

        public ListCustomClassesRequest injectPageSize(ListCustomClassesRequest payload, int pageSize) {
            return ListCustomClassesRequest.newBuilder((ListCustomClassesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomClassesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomClassesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CustomClass> extractResources(ListCustomClassesResponse payload) {
            return payload.getCustomClassesList();
        }
    };
    private static final PagedListDescriptor<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet> LIST_PHRASE_SETS_PAGE_STR_DESC = new PagedListDescriptor<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet>(){

        public String emptyToken() {
            return "";
        }

        public ListPhraseSetsRequest injectToken(ListPhraseSetsRequest payload, String token) {
            return ListPhraseSetsRequest.newBuilder((ListPhraseSetsRequest)payload).setPageToken(token).build();
        }

        public ListPhraseSetsRequest injectPageSize(ListPhraseSetsRequest payload, int pageSize) {
            return ListPhraseSetsRequest.newBuilder((ListPhraseSetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPhraseSetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPhraseSetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PhraseSet> extractResources(ListPhraseSetsResponse payload) {
            return payload.getPhraseSetsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListRecognizersRequest, ListRecognizersResponse, SpeechClient.ListRecognizersPagedResponse> LIST_RECOGNIZERS_PAGE_STR_FACT = new PagedListResponseFactory<ListRecognizersRequest, ListRecognizersResponse, SpeechClient.ListRecognizersPagedResponse>(){

        public ApiFuture<SpeechClient.ListRecognizersPagedResponse> getFuturePagedResponse(UnaryCallable<ListRecognizersRequest, ListRecognizersResponse> callable, ListRecognizersRequest request, ApiCallContext context, ApiFuture<ListRecognizersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RECOGNIZERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpeechClient.ListRecognizersPagedResponse.createAsync((PageContext<ListRecognizersRequest, ListRecognizersResponse, Recognizer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCustomClassesRequest, ListCustomClassesResponse, SpeechClient.ListCustomClassesPagedResponse> LIST_CUSTOM_CLASSES_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomClassesRequest, ListCustomClassesResponse, SpeechClient.ListCustomClassesPagedResponse>(){

        public ApiFuture<SpeechClient.ListCustomClassesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> callable, ListCustomClassesRequest request, ApiCallContext context, ApiFuture<ListCustomClassesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOM_CLASSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpeechClient.ListCustomClassesPagedResponse.createAsync((PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPhraseSetsRequest, ListPhraseSetsResponse, SpeechClient.ListPhraseSetsPagedResponse> LIST_PHRASE_SETS_PAGE_STR_FACT = new PagedListResponseFactory<ListPhraseSetsRequest, ListPhraseSetsResponse, SpeechClient.ListPhraseSetsPagedResponse>(){

        public ApiFuture<SpeechClient.ListPhraseSetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsResponse> callable, ListPhraseSetsRequest request, ApiCallContext context, ApiFuture<ListPhraseSetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PHRASE_SETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpeechClient.ListPhraseSetsPagedResponse.createAsync((PageContext<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SpeechClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SpeechClient.ListLocationsPagedResponse>(){

        public ApiFuture<SpeechClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpeechClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateRecognizerRequest, Operation> createRecognizerSettings() {
        return this.createRecognizerSettings;
    }

    public OperationCallSettings<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationSettings() {
        return this.createRecognizerOperationSettings;
    }

    public PagedCallSettings<ListRecognizersRequest, ListRecognizersResponse, SpeechClient.ListRecognizersPagedResponse> listRecognizersSettings() {
        return this.listRecognizersSettings;
    }

    public UnaryCallSettings<GetRecognizerRequest, Recognizer> getRecognizerSettings() {
        return this.getRecognizerSettings;
    }

    public UnaryCallSettings<UpdateRecognizerRequest, Operation> updateRecognizerSettings() {
        return this.updateRecognizerSettings;
    }

    public OperationCallSettings<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationSettings() {
        return this.updateRecognizerOperationSettings;
    }

    public UnaryCallSettings<DeleteRecognizerRequest, Operation> deleteRecognizerSettings() {
        return this.deleteRecognizerSettings;
    }

    public OperationCallSettings<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationSettings() {
        return this.deleteRecognizerOperationSettings;
    }

    public UnaryCallSettings<UndeleteRecognizerRequest, Operation> undeleteRecognizerSettings() {
        return this.undeleteRecognizerSettings;
    }

    public OperationCallSettings<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationSettings() {
        return this.undeleteRecognizerOperationSettings;
    }

    public UnaryCallSettings<RecognizeRequest, RecognizeResponse> recognizeSettings() {
        return this.recognizeSettings;
    }

    public StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
        return this.streamingRecognizeSettings;
    }

    public UnaryCallSettings<BatchRecognizeRequest, Operation> batchRecognizeSettings() {
        return this.batchRecognizeSettings;
    }

    public OperationCallSettings<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationSettings() {
        return this.batchRecognizeOperationSettings;
    }

    public UnaryCallSettings<GetConfigRequest, Config> getConfigSettings() {
        return this.getConfigSettings;
    }

    public UnaryCallSettings<UpdateConfigRequest, Config> updateConfigSettings() {
        return this.updateConfigSettings;
    }

    public UnaryCallSettings<CreateCustomClassRequest, Operation> createCustomClassSettings() {
        return this.createCustomClassSettings;
    }

    public OperationCallSettings<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationSettings() {
        return this.createCustomClassOperationSettings;
    }

    public PagedCallSettings<ListCustomClassesRequest, ListCustomClassesResponse, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesSettings() {
        return this.listCustomClassesSettings;
    }

    public UnaryCallSettings<GetCustomClassRequest, CustomClass> getCustomClassSettings() {
        return this.getCustomClassSettings;
    }

    public UnaryCallSettings<UpdateCustomClassRequest, Operation> updateCustomClassSettings() {
        return this.updateCustomClassSettings;
    }

    public OperationCallSettings<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationSettings() {
        return this.updateCustomClassOperationSettings;
    }

    public UnaryCallSettings<DeleteCustomClassRequest, Operation> deleteCustomClassSettings() {
        return this.deleteCustomClassSettings;
    }

    public OperationCallSettings<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationSettings() {
        return this.deleteCustomClassOperationSettings;
    }

    public UnaryCallSettings<UndeleteCustomClassRequest, Operation> undeleteCustomClassSettings() {
        return this.undeleteCustomClassSettings;
    }

    public OperationCallSettings<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationSettings() {
        return this.undeleteCustomClassOperationSettings;
    }

    public UnaryCallSettings<CreatePhraseSetRequest, Operation> createPhraseSetSettings() {
        return this.createPhraseSetSettings;
    }

    public OperationCallSettings<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationSettings() {
        return this.createPhraseSetOperationSettings;
    }

    public PagedCallSettings<ListPhraseSetsRequest, ListPhraseSetsResponse, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsSettings() {
        return this.listPhraseSetsSettings;
    }

    public UnaryCallSettings<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings() {
        return this.getPhraseSetSettings;
    }

    public UnaryCallSettings<UpdatePhraseSetRequest, Operation> updatePhraseSetSettings() {
        return this.updatePhraseSetSettings;
    }

    public OperationCallSettings<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationSettings() {
        return this.updatePhraseSetOperationSettings;
    }

    public UnaryCallSettings<DeletePhraseSetRequest, Operation> deletePhraseSetSettings() {
        return this.deletePhraseSetSettings;
    }

    public OperationCallSettings<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationSettings() {
        return this.deletePhraseSetOperationSettings;
    }

    public UnaryCallSettings<UndeletePhraseSetRequest, Operation> undeletePhraseSetSettings() {
        return this.undeletePhraseSetSettings;
    }

    public OperationCallSettings<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationSettings() {
        return this.undeletePhraseSetOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SpeechClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public SpeechStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSpeechStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSpeechStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "speech";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "speech.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "speech.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SpeechStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SpeechStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SpeechStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SpeechStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SpeechStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createRecognizerSettings = settingsBuilder.createRecognizerSettings().build();
        this.createRecognizerOperationSettings = settingsBuilder.createRecognizerOperationSettings().build();
        this.listRecognizersSettings = settingsBuilder.listRecognizersSettings().build();
        this.getRecognizerSettings = settingsBuilder.getRecognizerSettings().build();
        this.updateRecognizerSettings = settingsBuilder.updateRecognizerSettings().build();
        this.updateRecognizerOperationSettings = settingsBuilder.updateRecognizerOperationSettings().build();
        this.deleteRecognizerSettings = settingsBuilder.deleteRecognizerSettings().build();
        this.deleteRecognizerOperationSettings = settingsBuilder.deleteRecognizerOperationSettings().build();
        this.undeleteRecognizerSettings = settingsBuilder.undeleteRecognizerSettings().build();
        this.undeleteRecognizerOperationSettings = settingsBuilder.undeleteRecognizerOperationSettings().build();
        this.recognizeSettings = settingsBuilder.recognizeSettings().build();
        this.streamingRecognizeSettings = settingsBuilder.streamingRecognizeSettings().build();
        this.batchRecognizeSettings = settingsBuilder.batchRecognizeSettings().build();
        this.batchRecognizeOperationSettings = settingsBuilder.batchRecognizeOperationSettings().build();
        this.getConfigSettings = settingsBuilder.getConfigSettings().build();
        this.updateConfigSettings = settingsBuilder.updateConfigSettings().build();
        this.createCustomClassSettings = settingsBuilder.createCustomClassSettings().build();
        this.createCustomClassOperationSettings = settingsBuilder.createCustomClassOperationSettings().build();
        this.listCustomClassesSettings = settingsBuilder.listCustomClassesSettings().build();
        this.getCustomClassSettings = settingsBuilder.getCustomClassSettings().build();
        this.updateCustomClassSettings = settingsBuilder.updateCustomClassSettings().build();
        this.updateCustomClassOperationSettings = settingsBuilder.updateCustomClassOperationSettings().build();
        this.deleteCustomClassSettings = settingsBuilder.deleteCustomClassSettings().build();
        this.deleteCustomClassOperationSettings = settingsBuilder.deleteCustomClassOperationSettings().build();
        this.undeleteCustomClassSettings = settingsBuilder.undeleteCustomClassSettings().build();
        this.undeleteCustomClassOperationSettings = settingsBuilder.undeleteCustomClassOperationSettings().build();
        this.createPhraseSetSettings = settingsBuilder.createPhraseSetSettings().build();
        this.createPhraseSetOperationSettings = settingsBuilder.createPhraseSetOperationSettings().build();
        this.listPhraseSetsSettings = settingsBuilder.listPhraseSetsSettings().build();
        this.getPhraseSetSettings = settingsBuilder.getPhraseSetSettings().build();
        this.updatePhraseSetSettings = settingsBuilder.updatePhraseSetSettings().build();
        this.updatePhraseSetOperationSettings = settingsBuilder.updatePhraseSetOperationSettings().build();
        this.deletePhraseSetSettings = settingsBuilder.deletePhraseSetSettings().build();
        this.deletePhraseSetOperationSettings = settingsBuilder.deletePhraseSetOperationSettings().build();
        this.undeletePhraseSetSettings = settingsBuilder.undeletePhraseSetSettings().build();
        this.undeletePhraseSetOperationSettings = settingsBuilder.undeletePhraseSetOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SpeechStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateRecognizerRequest, Operation> createRecognizerSettings;
        private final OperationCallSettings.Builder<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationSettings;
        private final PagedCallSettings.Builder<ListRecognizersRequest, ListRecognizersResponse, SpeechClient.ListRecognizersPagedResponse> listRecognizersSettings;
        private final UnaryCallSettings.Builder<GetRecognizerRequest, Recognizer> getRecognizerSettings;
        private final UnaryCallSettings.Builder<UpdateRecognizerRequest, Operation> updateRecognizerSettings;
        private final OperationCallSettings.Builder<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRecognizerRequest, Operation> deleteRecognizerSettings;
        private final OperationCallSettings.Builder<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationSettings;
        private final UnaryCallSettings.Builder<UndeleteRecognizerRequest, Operation> undeleteRecognizerSettings;
        private final OperationCallSettings.Builder<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationSettings;
        private final UnaryCallSettings.Builder<RecognizeRequest, RecognizeResponse> recognizeSettings;
        private final StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;
        private final UnaryCallSettings.Builder<BatchRecognizeRequest, Operation> batchRecognizeSettings;
        private final OperationCallSettings.Builder<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationSettings;
        private final UnaryCallSettings.Builder<GetConfigRequest, Config> getConfigSettings;
        private final UnaryCallSettings.Builder<UpdateConfigRequest, Config> updateConfigSettings;
        private final UnaryCallSettings.Builder<CreateCustomClassRequest, Operation> createCustomClassSettings;
        private final OperationCallSettings.Builder<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationSettings;
        private final PagedCallSettings.Builder<ListCustomClassesRequest, ListCustomClassesResponse, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesSettings;
        private final UnaryCallSettings.Builder<GetCustomClassRequest, CustomClass> getCustomClassSettings;
        private final UnaryCallSettings.Builder<UpdateCustomClassRequest, Operation> updateCustomClassSettings;
        private final OperationCallSettings.Builder<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCustomClassRequest, Operation> deleteCustomClassSettings;
        private final OperationCallSettings.Builder<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationSettings;
        private final UnaryCallSettings.Builder<UndeleteCustomClassRequest, Operation> undeleteCustomClassSettings;
        private final OperationCallSettings.Builder<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationSettings;
        private final UnaryCallSettings.Builder<CreatePhraseSetRequest, Operation> createPhraseSetSettings;
        private final OperationCallSettings.Builder<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationSettings;
        private final PagedCallSettings.Builder<ListPhraseSetsRequest, ListPhraseSetsResponse, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsSettings;
        private final UnaryCallSettings.Builder<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings;
        private final UnaryCallSettings.Builder<UpdatePhraseSetRequest, Operation> updatePhraseSetSettings;
        private final OperationCallSettings.Builder<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationSettings;
        private final UnaryCallSettings.Builder<DeletePhraseSetRequest, Operation> deletePhraseSetSettings;
        private final OperationCallSettings.Builder<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationSettings;
        private final UnaryCallSettings.Builder<UndeletePhraseSetRequest, Operation> undeletePhraseSetSettings;
        private final OperationCallSettings.Builder<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SpeechClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createRecognizerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRecognizerOperationSettings = OperationCallSettings.newBuilder();
            this.listRecognizersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RECOGNIZERS_PAGE_STR_FACT);
            this.getRecognizerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRecognizerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRecognizerOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRecognizerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRecognizerOperationSettings = OperationCallSettings.newBuilder();
            this.undeleteRecognizerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteRecognizerOperationSettings = OperationCallSettings.newBuilder();
            this.recognizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamingRecognizeSettings = StreamingCallSettings.newBuilder();
            this.batchRecognizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchRecognizeOperationSettings = OperationCallSettings.newBuilder();
            this.getConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCustomClassOperationSettings = OperationCallSettings.newBuilder();
            this.listCustomClassesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOM_CLASSES_PAGE_STR_FACT);
            this.getCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCustomClassOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCustomClassOperationSettings = OperationCallSettings.newBuilder();
            this.undeleteCustomClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteCustomClassOperationSettings = OperationCallSettings.newBuilder();
            this.createPhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPhraseSetOperationSettings = OperationCallSettings.newBuilder();
            this.listPhraseSetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PHRASE_SETS_PAGE_STR_FACT);
            this.getPhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePhraseSetOperationSettings = OperationCallSettings.newBuilder();
            this.deletePhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePhraseSetOperationSettings = OperationCallSettings.newBuilder();
            this.undeletePhraseSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeletePhraseSetOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRecognizerSettings, this.listRecognizersSettings, this.getRecognizerSettings, this.updateRecognizerSettings, this.deleteRecognizerSettings, this.undeleteRecognizerSettings, this.recognizeSettings, this.batchRecognizeSettings, this.getConfigSettings, this.updateConfigSettings, this.createCustomClassSettings, this.listCustomClassesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getCustomClassSettings, this.updateCustomClassSettings, this.deleteCustomClassSettings, this.undeleteCustomClassSettings, this.createPhraseSetSettings, this.listPhraseSetsSettings, this.getPhraseSetSettings, this.updatePhraseSetSettings, this.deletePhraseSetSettings, this.undeletePhraseSetSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(SpeechStubSettings settings) {
            super((StubSettings)settings);
            this.createRecognizerSettings = settings.createRecognizerSettings.toBuilder();
            this.createRecognizerOperationSettings = settings.createRecognizerOperationSettings.toBuilder();
            this.listRecognizersSettings = settings.listRecognizersSettings.toBuilder();
            this.getRecognizerSettings = settings.getRecognizerSettings.toBuilder();
            this.updateRecognizerSettings = settings.updateRecognizerSettings.toBuilder();
            this.updateRecognizerOperationSettings = settings.updateRecognizerOperationSettings.toBuilder();
            this.deleteRecognizerSettings = settings.deleteRecognizerSettings.toBuilder();
            this.deleteRecognizerOperationSettings = settings.deleteRecognizerOperationSettings.toBuilder();
            this.undeleteRecognizerSettings = settings.undeleteRecognizerSettings.toBuilder();
            this.undeleteRecognizerOperationSettings = settings.undeleteRecognizerOperationSettings.toBuilder();
            this.recognizeSettings = settings.recognizeSettings.toBuilder();
            this.streamingRecognizeSettings = settings.streamingRecognizeSettings.toBuilder();
            this.batchRecognizeSettings = settings.batchRecognizeSettings.toBuilder();
            this.batchRecognizeOperationSettings = settings.batchRecognizeOperationSettings.toBuilder();
            this.getConfigSettings = settings.getConfigSettings.toBuilder();
            this.updateConfigSettings = settings.updateConfigSettings.toBuilder();
            this.createCustomClassSettings = settings.createCustomClassSettings.toBuilder();
            this.createCustomClassOperationSettings = settings.createCustomClassOperationSettings.toBuilder();
            this.listCustomClassesSettings = settings.listCustomClassesSettings.toBuilder();
            this.getCustomClassSettings = settings.getCustomClassSettings.toBuilder();
            this.updateCustomClassSettings = settings.updateCustomClassSettings.toBuilder();
            this.updateCustomClassOperationSettings = settings.updateCustomClassOperationSettings.toBuilder();
            this.deleteCustomClassSettings = settings.deleteCustomClassSettings.toBuilder();
            this.deleteCustomClassOperationSettings = settings.deleteCustomClassOperationSettings.toBuilder();
            this.undeleteCustomClassSettings = settings.undeleteCustomClassSettings.toBuilder();
            this.undeleteCustomClassOperationSettings = settings.undeleteCustomClassOperationSettings.toBuilder();
            this.createPhraseSetSettings = settings.createPhraseSetSettings.toBuilder();
            this.createPhraseSetOperationSettings = settings.createPhraseSetOperationSettings.toBuilder();
            this.listPhraseSetsSettings = settings.listPhraseSetsSettings.toBuilder();
            this.getPhraseSetSettings = settings.getPhraseSetSettings.toBuilder();
            this.updatePhraseSetSettings = settings.updatePhraseSetSettings.toBuilder();
            this.updatePhraseSetOperationSettings = settings.updatePhraseSetOperationSettings.toBuilder();
            this.deletePhraseSetSettings = settings.deletePhraseSetSettings.toBuilder();
            this.deletePhraseSetOperationSettings = settings.deletePhraseSetOperationSettings.toBuilder();
            this.undeletePhraseSetSettings = settings.undeletePhraseSetSettings.toBuilder();
            this.undeletePhraseSetOperationSettings = settings.undeletePhraseSetOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRecognizerSettings, this.listRecognizersSettings, this.getRecognizerSettings, this.updateRecognizerSettings, this.deleteRecognizerSettings, this.undeleteRecognizerSettings, this.recognizeSettings, this.batchRecognizeSettings, this.getConfigSettings, this.updateConfigSettings, this.createCustomClassSettings, this.listCustomClassesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getCustomClassSettings, this.updateCustomClassSettings, this.deleteCustomClassSettings, this.undeleteCustomClassSettings, this.createPhraseSetSettings, this.listPhraseSetsSettings, this.getPhraseSetSettings, this.updatePhraseSetSettings, this.deletePhraseSetSettings, this.undeletePhraseSetSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SpeechStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SpeechStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SpeechStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SpeechStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SpeechStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SpeechStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SpeechStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SpeechStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createRecognizerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRecognizersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRecognizerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateRecognizerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteRecognizerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.undeleteRecognizerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.recognizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchRecognizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCustomClassesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.undeleteCustomClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPhraseSetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.undeletePhraseSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRecognizerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Recognizer.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateRecognizerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Recognizer.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRecognizerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Recognizer.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteRecognizerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Recognizer.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchRecognizeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchRecognizeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createCustomClassOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CustomClass.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateCustomClassOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CustomClass.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteCustomClassOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CustomClass.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteCustomClassOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CustomClass.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createPhraseSetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PhraseSet.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updatePhraseSetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PhraseSet.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deletePhraseSetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PhraseSet.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeletePhraseSetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PhraseSet.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateRecognizerRequest, Operation> createRecognizerSettings() {
            return this.createRecognizerSettings;
        }

        public OperationCallSettings.Builder<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationSettings() {
            return this.createRecognizerOperationSettings;
        }

        public PagedCallSettings.Builder<ListRecognizersRequest, ListRecognizersResponse, SpeechClient.ListRecognizersPagedResponse> listRecognizersSettings() {
            return this.listRecognizersSettings;
        }

        public UnaryCallSettings.Builder<GetRecognizerRequest, Recognizer> getRecognizerSettings() {
            return this.getRecognizerSettings;
        }

        public UnaryCallSettings.Builder<UpdateRecognizerRequest, Operation> updateRecognizerSettings() {
            return this.updateRecognizerSettings;
        }

        public OperationCallSettings.Builder<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationSettings() {
            return this.updateRecognizerOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRecognizerRequest, Operation> deleteRecognizerSettings() {
            return this.deleteRecognizerSettings;
        }

        public OperationCallSettings.Builder<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationSettings() {
            return this.deleteRecognizerOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeleteRecognizerRequest, Operation> undeleteRecognizerSettings() {
            return this.undeleteRecognizerSettings;
        }

        public OperationCallSettings.Builder<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationSettings() {
            return this.undeleteRecognizerOperationSettings;
        }

        public UnaryCallSettings.Builder<RecognizeRequest, RecognizeResponse> recognizeSettings() {
            return this.recognizeSettings;
        }

        public StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
            return this.streamingRecognizeSettings;
        }

        public UnaryCallSettings.Builder<BatchRecognizeRequest, Operation> batchRecognizeSettings() {
            return this.batchRecognizeSettings;
        }

        public OperationCallSettings.Builder<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationSettings() {
            return this.batchRecognizeOperationSettings;
        }

        public UnaryCallSettings.Builder<GetConfigRequest, Config> getConfigSettings() {
            return this.getConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateConfigRequest, Config> updateConfigSettings() {
            return this.updateConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateCustomClassRequest, Operation> createCustomClassSettings() {
            return this.createCustomClassSettings;
        }

        public OperationCallSettings.Builder<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationSettings() {
            return this.createCustomClassOperationSettings;
        }

        public PagedCallSettings.Builder<ListCustomClassesRequest, ListCustomClassesResponse, SpeechClient.ListCustomClassesPagedResponse> listCustomClassesSettings() {
            return this.listCustomClassesSettings;
        }

        public UnaryCallSettings.Builder<GetCustomClassRequest, CustomClass> getCustomClassSettings() {
            return this.getCustomClassSettings;
        }

        public UnaryCallSettings.Builder<UpdateCustomClassRequest, Operation> updateCustomClassSettings() {
            return this.updateCustomClassSettings;
        }

        public OperationCallSettings.Builder<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationSettings() {
            return this.updateCustomClassOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCustomClassRequest, Operation> deleteCustomClassSettings() {
            return this.deleteCustomClassSettings;
        }

        public OperationCallSettings.Builder<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationSettings() {
            return this.deleteCustomClassOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeleteCustomClassRequest, Operation> undeleteCustomClassSettings() {
            return this.undeleteCustomClassSettings;
        }

        public OperationCallSettings.Builder<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationSettings() {
            return this.undeleteCustomClassOperationSettings;
        }

        public UnaryCallSettings.Builder<CreatePhraseSetRequest, Operation> createPhraseSetSettings() {
            return this.createPhraseSetSettings;
        }

        public OperationCallSettings.Builder<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationSettings() {
            return this.createPhraseSetOperationSettings;
        }

        public PagedCallSettings.Builder<ListPhraseSetsRequest, ListPhraseSetsResponse, SpeechClient.ListPhraseSetsPagedResponse> listPhraseSetsSettings() {
            return this.listPhraseSetsSettings;
        }

        public UnaryCallSettings.Builder<GetPhraseSetRequest, PhraseSet> getPhraseSetSettings() {
            return this.getPhraseSetSettings;
        }

        public UnaryCallSettings.Builder<UpdatePhraseSetRequest, Operation> updatePhraseSetSettings() {
            return this.updatePhraseSetSettings;
        }

        public OperationCallSettings.Builder<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationSettings() {
            return this.updatePhraseSetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePhraseSetRequest, Operation> deletePhraseSetSettings() {
            return this.deletePhraseSetSettings;
        }

        public OperationCallSettings.Builder<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationSettings() {
            return this.deletePhraseSetOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeletePhraseSetRequest, Operation> undeletePhraseSetSettings() {
            return this.undeletePhraseSetSettings;
        }

        public OperationCallSettings.Builder<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationSettings() {
            return this.undeletePhraseSetOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SpeechClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public SpeechStubSettings build() throws IOException {
            return new SpeechStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)5000000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000000L)).setTotalTimeout(Duration.ofMillis((long)5000000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

