/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.storage.control.v2.BucketName;
import com.google.storage.control.v2.CreateFolderRequest;
import com.google.storage.control.v2.CreateManagedFolderRequest;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.DeleteManagedFolderRequest;
import com.google.storage.control.v2.Folder;
import com.google.storage.control.v2.FolderName;
import com.google.storage.control.v2.GetFolderRequest;
import com.google.storage.control.v2.GetManagedFolderRequest;
import com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.storage.control.v2.ListFoldersRequest;
import com.google.storage.control.v2.ListFoldersResponse;
import com.google.storage.control.v2.ListManagedFoldersRequest;
import com.google.storage.control.v2.ListManagedFoldersResponse;
import com.google.storage.control.v2.ManagedFolder;
import com.google.storage.control.v2.ManagedFolderName;
import com.google.storage.control.v2.MockStorageControl;
import com.google.storage.control.v2.PendingRenameInfo;
import com.google.storage.control.v2.RenameFolderRequest;
import com.google.storage.control.v2.StorageControlClient;
import com.google.storage.control.v2.StorageControlSettings;
import com.google.storage.control.v2.StorageLayout;
import com.google.storage.control.v2.StorageLayoutName;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StorageControlClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockStorageControl mockStorageControl;
    private LocalChannelProvider channelProvider;
    private StorageControlClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockStorageControl = new MockStorageControl();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockStorageControl));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        StorageControlSettings settings = ((StorageControlSettings.Builder)((StorageControlSettings.Builder)StorageControlSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = StorageControlClient.create((StorageControlSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createFolderTest() throws Exception {
        Folder expectedResponse = Folder.newBuilder().setName(FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setPendingRenameInfo(PendingRenameInfo.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
        Folder folder = Folder.newBuilder().build();
        String folderId = "folderId294109737";
        Folder actualResponse = this.client.createFolder(parent, folder, folderId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateFolderRequest actualRequest = (CreateFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)folder, (Object)actualRequest.getFolder());
        Assert.assertEquals((Object)folderId, (Object)actualRequest.getFolderId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
            Folder folder = Folder.newBuilder().build();
            String folderId = "folderId294109737";
            this.client.createFolder(parent, folder, folderId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFolderTest2() throws Exception {
        Folder expectedResponse = Folder.newBuilder().setName(FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setPendingRenameInfo(PendingRenameInfo.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Folder folder = Folder.newBuilder().build();
        String folderId = "folderId294109737";
        Folder actualResponse = this.client.createFolder(parent, folder, folderId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateFolderRequest actualRequest = (CreateFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)folder, (Object)actualRequest.getFolder());
        Assert.assertEquals((Object)folderId, (Object)actualRequest.getFolderId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Folder folder = Folder.newBuilder().build();
            String folderId = "folderId294109737";
            this.client.createFolder(parent, folder, folderId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteFolderTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]");
        this.client.deleteFolder(name);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteFolderRequest actualRequest = (DeleteFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]");
            this.client.deleteFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteFolderTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteFolder(name);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteFolderRequest actualRequest = (DeleteFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getFolderTest() throws Exception {
        Folder expectedResponse = Folder.newBuilder().setName(FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setPendingRenameInfo(PendingRenameInfo.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]");
        Folder actualResponse = this.client.getFolder(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetFolderRequest actualRequest = (GetFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]");
            this.client.getFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getFolderTest2() throws Exception {
        Folder expectedResponse = Folder.newBuilder().setName(FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setPendingRenameInfo(PendingRenameInfo.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Folder actualResponse = this.client.getFolder(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetFolderRequest actualRequest = (GetFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFoldersTest() throws Exception {
        Folder responsesElement = Folder.newBuilder().build();
        ListFoldersResponse expectedResponse = ListFoldersResponse.newBuilder().setNextPageToken("").addAllFolders(Arrays.asList(responsesElement)).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
        StorageControlClient.ListFoldersPagedResponse pagedListResponse = this.client.listFolders(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getFoldersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListFoldersRequest actualRequest = (ListFoldersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listFoldersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
            this.client.listFolders(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFoldersTest2() throws Exception {
        Folder responsesElement = Folder.newBuilder().build();
        ListFoldersResponse expectedResponse = ListFoldersResponse.newBuilder().setNextPageToken("").addAllFolders(Arrays.asList(responsesElement)).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        StorageControlClient.ListFoldersPagedResponse pagedListResponse = this.client.listFolders(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getFoldersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListFoldersRequest actualRequest = (ListFoldersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listFoldersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listFolders(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameFolderTest() throws Exception {
        Folder expectedResponse = Folder.newBuilder().setName(FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setPendingRenameInfo(PendingRenameInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("renameFolderTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStorageControl.addResponse((AbstractMessage)resultOperation);
        FolderName name = FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]");
        String destinationFolderId = "destinationFolderId-480084905";
        Folder actualResponse = (Folder)this.client.renameFolderAsync(name, destinationFolderId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenameFolderRequest actualRequest = (RenameFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)destinationFolderId, (Object)actualRequest.getDestinationFolderId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renameFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]");
            String destinationFolderId = "destinationFolderId-480084905";
            this.client.renameFolderAsync(name, destinationFolderId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void renameFolderTest2() throws Exception {
        Folder expectedResponse = Folder.newBuilder().setName(FolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setPendingRenameInfo(PendingRenameInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("renameFolderTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStorageControl.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        String destinationFolderId = "destinationFolderId-480084905";
        Folder actualResponse = (Folder)this.client.renameFolderAsync(name, destinationFolderId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenameFolderRequest actualRequest = (RenameFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)destinationFolderId, (Object)actualRequest.getDestinationFolderId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renameFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String name = "name3373707";
            String destinationFolderId = "destinationFolderId-480084905";
            this.client.renameFolderAsync(name, destinationFolderId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getStorageLayoutTest() throws Exception {
        StorageLayout expectedResponse = StorageLayout.newBuilder().setName(StorageLayoutName.of((String)"[PROJECT]", (String)"[BUCKET]").toString()).setLocation("location1901043637").setLocationType("locationType-58277745").setCustomPlacementConfig(StorageLayout.CustomPlacementConfig.newBuilder().build()).setHierarchicalNamespace(StorageLayout.HierarchicalNamespace.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        StorageLayoutName name = StorageLayoutName.of((String)"[PROJECT]", (String)"[BUCKET]");
        StorageLayout actualResponse = this.client.getStorageLayout(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetStorageLayoutRequest actualRequest = (GetStorageLayoutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getStorageLayoutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            StorageLayoutName name = StorageLayoutName.of((String)"[PROJECT]", (String)"[BUCKET]");
            this.client.getStorageLayout(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStorageLayoutTest2() throws Exception {
        StorageLayout expectedResponse = StorageLayout.newBuilder().setName(StorageLayoutName.of((String)"[PROJECT]", (String)"[BUCKET]").toString()).setLocation("location1901043637").setLocationType("locationType-58277745").setCustomPlacementConfig(StorageLayout.CustomPlacementConfig.newBuilder().build()).setHierarchicalNamespace(StorageLayout.HierarchicalNamespace.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        StorageLayout actualResponse = this.client.getStorageLayout(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetStorageLayoutRequest actualRequest = (GetStorageLayoutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getStorageLayoutExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getStorageLayout(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createManagedFolderTest() throws Exception {
        ManagedFolder expectedResponse = ManagedFolder.newBuilder().setName(ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
        ManagedFolder managedFolder = ManagedFolder.newBuilder().build();
        String managedFolderId = "managedFolderId-2027084056";
        ManagedFolder actualResponse = this.client.createManagedFolder(parent, managedFolder, managedFolderId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateManagedFolderRequest actualRequest = (CreateManagedFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)managedFolder, (Object)actualRequest.getManagedFolder());
        Assert.assertEquals((Object)managedFolderId, (Object)actualRequest.getManagedFolderId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createManagedFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
            ManagedFolder managedFolder = ManagedFolder.newBuilder().build();
            String managedFolderId = "managedFolderId-2027084056";
            this.client.createManagedFolder(parent, managedFolder, managedFolderId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createManagedFolderTest2() throws Exception {
        ManagedFolder expectedResponse = ManagedFolder.newBuilder().setName(ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ManagedFolder managedFolder = ManagedFolder.newBuilder().build();
        String managedFolderId = "managedFolderId-2027084056";
        ManagedFolder actualResponse = this.client.createManagedFolder(parent, managedFolder, managedFolderId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateManagedFolderRequest actualRequest = (CreateManagedFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)managedFolder, (Object)actualRequest.getManagedFolder());
        Assert.assertEquals((Object)managedFolderId, (Object)actualRequest.getManagedFolderId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createManagedFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ManagedFolder managedFolder = ManagedFolder.newBuilder().build();
            String managedFolderId = "managedFolderId-2027084056";
            this.client.createManagedFolder(parent, managedFolder, managedFolderId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteManagedFolderTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        ManagedFolderName name = ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]");
        this.client.deleteManagedFolder(name);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteManagedFolderRequest actualRequest = (DeleteManagedFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteManagedFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            ManagedFolderName name = ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]");
            this.client.deleteManagedFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteManagedFolderTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteManagedFolder(name);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteManagedFolderRequest actualRequest = (DeleteManagedFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteManagedFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteManagedFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getManagedFolderTest() throws Exception {
        ManagedFolder expectedResponse = ManagedFolder.newBuilder().setName(ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        ManagedFolderName name = ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]");
        ManagedFolder actualResponse = this.client.getManagedFolder(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetManagedFolderRequest actualRequest = (GetManagedFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getManagedFolderExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            ManagedFolderName name = ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]");
            this.client.getManagedFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getManagedFolderTest2() throws Exception {
        ManagedFolder expectedResponse = ManagedFolder.newBuilder().setName(ManagedFolderName.of((String)"[PROJECT]", (String)"[BUCKET]", (String)"[MANAGED_FOLDER]").toString()).setMetageneration(1048558813L).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ManagedFolder actualResponse = this.client.getManagedFolder(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetManagedFolderRequest actualRequest = (GetManagedFolderRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getManagedFolderExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getManagedFolder(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listManagedFoldersTest() throws Exception {
        ManagedFolder responsesElement = ManagedFolder.newBuilder().build();
        ListManagedFoldersResponse expectedResponse = ListManagedFoldersResponse.newBuilder().setNextPageToken("").addAllManagedFolders(Arrays.asList(responsesElement)).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
        StorageControlClient.ListManagedFoldersPagedResponse pagedListResponse = this.client.listManagedFolders(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getManagedFoldersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListManagedFoldersRequest actualRequest = (ListManagedFoldersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listManagedFoldersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            BucketName parent = BucketName.of((String)"[PROJECT]", (String)"[BUCKET]");
            this.client.listManagedFolders(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listManagedFoldersTest2() throws Exception {
        ManagedFolder responsesElement = ManagedFolder.newBuilder().build();
        ListManagedFoldersResponse expectedResponse = ListManagedFoldersResponse.newBuilder().setNextPageToken("").addAllManagedFolders(Arrays.asList(responsesElement)).build();
        mockStorageControl.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        StorageControlClient.ListManagedFoldersPagedResponse pagedListResponse = this.client.listManagedFolders(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getManagedFoldersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStorageControl.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListManagedFoldersRequest actualRequest = (ListManagedFoldersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listManagedFoldersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStorageControl.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listManagedFolders(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

