/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.Page;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Bucket
extends BucketInfo {
    private static final long serialVersionUID = 8574601739542252586L;
    private final StorageOptions options;
    private transient Storage storage;

    Bucket(Storage storage, BucketInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.options = (StorageOptions)storage.options();
    }

    public boolean exists(BucketSourceOption ... options) {
        int length = options.length;
        Storage.BucketGetOption[] getOptions = Arrays.copyOf(BucketSourceOption.toGetOptions(this, options), length + 1);
        getOptions[length] = Storage.BucketGetOption.fields(new Storage.BucketField[0]);
        return this.storage.get(this.name(), getOptions) != null;
    }

    public Bucket reload(BucketSourceOption ... options) {
        return this.storage.get(this.name(), BucketSourceOption.toGetOptions(this, options));
    }

    public Bucket update(Storage.BucketTargetOption ... options) {
        return this.storage.update(this, options);
    }

    public boolean delete(BucketSourceOption ... options) {
        return this.storage.delete(this.name(), BucketSourceOption.toSourceOptions(this, options));
    }

    public Page<Blob> list(Storage.BlobListOption ... options) {
        return this.storage.list(this.name(), options);
    }

    public Blob get(String blob, Storage.BlobGetOption ... options) {
        return this.storage.get(BlobId.of(this.name(), blob), options);
    }

    public List<Blob> get(String blobName1, String blobName2, String ... blobNames) {
        ArrayList blobIds = Lists.newArrayListWithCapacity((int)(blobNames.length + 2));
        blobIds.add(BlobId.of(this.name(), blobName1));
        blobIds.add(BlobId.of(this.name(), blobName2));
        for (String blobName : blobNames) {
            blobIds.add(BlobId.of(this.name(), blobName));
        }
        return this.storage.get(blobIds);
    }

    public List<Blob> get(Iterable<String> blobNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String blobName : blobNames) {
            builder.add((Object)BlobId.of(this.name(), blobName));
        }
        return this.storage.get((Iterable<BlobId>)builder.build());
    }

    public Blob create(String blob, byte[] content, String contentType, BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.builder(BlobId.of(this.name(), blob)).contentType(contentType).build();
        StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> target = BlobTargetOption.toTargetOptions(blobInfo, options);
        return this.storage.create(target.x(), content, target.y());
    }

    public Blob create(String blob, InputStream content, String contentType, BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.builder(BlobId.of(this.name(), blob)).contentType(contentType).build();
        StorageRpc.Tuple<BlobInfo, Storage.BlobWriteOption[]> write = BlobWriteOption.toWriteOptions(blobInfo, options);
        return this.storage.create(write.x(), content, write.y());
    }

    public Blob create(String blob, byte[] content, BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.builder(BlobId.of(this.name(), blob)).build();
        StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> target = BlobTargetOption.toTargetOptions(blobInfo, options);
        return this.storage.create(target.x(), content, target.y());
    }

    public Blob create(String blob, InputStream content, BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.builder(BlobId.of(this.name(), blob)).build();
        StorageRpc.Tuple<BlobInfo, Storage.BlobWriteOption[]> write = BlobWriteOption.toWriteOptions(blobInfo, options);
        return this.storage.create(write.x(), content, write.y());
    }

    public Storage storage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && !obj.getClass().equals(Bucket.class)) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = (Storage)this.options.service();
    }

    static Bucket fromPb(Storage storage, com.google.api.services.storage.model.Bucket bucketPb) {
        return new Bucket(storage, new BucketInfo.BuilderImpl(BucketInfo.fromPb(bucketPb)));
    }

    public static class Builder
    extends BucketInfo.Builder {
        private final Storage storage;
        private final BucketInfo.BuilderImpl infoBuilder;

        Builder(Bucket bucket) {
            this.storage = bucket.storage;
            this.infoBuilder = new BucketInfo.BuilderImpl(bucket);
        }

        @Override
        public Builder name(String name) {
            this.infoBuilder.name(name);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder owner(Acl.Entity owner) {
            this.infoBuilder.owner(owner);
            return this;
        }

        @Override
        Builder selfLink(String selfLink) {
            this.infoBuilder.selfLink(selfLink);
            return this;
        }

        @Override
        public Builder versioningEnabled(Boolean enable) {
            this.infoBuilder.versioningEnabled(enable);
            return this;
        }

        @Override
        public Builder indexPage(String indexPage) {
            this.infoBuilder.indexPage(indexPage);
            return this;
        }

        @Override
        public Builder notFoundPage(String notFoundPage) {
            this.infoBuilder.notFoundPage(notFoundPage);
            return this;
        }

        @Override
        public Builder deleteRules(Iterable<? extends BucketInfo.DeleteRule> rules) {
            this.infoBuilder.deleteRules(rules);
            return this;
        }

        @Override
        public Builder storageClass(String storageClass) {
            this.infoBuilder.storageClass(storageClass);
            return this;
        }

        @Override
        public Builder location(String location) {
            this.infoBuilder.location(location);
            return this;
        }

        @Override
        Builder etag(String etag) {
            this.infoBuilder.etag(etag);
            return this;
        }

        @Override
        Builder createTime(Long createTime) {
            this.infoBuilder.createTime(createTime);
            return this;
        }

        @Override
        Builder metageneration(Long metageneration) {
            this.infoBuilder.metageneration(metageneration);
            return this;
        }

        @Override
        public Builder cors(Iterable<Cors> cors) {
            this.infoBuilder.cors(cors);
            return this;
        }

        @Override
        public Builder acl(Iterable<Acl> acl) {
            this.infoBuilder.acl(acl);
            return this;
        }

        @Override
        public Builder defaultAcl(Iterable<Acl> acl) {
            this.infoBuilder.defaultAcl(acl);
            return this;
        }

        @Override
        public Bucket build() {
            return new Bucket(this.storage, this.infoBuilder);
        }
    }

    public static class BlobWriteOption
    implements Serializable {
        private static final Function<BlobWriteOption, Storage.BlobWriteOption.Option> TO_ENUM = new Function<BlobWriteOption, Storage.BlobWriteOption.Option>(){

            public Storage.BlobWriteOption.Option apply(BlobWriteOption blobWriteOption) {
                return blobWriteOption.option;
            }
        };
        private static final long serialVersionUID = 4722190734541993114L;
        private final Storage.BlobWriteOption.Option option;
        private final Object value;

        private StorageRpc.Tuple<BlobInfo, Storage.BlobWriteOption> toWriteOption(BlobInfo blobInfo) {
            BlobId blobId = blobInfo.blobId();
            switch (this.option) {
                case PREDEFINED_ACL: {
                    return StorageRpc.Tuple.of(blobInfo, Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)((Object)this.value)));
                }
                case IF_GENERATION_MATCH: {
                    blobId = BlobId.of(blobId.bucket(), blobId.name(), (Long)this.value);
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().blobId(blobId).build(), Storage.BlobWriteOption.generationMatch());
                }
                case IF_GENERATION_NOT_MATCH: {
                    blobId = BlobId.of(blobId.bucket(), blobId.name(), (Long)this.value);
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().blobId(blobId).build(), Storage.BlobWriteOption.generationNotMatch());
                }
                case IF_METAGENERATION_MATCH: {
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().metageneration((Long)this.value).build(), Storage.BlobWriteOption.metagenerationMatch());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().metageneration((Long)this.value).build(), Storage.BlobWriteOption.metagenerationNotMatch());
                }
                case IF_MD5_MATCH: {
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().md5((String)this.value).build(), Storage.BlobWriteOption.md5Match());
                }
                case IF_CRC32C_MATCH: {
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().crc32c((String)this.value).build(), Storage.BlobWriteOption.crc32cMatch());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private BlobWriteOption(Storage.BlobWriteOption.Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.option, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BlobWriteOption)) {
                return false;
            }
            BlobWriteOption other = (BlobWriteOption)obj;
            return this.option == other.option && Objects.equals(this.value, other.value);
        }

        public static BlobWriteOption predefinedAcl(Storage.PredefinedAcl acl) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.PREDEFINED_ACL, (Object)acl);
        }

        public static BlobWriteOption doesNotExist() {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobWriteOption generationMatch(long generation) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobWriteOption generationNotMatch(long generation) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobWriteOption metagenerationMatch(long metageneration) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobWriteOption metagenerationNotMatch(long metageneration) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BlobWriteOption md5Match(String md5) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_MD5_MATCH, md5);
        }

        public static BlobWriteOption crc32cMatch(String crc32c) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_CRC32C_MATCH, crc32c);
        }

        static StorageRpc.Tuple<BlobInfo, Storage.BlobWriteOption[]> toWriteOptions(BlobInfo info, BlobWriteOption ... options) {
            ImmutableSet optionSet = Sets.immutableEnumSet((Iterable)Lists.transform(Arrays.asList(options), TO_ENUM));
            Preconditions.checkArgument((!optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_METAGENERATION_NOT_MATCH) || !optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_METAGENERATION_MATCH) ? 1 : 0) != 0, (Object)"metagenerationMatch and metagenerationNotMatch options can not be both provided");
            Preconditions.checkArgument((!optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_GENERATION_NOT_MATCH) || !optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_GENERATION_MATCH) ? 1 : 0) != 0, (Object)"Only one option of generationMatch, doesNotExist or generationNotMatch can be provided");
            Storage.BlobWriteOption[] convertedOptions = new Storage.BlobWriteOption[options.length];
            BlobInfo writeInfo = info;
            int index = 0;
            for (BlobWriteOption option : options) {
                StorageRpc.Tuple<BlobInfo, Storage.BlobWriteOption> write = option.toWriteOption(writeInfo);
                writeInfo = write.x();
                convertedOptions[index++] = write.y();
            }
            return StorageRpc.Tuple.of(writeInfo, convertedOptions);
        }
    }

    public static class BlobTargetOption
    extends Option {
        private static final Function<BlobTargetOption, StorageRpc.Option> TO_ENUM = new Function<BlobTargetOption, StorageRpc.Option>(){

            public StorageRpc.Option apply(BlobTargetOption blobTargetOption) {
                return blobTargetOption.rpcOption();
            }
        };
        private static final long serialVersionUID = 8345296337342509425L;

        private BlobTargetOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption> toTargetOption(BlobInfo blobInfo) {
            BlobId blobId = blobInfo.blobId();
            switch (this.rpcOption()) {
                case PREDEFINED_ACL: {
                    return StorageRpc.Tuple.of(blobInfo, Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)((Object)this.value())));
                }
                case IF_GENERATION_MATCH: {
                    blobId = BlobId.of(blobId.bucket(), blobId.name(), (Long)this.value());
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().blobId(blobId).build(), Storage.BlobTargetOption.generationMatch());
                }
                case IF_GENERATION_NOT_MATCH: {
                    blobId = BlobId.of(blobId.bucket(), blobId.name(), (Long)this.value());
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().blobId(blobId).build(), Storage.BlobTargetOption.generationNotMatch());
                }
                case IF_METAGENERATION_MATCH: {
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().metageneration((Long)this.value()).build(), Storage.BlobTargetOption.metagenerationMatch());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return StorageRpc.Tuple.of(blobInfo.toBuilder().metageneration((Long)this.value()).build(), Storage.BlobTargetOption.metagenerationNotMatch());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BlobTargetOption predefinedAcl(Storage.PredefinedAcl acl) {
            return new BlobTargetOption(StorageRpc.Option.PREDEFINED_ACL, (Object)acl);
        }

        public static BlobTargetOption doesNotExist() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobTargetOption generationMatch(long generation) {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobTargetOption generationNotMatch(long generation) {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobTargetOption metagenerationMatch(long metageneration) {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobTargetOption metagenerationNotMatch(long metageneration) {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        static StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> toTargetOptions(BlobInfo info, BlobTargetOption ... options) {
            ImmutableSet optionSet = Sets.immutableEnumSet((Iterable)Lists.transform(Arrays.asList(options), TO_ENUM));
            Preconditions.checkArgument((!optionSet.contains((Object)StorageRpc.Option.IF_METAGENERATION_NOT_MATCH) || !optionSet.contains((Object)StorageRpc.Option.IF_METAGENERATION_MATCH) ? 1 : 0) != 0, (Object)"metagenerationMatch and metagenerationNotMatch options can not be both provided");
            Preconditions.checkArgument((!optionSet.contains((Object)StorageRpc.Option.IF_GENERATION_NOT_MATCH) || !optionSet.contains((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? 1 : 0) != 0, (Object)"Only one option of generationMatch, doesNotExist or generationNotMatch can be provided");
            Storage.BlobTargetOption[] convertedOptions = new Storage.BlobTargetOption[options.length];
            BlobInfo targetInfo = info;
            int index = 0;
            for (BlobTargetOption option : options) {
                StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption> target = option.toTargetOption(targetInfo);
                targetInfo = target.x();
                convertedOptions[index++] = target.y();
            }
            return StorageRpc.Tuple.of(targetInfo, convertedOptions);
        }
    }

    public static class BucketSourceOption
    extends Option {
        private static final long serialVersionUID = 6928872234155522371L;

        private BucketSourceOption(StorageRpc.Option rpcOption) {
            super(rpcOption, null);
        }

        private Storage.BucketSourceOption toSourceOption(BucketInfo bucketInfo) {
            switch (this.rpcOption()) {
                case IF_METAGENERATION_MATCH: {
                    return Storage.BucketSourceOption.metagenerationMatch(bucketInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BucketSourceOption.metagenerationNotMatch(bucketInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private Storage.BucketGetOption toGetOption(BucketInfo bucketInfo) {
            switch (this.rpcOption()) {
                case IF_METAGENERATION_MATCH: {
                    return Storage.BucketGetOption.metagenerationMatch(bucketInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BucketGetOption.metagenerationNotMatch(bucketInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BucketSourceOption metagenerationMatch() {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BucketSourceOption metagenerationNotMatch() {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        static Storage.BucketSourceOption[] toSourceOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketSourceOption[] convertedOptions = new Storage.BucketSourceOption[options.length];
            int index = 0;
            for (BucketSourceOption option : options) {
                convertedOptions[index++] = option.toSourceOption(bucketInfo);
            }
            return convertedOptions;
        }

        static Storage.BucketGetOption[] toGetOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketGetOption[] convertedOptions = new Storage.BucketGetOption[options.length];
            int index = 0;
            for (BucketSourceOption option : options) {
                convertedOptions[index++] = option.toGetOption(bucketInfo);
            }
            return convertedOptions;
        }
    }
}

