/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.storage.model.TestIamPermissionsResponse;
import com.google.auth.ServiceAccountSigner;
import com.google.cloud.BaseService;
import com.google.cloud.BatchResult;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobReadChannel;
import com.google.cloud.storage.BlobWriteChannel;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.PolicyHelper;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.net.UrlEscapers;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class StorageImpl
extends BaseService<StorageOptions>
implements Storage {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_BYTE_ARRAY_MD5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
    private static final String EMPTY_BYTE_ARRAY_CRC32C = "AAAAAA==";
    private static final String PATH_DELIMITER = "/";
    private static final Function<Tuple<Storage, Boolean>, Boolean> DELETE_FUNCTION = new Function<Tuple<Storage, Boolean>, Boolean>(){

        public Boolean apply(Tuple<Storage, Boolean> tuple) {
            return (Boolean)tuple.y();
        }
    };
    private final StorageRpc storageRpc;

    StorageImpl(StorageOptions options) {
        super((ServiceOptions)options);
        this.storageRpc = options.getStorageRpcV1();
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        try {
            return Bucket.fromPb(this, (com.google.api.services.storage.model.Bucket)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Bucket>(){

                @Override
                public com.google.api.services.storage.model.Bucket call() {
                    return StorageImpl.this.storageRpc.create(bucketPb, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(EMPTY_BYTE_ARRAY_MD5).setCrc32c(EMPTY_BYTE_ARRAY_CRC32C).build();
        return this.create(updatedInfo, (InputStream)new ByteArrayInputStream(EMPTY_BYTE_ARRAY), options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content).asInt()))).build();
        return this.create(updatedInfo, (InputStream)new ByteArrayInputStream(content), options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.create((BlobInfo)targetOptions.x(), content, (Storage.BlobTargetOption[])targetOptions.y());
    }

    private Blob create(BlobInfo info, final InputStream content, Storage.BlobTargetOption ... options) {
        final StorageObject blobPb = info.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(info, (Option[])options);
        try {
            return Blob.fromPb(this, (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.create(blobPb, (InputStream)MoreObjects.firstNonNull((Object)content, (Object)new ByteArrayInputStream(EMPTY_BYTE_ARRAY)), optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = BucketInfo.of(bucket).toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        try {
            com.google.api.services.storage.model.Bucket answer = (com.google.api.services.storage.model.Bucket)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Bucket>(){

                @Override
                public com.google.api.services.storage.model.Bucket call() {
                    return StorageImpl.this.storageRpc.get(bucketPb, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return answer == null ? null : Bucket.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        final StorageObject storedObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        try {
            StorageObject storageObject = (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.get(storedObject, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return storageObject == null ? null : Blob.fromPb(this, storageObject);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        return StorageImpl.listBuckets((StorageOptions)this.getOptions(), StorageImpl.optionMap(options));
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        return StorageImpl.listBlobs(bucket, (StorageOptions)this.getOptions(), StorageImpl.optionMap(options));
    }

    private static Page<Bucket> listBuckets(final StorageOptions serviceOptions, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.storage.model.Bucket>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.storage.model.Bucket>> call() {
                    return serviceOptions.getStorageRpcV1().list(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            ImmutableList buckets = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.storage.model.Bucket, Bucket>(){

                public Bucket apply(com.google.api.services.storage.model.Bucket bucketPb) {
                    return Bucket.fromPb((Storage)serviceOptions.getService(), bucketPb);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BucketPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)buckets);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static Page<Blob> listBlobs(final String bucket, final StorageOptions serviceOptions, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<StorageObject>>>(){

                @Override
                public Tuple<String, Iterable<StorageObject>> call() {
                    return serviceOptions.getStorageRpcV1().list(bucket, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            ImmutableList blobs = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<StorageObject, Blob>(){

                public Blob apply(StorageObject storageObject) {
                    return Blob.fromPb((Storage)serviceOptions.getService(), storageObject);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(bucket, serviceOptions, cursor, optionsMap), cursor, (Iterable)blobs);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = bucketInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(bucketInfo, (Option[])options);
        try {
            return Bucket.fromPb(this, (com.google.api.services.storage.model.Bucket)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Bucket>(){

                @Override
                public com.google.api.services.storage.model.Bucket call() {
                    return StorageImpl.this.storageRpc.patch(bucketPb, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        final StorageObject storageObject = blobInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        try {
            return Blob.fromPb(this, (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.patch(storageObject, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        final com.google.api.services.storage.model.Bucket bucketPb = BucketInfo.of(bucket).toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.delete(bucketPb, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        final StorageObject storageObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.delete(storageObject, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        final ArrayList sources = Lists.newArrayListWithCapacity((int)composeRequest.getSourceBlobs().size());
        for (Storage.ComposeRequest.SourceBlob sourceBlob : composeRequest.getSourceBlobs()) {
            sources.add(BlobInfo.newBuilder(BlobId.of(composeRequest.getTarget().getBucket(), sourceBlob.getName(), sourceBlob.getGeneration())).build().toPb());
        }
        final StorageObject target = composeRequest.getTarget().toPb();
        final Map<StorageRpc.Option, ?> targetOptions = StorageImpl.optionMap(composeRequest.getTarget().getGeneration(), composeRequest.getTarget().getMetageneration(), composeRequest.getTargetOptions());
        try {
            return Blob.fromPb(this, (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.compose(sources, target, targetOptions);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public CopyWriter copy(final Storage.CopyRequest copyRequest) {
        final StorageObject source = copyRequest.getSource().toPb();
        final Map<StorageRpc.Option, ?> sourceOptions = StorageImpl.optionMap(copyRequest.getSource().getGeneration(), null, copyRequest.getSourceOptions(), true);
        final StorageObject targetObject = copyRequest.getTarget().toPb();
        final Map<StorageRpc.Option, ?> targetOptions = StorageImpl.optionMap(copyRequest.getTarget().getGeneration(), copyRequest.getTarget().getMetageneration(), copyRequest.getTargetOptions());
        try {
            StorageRpc.RewriteResponse rewriteResponse = (StorageRpc.RewriteResponse)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.RewriteResponse>(){

                @Override
                public StorageRpc.RewriteResponse call() {
                    return StorageImpl.this.storageRpc.openRewrite(new StorageRpc.RewriteRequest(source, sourceOptions, copyRequest.overrideInfo(), targetObject, targetOptions, copyRequest.getMegabytesCopiedPerChunk()));
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return new CopyWriter((StorageOptions)this.getOptions(), rewriteResponse);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        final StorageObject storageObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        try {
            return (byte[])RetryHelper.runWithRetries((Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() {
                    return StorageImpl.this.storageRpc.load(storageObject, optionsMap);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public StorageBatch batch() {
        return new StorageBatch((StorageOptions)this.getOptions());
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(options);
        return new BlobReadChannel((StorageOptions)this.getOptions(), BlobId.of(bucket, blob), optionsMap);
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blob, (Option[])options);
        return new BlobReadChannel((StorageOptions)this.getOptions(), blob, optionsMap);
    }

    public BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.writer((BlobInfo)targetOptions.x(), (Storage.BlobTargetOption[])targetOptions.y());
    }

    private BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = StorageImpl.optionMap(blobInfo, (Option[])options);
        return new BlobWriteChannel((StorageOptions)this.getOptions(), blobInfo, optionsMap);
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.SignUrlOption option : options) {
            optionMap.put(option.getOption(), option.getValue());
        }
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState((boolean)(((StorageOptions)this.getOptions()).getCredentials() instanceof ServiceAccountSigner), (Object)"Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)((StorageOptions)this.getOptions()).getCredentials();
        }
        StringBuilder stBuilder = new StringBuilder();
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.HTTP_METHOD)) {
            stBuilder.append(optionMap.get((Object)Storage.SignUrlOption.Option.HTTP_METHOD));
        } else {
            stBuilder.append((Object)HttpMethod.GET);
        }
        stBuilder.append('\n');
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.MD5)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.getMd5() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for md5");
            stBuilder.append(blobInfo.getMd5());
        }
        stBuilder.append('\n');
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.CONTENT_TYPE)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.getContentType() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for content-type");
            stBuilder.append(blobInfo.getContentType());
        }
        stBuilder.append('\n');
        long expiration = TimeUnit.SECONDS.convert(((StorageOptions)this.getOptions()).getClock().millisTime() + unit.toMillis(duration), TimeUnit.MILLISECONDS);
        stBuilder.append(expiration).append('\n');
        StringBuilder path = new StringBuilder();
        if (!blobInfo.getBucket().startsWith(PATH_DELIMITER)) {
            path.append('/');
        }
        path.append(blobInfo.getBucket());
        if (!blobInfo.getBucket().endsWith(PATH_DELIMITER)) {
            path.append('/');
        }
        if (blobInfo.getName().startsWith(PATH_DELIMITER)) {
            path.setLength(path.length() - 1);
        }
        String escapedName = UrlEscapers.urlFragmentEscaper().escape(blobInfo.getName());
        path.append(escapedName.replace("?", "%3F"));
        stBuilder.append((CharSequence)path);
        try {
            byte[] signatureBytes = credentials.sign(stBuilder.toString().getBytes(StandardCharsets.UTF_8));
            stBuilder = new StringBuilder("https://storage.googleapis.com").append((CharSequence)path);
            String signature = URLEncoder.encode(BaseEncoding.base64().encode(signatureBytes), StandardCharsets.UTF_8.name());
            stBuilder.append("?GoogleAccessId=").append(credentials.getAccount());
            stBuilder.append("&Expires=").append(expiration);
            stBuilder.append("&Signature=").append(signature);
            return new URL(stBuilder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return this.get(Arrays.asList(blobIds));
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.get(blob, new Storage.BlobGetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.update(Arrays.asList(blobInfos));
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobInfo blobInfo : blobInfos) {
            batch.update(blobInfo, new Storage.BlobTargetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return this.delete(Arrays.asList(blobIds));
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.delete(blob, new Storage.BlobSourceOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Boolean, StorageException>(){

                public void success(Boolean result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(Boolean.FALSE);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public Acl getAcl(final String bucket, final Acl.Entity entity) {
        try {
            BucketAccessControl answer = (BucketAccessControl)RetryHelper.runWithRetries((Callable)new Callable<BucketAccessControl>(){

                @Override
                public BucketAccessControl call() {
                    return StorageImpl.this.storageRpc.getAcl(bucket, entity.toPb());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return answer == null ? null : Acl.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteAcl(final String bucket, final Acl.Entity entity) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.deleteAcl(bucket, entity.toPb());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        final BucketAccessControl aclPb = acl.toBucketPb().setBucket(bucket);
        try {
            return Acl.fromPb((BucketAccessControl)RetryHelper.runWithRetries((Callable)new Callable<BucketAccessControl>(){

                @Override
                public BucketAccessControl call() {
                    return StorageImpl.this.storageRpc.createAcl(aclPb);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        final BucketAccessControl aclPb = acl.toBucketPb().setBucket(bucket);
        try {
            return Acl.fromPb((BucketAccessControl)RetryHelper.runWithRetries((Callable)new Callable<BucketAccessControl>(){

                @Override
                public BucketAccessControl call() {
                    return StorageImpl.this.storageRpc.patchAcl(aclPb);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Acl> listAcls(final String bucket) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<BucketAccessControl>>(){

                @Override
                public List<BucketAccessControl> call() {
                    return StorageImpl.this.storageRpc.listAcls(bucket);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return Lists.transform((List)answer, Acl.FROM_BUCKET_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl getDefaultAcl(final String bucket, final Acl.Entity entity) {
        try {
            ObjectAccessControl answer = (ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.getDefaultAcl(bucket, entity.toPb());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return answer == null ? null : Acl.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteDefaultAcl(final String bucket, final Acl.Entity entity) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.deleteDefaultAcl(bucket, entity.toPb());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(bucket);
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.createDefaultAcl(aclPb);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(bucket);
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.patchDefaultAcl(aclPb);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Acl> listDefaultAcls(final String bucket) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<ObjectAccessControl>>(){

                @Override
                public List<ObjectAccessControl> call() {
                    return StorageImpl.this.storageRpc.listDefaultAcls(bucket);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return Lists.transform((List)answer, Acl.FROM_OBJECT_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl getAcl(final BlobId blob, final Acl.Entity entity) {
        try {
            ObjectAccessControl answer = (ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.getAcl(blob.getBucket(), blob.getName(), blob.getGeneration(), entity.toPb());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return answer == null ? null : Acl.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteAcl(final BlobId blob, final Acl.Entity entity) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.deleteAcl(blob.getBucket(), blob.getName(), blob.getGeneration(), entity.toPb());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.createAcl(aclPb);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        final ObjectAccessControl aclPb = acl.toObjectPb().setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        try {
            return Acl.fromPb((ObjectAccessControl)RetryHelper.runWithRetries((Callable)new Callable<ObjectAccessControl>(){

                @Override
                public ObjectAccessControl call() {
                    return StorageImpl.this.storageRpc.patchAcl(aclPb);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Acl> listAcls(final BlobId blob) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<ObjectAccessControl>>(){

                @Override
                public List<ObjectAccessControl> call() {
                    return StorageImpl.this.storageRpc.listAcls(blob.getBucket(), blob.getName(), blob.getGeneration());
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            return Lists.transform((List)answer, Acl.FROM_OBJECT_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Policy getIamPolicy(final String bucket) {
        try {
            return PolicyHelper.convertFromApiPolicy((com.google.api.services.storage.model.Policy)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Policy>(){

                @Override
                public com.google.api.services.storage.model.Policy call() {
                    return StorageImpl.this.storageRpc.getIamPolicy(bucket);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public Policy setIamPolicy(final String bucket, final Policy policy) {
        try {
            return PolicyHelper.convertFromApiPolicy((com.google.api.services.storage.model.Policy)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Policy>(){

                @Override
                public com.google.api.services.storage.model.Policy call() {
                    return StorageImpl.this.storageRpc.setIamPolicy(bucket, PolicyHelper.convertToApiPolicy(policy));
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public List<Boolean> testIamPermissions(final String bucket, final List<String> permissions) {
        try {
            TestIamPermissionsResponse response = (TestIamPermissionsResponse)RetryHelper.runWithRetries((Callable)new Callable<TestIamPermissionsResponse>(){

                @Override
                public TestIamPermissionsResponse call() {
                    return StorageImpl.this.storageRpc.testIamPermissions(bucket, permissions);
                }
            }, (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ExceptionHandler)EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
            ImmutableSet heldPermissions = response.getPermissions() != null ? ImmutableSet.copyOf((Collection)response.getPermissions()) : ImmutableSet.of();
            return Lists.transform(permissions, (Function)new Function<String, Boolean>((Set)heldPermissions){
                final /* synthetic */ Set val$heldPermissions;
                {
                    this.val$heldPermissions = set;
                }

                public Boolean apply(String permission) {
                    return this.val$heldPermissions.contains(permission);
                }
            });
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static <T> void addToOptionMap(StorageRpc.Option option, T defaultValue, Map<StorageRpc.Option, Object> map) {
        StorageImpl.addToOptionMap(option, option, defaultValue, map);
    }

    private static <T> void addToOptionMap(StorageRpc.Option getOption, StorageRpc.Option putOption, T defaultValue, Map<StorageRpc.Option, Object> map) {
        if (map.containsKey((Object)getOption)) {
            Object value = map.remove((Object)getOption);
            Preconditions.checkArgument((value != null || defaultValue != null ? 1 : 0) != 0, (Object)("Option " + getOption.value() + " is missing a value"));
            value = MoreObjects.firstNonNull((Object)value, defaultValue);
            map.put(putOption, value);
        }
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options) {
        return StorageImpl.optionMap(generation, metaGeneration, options, false);
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options, boolean useAsSource) {
        EnumMap temp = Maps.newEnumMap(StorageRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        Boolean value = (Boolean)temp.remove((Object)StorageRpc.Option.DELIMITER);
        if (Boolean.TRUE.equals(value)) {
            temp.put(StorageRpc.Option.DELIMITER, PATH_DELIMITER);
        }
        if (useAsSource) {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        } else {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    private static Map<StorageRpc.Option, ?> optionMap(Option ... options) {
        return StorageImpl.optionMap(null, null, Arrays.asList(options));
    }

    private static Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Option ... options) {
        return StorageImpl.optionMap(generation, metaGeneration, Arrays.asList(options));
    }

    private static Map<StorageRpc.Option, ?> optionMap(BucketInfo bucketInfo, Option ... options) {
        return StorageImpl.optionMap(null, bucketInfo.getMetageneration(), options);
    }

    static Map<StorageRpc.Option, ?> optionMap(BlobInfo blobInfo, Option ... options) {
        return StorageImpl.optionMap(blobInfo.getGeneration(), blobInfo.getMetageneration(), options);
    }

    static Map<StorageRpc.Option, ?> optionMap(BlobId blobId, Option ... options) {
        return StorageImpl.optionMap(blobId.getGeneration(), null, options);
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<Blob> {
        private static final long serialVersionUID = 81807334445874098L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;
        private final String bucket;

        BlobPageFetcher(String bucket, StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.bucket = bucket;
        }

        public Page<Blob> getNextPage() {
            return StorageImpl.listBlobs(this.bucket, this.serviceOptions, this.requestOptions);
        }
    }

    private static class BucketPageFetcher
    implements PageImpl.NextPageFetcher<Bucket> {
        private static final long serialVersionUID = 5850406828803613729L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;

        BucketPageFetcher(StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Bucket> getNextPage() {
            return StorageImpl.listBuckets(this.serviceOptions, this.requestOptions);
        }
    }
}

