/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.BaseWriteChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

class BlobWriteChannel
extends BaseWriteChannel<StorageOptions, BlobInfo> {
    private StorageObject storageObject;
    private boolean retrying = false;

    BlobWriteChannel(StorageOptions options, BlobInfo blob, Map<StorageRpc.Option, ?> optionsMap) {
        this(options, blob, BlobWriteChannel.open(options, blob, optionsMap));
    }

    BlobWriteChannel(StorageOptions options, URL signedURL) {
        this(options, BlobWriteChannel.open(signedURL, options));
    }

    BlobWriteChannel(StorageOptions options, BlobInfo blobInfo, String uploadId) {
        super((ServiceOptions)options, (Serializable)blobInfo, uploadId);
    }

    BlobWriteChannel(StorageOptions options, String uploadId) {
        super((ServiceOptions)options, null, uploadId);
    }

    boolean isRetrying() {
        return this.retrying;
    }

    StorageObject getStorageObject() {
        return this.storageObject;
    }

    protected void flushBuffer(final int length, final boolean last) {
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    if (!BlobWriteChannel.this.isRetrying()) {
                        BlobWriteChannel.this.retrying = true;
                        BlobWriteChannel.this.storageObject = ((StorageOptions)BlobWriteChannel.this.getOptions()).getStorageRpcV1().writeWithResponse(BlobWriteChannel.this.getUploadId(), BlobWriteChannel.this.getBuffer(), 0, BlobWriteChannel.this.getPosition(), length, last);
                    } else {
                        long remoteNextByteOffset = ((StorageOptions)BlobWriteChannel.this.getOptions()).getStorageRpcV1().getCurrentUploadOffset(BlobWriteChannel.this.getUploadId());
                        long localNextByteOffset = BlobWriteChannel.this.getPosition();
                        int driftOffset = (int)(remoteNextByteOffset - localNextByteOffset);
                        int retryChunkLength = length - driftOffset;
                        if (localNextByteOffset == 0L && remoteNextByteOffset == 0L || localNextByteOffset == remoteNextByteOffset) {
                            BlobWriteChannel.this.storageObject = ((StorageOptions)BlobWriteChannel.this.getOptions()).getStorageRpcV1().writeWithResponse(BlobWriteChannel.this.getUploadId(), BlobWriteChannel.this.getBuffer(), 0, BlobWriteChannel.this.getPosition(), length, last);
                        } else if (localNextByteOffset < remoteNextByteOffset && driftOffset < BlobWriteChannel.this.getChunkSize()) {
                            BlobWriteChannel.this.storageObject = ((StorageOptions)BlobWriteChannel.this.getOptions()).getStorageRpcV1().writeWithResponse(BlobWriteChannel.this.getUploadId(), BlobWriteChannel.this.getBuffer(), driftOffset, remoteNextByteOffset, retryChunkLength, last);
                        } else {
                            if (localNextByteOffset < remoteNextByteOffset && driftOffset == BlobWriteChannel.this.getChunkSize()) {
                                BlobWriteChannel.this.retrying = false;
                                return;
                            }
                            if (localNextByteOffset < remoteNextByteOffset && driftOffset > BlobWriteChannel.this.getChunkSize()) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Remote offset has progressed beyond starting byte offset of next chunk.");
                                sb.append("This may be a symptom of multiple clients uploading to the same upload session.\n\n");
                                sb.append("For debugging purposes:\n");
                                sb.append("uploadId: ").append(BlobWriteChannel.this.getUploadId()).append('\n');
                                sb.append("localNextByteOffset: ").append(localNextByteOffset).append('\n');
                                sb.append("remoteNextByteOffset: ").append(remoteNextByteOffset).append('\n');
                                sb.append("driftOffset: ").append(driftOffset).append("\n\n");
                                throw new StorageException(0, sb.toString());
                            }
                            if (remoteNextByteOffset == -1L && last) {
                                BlobWriteChannel.this.retrying = false;
                                return;
                            }
                            if (remoteNextByteOffset == -1L && !last) {
                                throw new StorageException(0, "Resumable upload is already complete.");
                            }
                        }
                    }
                    BlobWriteChannel.this.retrying = false;
                }
            }), (RetrySettings)((StorageOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)StorageImpl.EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((StorageOptions)this.getOptions(), (BlobInfo)this.getEntity(), this.getUploadId());
    }

    private static String open(final StorageOptions options, final BlobInfo blob, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            return (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return options.getStorageRpcV1().open(blob.toPb(), optionsMap);
                }
            }, (RetrySettings)options.getRetrySettings(), (ResultRetryAlgorithm)StorageImpl.EXCEPTION_HANDLER, (ApiClock)options.getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static String open(final URL signedURL, final StorageOptions options) {
        try {
            return (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    if (!BlobWriteChannel.isValidSignedURL(signedURL.getQuery())) {
                        throw new StorageException(2, "invalid signedURL");
                    }
                    return options.getStorageRpcV1().open(signedURL.toString());
                }
            }, (RetrySettings)options.getRetrySettings(), (ResultRetryAlgorithm)StorageImpl.EXCEPTION_HANDLER, (ApiClock)options.getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static boolean isValidSignedURL(String signedURLQuery) {
        boolean isValid = true;
        if (signedURLQuery.startsWith("X-Goog-Algorithm=")) {
            if (!(signedURLQuery.contains("&X-Goog-Credential=") && signedURLQuery.contains("&X-Goog-Date=") && signedURLQuery.contains("&X-Goog-Expires=") && signedURLQuery.contains("&X-Goog-SignedHeaders=") && signedURLQuery.contains("&X-Goog-Signature="))) {
                isValid = false;
            }
        } else if (signedURLQuery.startsWith("GoogleAccessId=")) {
            if (!signedURLQuery.contains("&Expires=") || !signedURLQuery.contains("&Signature=")) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<StorageOptions, BlobInfo> {
        private static final long serialVersionUID = -9028324143780151286L;

        StateImpl(Builder builder) {
            super((BaseWriteChannel.BaseState.Builder)builder);
        }

        static Builder builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
            return new Builder(options, blobInfo, uploadId);
        }

        public WriteChannel restore() {
            BlobWriteChannel channel = new BlobWriteChannel((StorageOptions)this.serviceOptions, (BlobInfo)this.entity, this.uploadId);
            channel.restore(this);
            return channel;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<StorageOptions, BlobInfo> {
            private Builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
                super((ServiceOptions)options, (Serializable)blobInfo, uploadId);
            }

            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

