/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.spi.v1;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.IOUtils;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.BucketAccessControls;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.Notification;
import com.google.api.services.storage.model.Notifications;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.ObjectAccessControls;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.Policy;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.ServiceAccount;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.storage.model.TestIamPermissionsResponse;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.http.CensusHttpModule;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.HttpStorageRpcSpans;
import com.google.cloud.storage.spi.v1.RpcBatch;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HttpStorageRpc
implements StorageRpc {
    public static final String DEFAULT_PROJECTION = "full";
    private static final String ENCRYPTION_KEY_PREFIX = "x-goog-encryption-";
    private static final String SOURCE_ENCRYPTION_KEY_PREFIX = "x-goog-copy-source-encryption-";
    private final StorageOptions options;
    private final Storage storage;
    private final Tracer tracer = Tracing.getTracer();
    private final CensusHttpModule censusHttpModule;
    private final HttpRequestInitializer batchRequestInitializer;
    private static final long MEGABYTE = 0x100000L;

    public HttpStorageRpc(StorageOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.options = options;
        this.censusHttpModule = new CensusHttpModule(this.tracer, true);
        initializer = this.censusHttpModule.getHttpRequestInitializer(initializer);
        this.batchRequestInitializer = this.censusHttpModule.getHttpRequestInitializer(null);
        HttpStorageRpcSpans.registerAllSpanNamesForCollection();
        this.storage = new Storage.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
    }

    private static <T> JsonBatchCallback<T> toJsonCallback(final RpcBatch.Callback<T> callback) {
        return new JsonBatchCallback<T>(){

            public void onSuccess(T response, HttpHeaders httpHeaders) throws IOException {
                callback.onSuccess(response);
            }

            public void onFailure(GoogleJsonError googleJsonError, HttpHeaders httpHeaders) throws IOException {
                callback.onFailure(googleJsonError);
            }
        };
    }

    private static StorageException translate(IOException exception) {
        return new StorageException(exception);
    }

    private static StorageException translate(GoogleJsonError exception) {
        return new StorageException(exception);
    }

    private static void setEncryptionHeaders(HttpHeaders headers, String headerPrefix, Map<StorageRpc.Option, ?> options) {
        String key = StorageRpc.Option.CUSTOMER_SUPPLIED_KEY.getString(options);
        if (key != null) {
            BaseEncoding base64 = BaseEncoding.base64();
            HashFunction hashFunction = Hashing.sha256();
            headers.set(headerPrefix + "algorithm", (Object)"AES256");
            headers.set(headerPrefix + "key", (Object)key);
            headers.set(headerPrefix + "key-sha256", (Object)base64.encode(hashFunction.hashBytes(base64.decode((CharSequence)key)).asBytes()));
        }
    }

    private Span startSpan(String spanName) {
        return this.tracer.spanBuilder(spanName).setRecordEvents(this.censusHttpModule.isRecordEvents()).startSpan();
    }

    @Override
    public Bucket create(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Bucket bucket2 = (Bucket)this.storage.buckets().insert(this.options.getProjectId(), bucket).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setPredefinedDefaultObjectAcl(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL.getString(options)).execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public StorageObject create(StorageObject storageObject, InputStream content, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Insert insert = this.storage.objects().insert(storageObject.getBucket(), storageObject, (AbstractInputStreamContent)new InputStreamContent(storageObject.getContentType(), content));
            insert.getMediaHttpUploader().setDirectUploadEnabled(true);
            HttpStorageRpc.setEncryptionHeaders(insert.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, options);
            StorageObject storageObject2 = (StorageObject)insert.setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setKmsKeyName(StorageRpc.Option.KMS_KEY_NAME.getString(options)).execute();
            return storageObject2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Tuple<String, Iterable<Bucket>> list(Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_BUCKETS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Buckets buckets = (Buckets)this.storage.buckets().list(this.options.getProjectId()).setProjection(DEFAULT_PROJECTION).setPrefix(StorageRpc.Option.PREFIX.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            Tuple tuple = Tuple.of((Object)buckets.getNextPageToken(), (Object)buckets.getItems());
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Tuple<String, Iterable<StorageObject>> list(String bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_OBJECTS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Objects objects = (Objects)this.storage.objects().list(bucket).setProjection(DEFAULT_PROJECTION).setVersions(StorageRpc.Option.VERSIONS.getBoolean(options)).setDelimiter(StorageRpc.Option.DELIMITER.getString(options)).setPrefix(StorageRpc.Option.PREFIX.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            Iterable storageObjects = Iterables.concat((Iterable)((Iterable)MoreObjects.firstNonNull((Object)objects.getItems(), (Object)ImmutableList.of())), (Iterable)(objects.getPrefixes() != null ? Lists.transform((List)objects.getPrefixes(), HttpStorageRpc.objectFromPrefix(bucket)) : ImmutableList.of()));
            Tuple tuple = Tuple.of((Object)objects.getNextPageToken(), (Object)storageObjects);
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private static Function<String, StorageObject> objectFromPrefix(final String bucket) {
        return new Function<String, StorageObject>(){

            public StorageObject apply(String prefix) {
                return new StorageObject().set("isDirectory", (Object)true).setBucket(bucket).setName(prefix).setSize(BigInteger.ZERO);
            }
        };
    }

    @Override
    public Bucket get(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Bucket bucket2 = (Bucket)this.storage.buckets().get(bucket.getName()).setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                Bucket bucket3 = null;
                return bucket3;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private Storage.Objects.Get getCall(StorageObject object, Map<StorageRpc.Option, ?> options) throws IOException {
        return this.storage.objects().get(object.getBucket(), object.getName()).setGeneration(object.getGeneration()).setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
    }

    @Override
    public StorageObject get(StorageObject object, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageObject storageObject = (StorageObject)this.getCall(object, options).execute();
            return storageObject;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                StorageObject storageObject = null;
                return storageObject;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Bucket patch(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Bucket bucket2 = (Bucket)this.storage.buckets().patch(bucket.getName(), bucket).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setPredefinedDefaultObjectAcl(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private Storage.Objects.Patch patchCall(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws IOException {
        return this.storage.objects().patch(storageObject.getBucket(), storageObject.getName(), storageObject).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
    }

    @Override
    public StorageObject patch(StorageObject storageObject, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageObject storageObject2 = (StorageObject)this.patchCall(storageObject, options).execute();
            return storageObject2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public boolean delete(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.storage.buckets().delete(bucket.getName()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private Storage.Objects.Delete deleteCall(StorageObject blob, Map<StorageRpc.Option, ?> options) throws IOException {
        return this.storage.objects().delete(blob.getBucket(), blob.getName()).setGeneration(blob.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
    }

    @Override
    public boolean delete(StorageObject blob, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.deleteCall(blob, options).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public StorageObject compose(Iterable<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> targetOptions) {
        ComposeRequest.SourceObjects sourceObject;
        ComposeRequest request = new ComposeRequest();
        request.setDestination(target);
        ArrayList<ComposeRequest.SourceObjects> sourceObjects = new ArrayList<ComposeRequest.SourceObjects>();
        for (StorageObject source : sources) {
            sourceObject = new ComposeRequest.SourceObjects();
            sourceObject.setName(source.getName());
            Long generation = source.getGeneration();
            if (generation != null) {
                sourceObject.setGeneration(generation);
                sourceObject.setObjectPreconditions(new ComposeRequest.SourceObjects.ObjectPreconditions().setIfGenerationMatch(generation));
            }
            sourceObjects.add(sourceObject);
        }
        request.setSourceObjects(sourceObjects);
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_COMPOSE);
        Scope scope = this.tracer.withSpan(span);
        try {
            sourceObject = (StorageObject)this.storage.objects().compose(target.getBucket(), target.getName(), request).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(targetOptions)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(targetOptions)).execute();
            return sourceObject;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public byte[] load(StorageObject from, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LOAD);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Get getRequest = this.storage.objects().get(from.getBucket(), from.getName()).setGeneration(from.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setEncryptionHeaders(getRequest.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, options);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            getRequest.executeMedia().download((OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public RpcBatch createBatch() {
        return new DefaultRpcBatch(this.storage);
    }

    @Override
    public Tuple<String, byte[]> read(StorageObject from, Map<StorageRpc.Option, ?> options, long position, int bytes) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_READ);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Get req = this.storage.objects().get(from.getBucket(), from.getName()).setGeneration(from.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0, (String)"Position should be non-negative, is %d", (long)position);
            StringBuilder range = new StringBuilder();
            range.append("bytes=").append(position).append("-").append(position + (long)bytes - 1L);
            HttpHeaders requestHeaders = req.getRequestHeaders();
            requestHeaders.setRange(range.toString());
            HttpStorageRpc.setEncryptionHeaders(requestHeaders, ENCRYPTION_KEY_PREFIX, options);
            ByteArrayOutputStream output = new ByteArrayOutputStream(bytes);
            HttpResponse httpResponse = req.executeMedia();
            String contentEncoding = httpResponse.getContentEncoding();
            if (contentEncoding != null && contentEncoding.contains("gzip")) {
                try {
                    Field responseField = httpResponse.getClass().getDeclaredField("response");
                    responseField.setAccessible(true);
                    LowLevelHttpResponse lowLevelHttpResponse = (LowLevelHttpResponse)responseField.get(httpResponse);
                    IOUtils.copy((InputStream)lowLevelHttpResponse.getContent(), (OutputStream)output);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    throw new StorageException(0, "Error parsing gzip response", ex);
                }
            } else {
                httpResponse.download((OutputStream)output);
            }
            String etag = req.getLastResponseHeaders().getETag();
            Tuple tuple = Tuple.of((Object)etag, (Object)output.toByteArray());
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 416) {
                Tuple tuple = Tuple.of(null, (Object)new byte[0]);
                return tuple;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public void write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_WRITE);
        Scope scope = this.tracer.withSpan(span);
        try {
            String message;
            int code;
            if (length == 0 && !last) {
                return;
            }
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest httpRequest = this.storage.getRequestFactory().buildPutRequest(url, (HttpContent)new ByteArrayContent(null, toWrite, toWriteOffset, length));
            long limit = destOffset + (long)length;
            StringBuilder range = new StringBuilder("bytes ");
            if (length == 0) {
                range.append('*');
            } else {
                range.append(destOffset).append('-').append(limit - 1L);
            }
            range.append('/');
            if (last) {
                range.append(limit);
            } else {
                range.append('*');
            }
            httpRequest.getHeaders().setContentRange(range.toString());
            HttpResponseException exception = null;
            try {
                HttpResponse response = httpRequest.execute();
                code = response.getStatusCode();
                message = response.getStatusMessage();
            }
            catch (HttpResponseException ex) {
                exception = ex;
                code = ex.getStatusCode();
                message = ex.getStatusMessage();
            }
            if (!last && code != 308 || last && code != 200 && code != 201) {
                if (exception != null) {
                    throw exception;
                }
                GoogleJsonError error = new GoogleJsonError();
                error.setCode(code);
                error.setMessage(message);
                throw HttpStorageRpc.translate(error);
            }
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public String open(StorageObject object, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_OPEN);
        Scope scope = this.tracer.withSpan(span);
        try {
            HttpResponse response;
            Storage.Objects.Insert req = this.storage.objects().insert(object.getBucket(), object);
            GenericUrl url = req.buildHttpRequest().getUrl();
            String scheme = url.getScheme();
            String host = url.getHost();
            int port = url.getPort();
            port = port < 0 ? port : url.toURL().getDefaultPort();
            String path = "/upload" + url.getRawPath();
            url = new GenericUrl(scheme + "://" + host + ":" + port + path);
            url.set("uploadType", (Object)"resumable");
            url.set("name", (Object)object.getName());
            for (StorageRpc.Option option : options.keySet()) {
                Object content = option.get(options);
                if (content == null) continue;
                url.set(option.value(), (Object)content.toString());
            }
            JsonFactory jsonFactory = this.storage.getJsonFactory();
            HttpRequestFactory requestFactory = this.storage.getRequestFactory();
            HttpRequest httpRequest = requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(jsonFactory, (Object)object));
            HttpHeaders requestHeaders = httpRequest.getHeaders();
            requestHeaders.set("X-Upload-Content-Type", MoreObjects.firstNonNull((Object)object.getContentType(), (Object)"application/octet-stream"));
            String key = StorageRpc.Option.CUSTOMER_SUPPLIED_KEY.getString(options);
            if (key != null) {
                BaseEncoding base64 = BaseEncoding.base64();
                HashFunction hashFunction = Hashing.sha256();
                requestHeaders.set("x-goog-encryption-algorithm", (Object)"AES256");
                requestHeaders.set("x-goog-encryption-key", (Object)key);
                requestHeaders.set("x-goog-encryption-key-sha256", (Object)base64.encode(hashFunction.hashBytes(base64.decode((CharSequence)key)).asBytes()));
            }
            if ((response = httpRequest.execute()).getStatusCode() != 200) {
                GoogleJsonError error = new GoogleJsonError();
                error.setCode(response.getStatusCode());
                error.setMessage(response.getStatusMessage());
                throw HttpStorageRpc.translate(error);
            }
            String string = response.getHeaders().getLocation();
            return string;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageRpc.RewriteResponse openRewrite(StorageRpc.RewriteRequest rewriteRequest) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_OPEN_REWRITE);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageRpc.RewriteResponse rewriteResponse = this.rewrite(rewriteRequest, null);
            return rewriteResponse;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageRpc.RewriteResponse continueRewrite(StorageRpc.RewriteResponse previousResponse) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CONTINUE_REWRITE);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageRpc.RewriteResponse rewriteResponse = this.rewrite(previousResponse.rewriteRequest, previousResponse.rewriteToken);
            return rewriteResponse;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private StorageRpc.RewriteResponse rewrite(StorageRpc.RewriteRequest req, String token) {
        try {
            String userProject = StorageRpc.Option.USER_PROJECT.getString(req.sourceOptions);
            if (userProject == null) {
                userProject = StorageRpc.Option.USER_PROJECT.getString(req.targetOptions);
            }
            String kmsKeyName = StorageRpc.Option.KMS_KEY_NAME.getString(req.targetOptions);
            Long maxBytesRewrittenPerCall = req.megabytesRewrittenPerCall != null ? Long.valueOf(req.megabytesRewrittenPerCall * 0x100000L) : null;
            Storage.Objects.Rewrite rewrite = this.storage.objects().rewrite(req.source.getBucket(), req.source.getName(), req.target.getBucket(), req.target.getName(), req.overrideInfo ? req.target : null).setSourceGeneration(req.source.getGeneration()).setRewriteToken(token).setMaxBytesRewrittenPerCall(maxBytesRewrittenPerCall).setProjection(DEFAULT_PROJECTION).setIfSourceMetagenerationMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH.getLong(req.sourceOptions)).setIfSourceMetagenerationNotMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH.getLong(req.sourceOptions)).setIfSourceGenerationMatch(StorageRpc.Option.IF_SOURCE_GENERATION_MATCH.getLong(req.sourceOptions)).setIfSourceGenerationNotMatch(StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH.getLong(req.sourceOptions)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(req.targetOptions)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(req.targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(req.targetOptions)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(req.targetOptions)).setUserProject(userProject).setDestinationKmsKeyName(kmsKeyName);
            HttpHeaders requestHeaders = rewrite.getRequestHeaders();
            HttpStorageRpc.setEncryptionHeaders(requestHeaders, SOURCE_ENCRYPTION_KEY_PREFIX, req.sourceOptions);
            HttpStorageRpc.setEncryptionHeaders(requestHeaders, ENCRYPTION_KEY_PREFIX, req.targetOptions);
            RewriteResponse rewriteResponse = (RewriteResponse)rewrite.execute();
            return new StorageRpc.RewriteResponse(req, rewriteResponse.getResource(), rewriteResponse.getObjectSize(), rewriteResponse.getDone(), rewriteResponse.getRewriteToken(), rewriteResponse.getTotalBytesRewritten());
        }
        catch (IOException ex) {
            this.tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
    }

    @Override
    public BucketAccessControl getAcl(String bucket, String entity, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            BucketAccessControl bucketAccessControl = (BucketAccessControl)this.storage.bucketAccessControls().get(bucket, entity).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return bucketAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                BucketAccessControl bucketAccessControl = null;
                return bucketAccessControl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(String bucket, String entity, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.storage.bucketAccessControls().delete(bucket, entity).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public BucketAccessControl createAcl(BucketAccessControl acl, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            BucketAccessControl bucketAccessControl = (BucketAccessControl)this.storage.bucketAccessControls().insert(acl.getBucket(), acl).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return bucketAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public BucketAccessControl patchAcl(BucketAccessControl acl, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            BucketAccessControl bucketAccessControl = (BucketAccessControl)this.storage.bucketAccessControls().patch(acl.getBucket(), acl.getEntity(), acl).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return bucketAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public List<BucketAccessControl> listAcls(String bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_BUCKET_ACLS);
        Scope scope = this.tracer.withSpan(span);
        try {
            List list = ((BucketAccessControls)this.storage.bucketAccessControls().list(bucket).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute()).getItems();
            return list;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ObjectAccessControl getDefaultAcl(String bucket, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)this.storage.defaultObjectAccessControls().get(bucket, entity).execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                ObjectAccessControl objectAccessControl = null;
                return objectAccessControl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.storage.defaultObjectAccessControls().delete(bucket, entity).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ObjectAccessControl createDefaultAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)this.storage.defaultObjectAccessControls().insert(acl.getBucket(), acl).execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ObjectAccessControl patchDefaultAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)this.storage.defaultObjectAccessControls().patch(acl.getBucket(), acl.getEntity(), acl).execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public List<ObjectAccessControl> listDefaultAcls(String bucket) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_OBJECT_DEFAULT_ACLS);
        Scope scope = this.tracer.withSpan(span);
        try {
            List list = ((ObjectAccessControls)this.storage.defaultObjectAccessControls().list(bucket).execute()).getItems();
            return list;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ObjectAccessControl getAcl(String bucket, String object, Long generation, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)this.storage.objectAccessControls().get(bucket, object, entity).setGeneration(generation).execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                ObjectAccessControl objectAccessControl = null;
                return objectAccessControl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(String bucket, String object, Long generation, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.storage.objectAccessControls().delete(bucket, object, entity).setGeneration(generation).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ObjectAccessControl createAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)this.storage.objectAccessControls().insert(acl.getBucket(), acl.getObject(), acl).setGeneration(acl.getGeneration()).execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ObjectAccessControl patchAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)this.storage.objectAccessControls().patch(acl.getBucket(), acl.getObject(), acl.getEntity(), acl).setGeneration(acl.getGeneration()).execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public List<ObjectAccessControl> listAcls(String bucket, String object, Long generation) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_OBJECT_ACLS);
        Scope scope = this.tracer.withSpan(span);
        try {
            List list = ((ObjectAccessControls)this.storage.objectAccessControls().list(bucket, object).setGeneration(generation).execute()).getItems();
            return list;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Policy getIamPolicy(String bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_BUCKET_IAM_POLICY);
        Scope scope = this.tracer.withSpan(span);
        try {
            Policy policy = (Policy)this.storage.buckets().getIamPolicy(bucket).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return policy;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_SET_BUCKET_IAM_POLICY);
        Scope scope = this.tracer.withSpan(span);
        try {
            Policy policy2 = (Policy)this.storage.buckets().setIamPolicy(bucket, policy).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return policy2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public TestIamPermissionsResponse testIamPermissions(String bucket, List<String> permissions, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_TEST_BUCKET_IAM_PERMISSIONS);
        Scope scope = this.tracer.withSpan(span);
        try {
            TestIamPermissionsResponse testIamPermissionsResponse = (TestIamPermissionsResponse)this.storage.buckets().testIamPermissions(bucket, permissions).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).execute();
            return testIamPermissionsResponse;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public boolean deleteNotification(String bucket, String notification) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_NOTIFICATION);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.storage.notifications().delete(bucket, notification).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_NOTIFICATIONS);
        Scope scope = this.tracer.withSpan(span);
        try {
            List list = ((Notifications)this.storage.notifications().list(bucket).execute()).getItems();
            return list;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Notification createNotification(String bucket, Notification notification) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_NOTIFICATION);
        Scope scope = this.tracer.withSpan(span);
        try {
            Notification notification2 = (Notification)this.storage.notifications().insert(bucket, notification).execute();
            return notification2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_SERVICE_ACCOUNT);
        Scope scope = this.tracer.withSpan(span);
        try {
            ServiceAccount serviceAccount = (ServiceAccount)this.storage.projects().serviceAccount().get(projectId).execute();
            return serviceAccount;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private class DefaultRpcBatch
    implements RpcBatch {
        private static final int MAX_BATCH_SIZE = 100;
        private final Storage storage;
        private final LinkedList<BatchRequest> batches;
        private int currentBatchSize;

        private DefaultRpcBatch(Storage storage) {
            this.storage = storage;
            this.batches = new LinkedList();
            this.batches.add(storage.batch(HttpStorageRpc.this.batchRequestInitializer));
        }

        @Override
        public void addDelete(StorageObject storageObject, RpcBatch.Callback<Void> callback, Map<StorageRpc.Option, ?> options) {
            try {
                if (this.currentBatchSize == 100) {
                    this.batches.add(this.storage.batch());
                    this.currentBatchSize = 0;
                }
                HttpStorageRpc.this.deleteCall(storageObject, options).queue(this.batches.getLast(), HttpStorageRpc.toJsonCallback(callback));
                ++this.currentBatchSize;
            }
            catch (IOException ex) {
                throw HttpStorageRpc.translate(ex);
            }
        }

        @Override
        public void addPatch(StorageObject storageObject, RpcBatch.Callback<StorageObject> callback, Map<StorageRpc.Option, ?> options) {
            try {
                if (this.currentBatchSize == 100) {
                    this.batches.add(this.storage.batch());
                    this.currentBatchSize = 0;
                }
                HttpStorageRpc.this.patchCall(storageObject, options).queue(this.batches.getLast(), HttpStorageRpc.toJsonCallback(callback));
                ++this.currentBatchSize;
            }
            catch (IOException ex) {
                throw HttpStorageRpc.translate(ex);
            }
        }

        @Override
        public void addGet(StorageObject storageObject, RpcBatch.Callback<StorageObject> callback, Map<StorageRpc.Option, ?> options) {
            try {
                if (this.currentBatchSize == 100) {
                    this.batches.add(this.storage.batch());
                    this.currentBatchSize = 0;
                }
                HttpStorageRpc.this.getCall(storageObject, options).queue(this.batches.getLast(), HttpStorageRpc.toJsonCallback(callback));
                ++this.currentBatchSize;
            }
            catch (IOException ex) {
                throw HttpStorageRpc.translate(ex);
            }
        }

        @Override
        public void submit() {
            Span span = HttpStorageRpc.this.startSpan(HttpStorageRpcSpans.SPAN_NAME_BATCH_SUBMIT);
            Scope scope = HttpStorageRpc.this.tracer.withSpan(span);
            try {
                span.putAttribute("batch size", AttributeValue.longAttributeValue((long)this.batches.size()));
                for (BatchRequest batch : this.batches) {
                    span.addAnnotation("Execute batch request");
                    batch.setBatchUrl(new GenericUrl(String.format("%s/batch/storage/v1", HttpStorageRpc.this.options.getHost())));
                    batch.execute();
                }
            }
            catch (IOException ex) {
                span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
                throw HttpStorageRpc.translate(ex);
            }
            finally {
                scope.close();
                span.end();
            }
        }
    }
}

