/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Retrying;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class WriteFlushStrategy {
    private WriteFlushStrategy() {
    }

    static FlusherFactory fsyncEveryFlush(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg) {
        return (bucketName, committedTotalBytesCallback, onSuccessCallback) -> new FsyncEveryFlusher(write, deps, alg, bucketName, committedTotalBytesCallback, onSuccessCallback);
    }

    static FlusherFactory fsyncOnClose(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write) {
        return (bucketName, committedTotalBytesCallback, onSuccessCallback) -> new FsyncOnClose(write, bucketName, committedTotalBytesCallback, onSuccessCallback);
    }

    private static GrpcCallContext contextWithBucketName(String bucketName) {
        GrpcCallContext ret = GrpcCallContext.createDefault();
        if (bucketName != null && !bucketName.isEmpty()) {
            return ret.withExtraHeaders((Map)ImmutableMap.of((Object)"x-goog-request-params", (Object)ImmutableList.of((Object)String.format("bucket=%s", bucketName))));
        }
        return ret;
    }

    private static WriteObjectRequest possiblyPairDownRequest(WriteObjectRequest message, boolean firstMessageOfStream) {
        if (firstMessageOfStream && message.getWriteOffset() == 0L) {
            return message;
        }
        WriteObjectRequest.Builder b = message.toBuilder();
        if (!firstMessageOfStream) {
            b.clearUploadId();
        }
        if (message.getWriteOffset() > 0L) {
            b.clearWriteObjectSpec().clearObjectChecksums();
        }
        return b.build();
    }

    private static class Observer
    implements ApiStreamObserver<WriteObjectResponse> {
        private final LongConsumer sizeCallback;
        private final Consumer<WriteObjectResponse> completeCallback;
        private final SettableApiFuture<Void> invocationHandle;
        private volatile WriteObjectResponse last;

        private Observer(LongConsumer sizeCallback, Consumer<WriteObjectResponse> completeCallback) {
            this.sizeCallback = sizeCallback;
            this.completeCallback = completeCallback;
            this.invocationHandle = SettableApiFuture.create();
        }

        public void onNext(WriteObjectResponse value) {
            if (value.hasPersistedSize()) {
                this.sizeCallback.accept(value.getPersistedSize());
            } else if (value.hasResource()) {
                this.sizeCallback.accept(value.getResource().getSize());
            }
            this.last = value;
        }

        public void onError(Throwable t) {
            this.invocationHandle.setException(t);
        }

        public void onCompleted() {
            if (this.last != null && this.last.hasResource()) {
                this.completeCallback.accept(this.last);
            }
            this.invocationHandle.set(null);
        }

        private void await() {
            try {
                this.invocationHandle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static final class FsyncOnClose
    implements Flusher {
        private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
        private final String bucketName;
        private final Observer responseObserver;
        private volatile ApiStreamObserver<WriteObjectRequest> stream;
        private boolean first = true;

        private FsyncOnClose(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, String bucketName, LongConsumer sizeCallback, Consumer<WriteObjectResponse> completeCallback) {
            this.write = write;
            this.bucketName = bucketName;
            this.responseObserver = new Observer(sizeCallback, completeCallback);
        }

        @Override
        public void flush(@NonNull List<WriteObjectRequest> segments) {
            this.ensureOpen();
            for (WriteObjectRequest message : segments) {
                message = WriteFlushStrategy.possiblyPairDownRequest(message, this.first);
                this.stream.onNext((Object)message);
                this.first = false;
            }
        }

        @Override
        public void close(@Nullable WriteObjectRequest message) {
            this.ensureOpen();
            if (message != null) {
                message = WriteFlushStrategy.possiblyPairDownRequest(message, this.first);
                this.stream.onNext((Object)message);
            }
            this.stream.onCompleted();
            this.responseObserver.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureOpen() {
            if (this.stream == null) {
                FsyncOnClose fsyncOnClose = this;
                synchronized (fsyncOnClose) {
                    if (this.stream == null) {
                        GrpcCallContext internalContext = WriteFlushStrategy.contextWithBucketName(this.bucketName);
                        this.stream = this.write.withDefaultCallContext((ApiCallContext)internalContext).clientStreamingCall((ApiStreamObserver)this.responseObserver);
                    }
                }
            }
        }
    }

    private static final class FsyncEveryFlusher
    implements Flusher {
        private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
        private final Retrying.RetryingDependencies deps;
        private final ResultRetryAlgorithm<?> alg;
        private final String bucketName;
        private final LongConsumer sizeCallback;
        private final Consumer<WriteObjectResponse> completeCallback;

        private FsyncEveryFlusher(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, String bucketName, LongConsumer sizeCallback, Consumer<WriteObjectResponse> completeCallback) {
            this.write = write;
            this.deps = deps;
            this.alg = alg;
            this.bucketName = bucketName;
            this.sizeCallback = sizeCallback;
            this.completeCallback = completeCallback;
        }

        @Override
        public void flush(@NonNull List<WriteObjectRequest> segments) {
            Retrying.run(this.deps, this.alg, () -> {
                Observer observer = new Observer(this.sizeCallback, this.completeCallback);
                GrpcCallContext internalContext = WriteFlushStrategy.contextWithBucketName(this.bucketName);
                ApiStreamObserver write = this.write.withDefaultCallContext((ApiCallContext)internalContext).clientStreamingCall((ApiStreamObserver)observer);
                boolean first = true;
                for (WriteObjectRequest message : segments) {
                    message = WriteFlushStrategy.possiblyPairDownRequest(message, first);
                    write.onNext((Object)message);
                    first = false;
                }
                write.onCompleted();
                observer.await();
                return null;
            }, Conversions.Decoder.identity());
        }

        @Override
        public void close(@Nullable WriteObjectRequest req) {
            if (req != null) {
                this.flush((List<WriteObjectRequest>)ImmutableList.of((Object)req));
            }
        }
    }

    static interface Flusher {
        public void flush(@NonNull List<WriteObjectRequest> var1);

        public void close(@Nullable WriteObjectRequest var1);
    }

    @FunctionalInterface
    static interface FlusherFactory {
        public Flusher newFlusher(String var1, LongConsumer var2, Consumer<WriteObjectResponse> var3);
    }
}

