/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.Immutable;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
@Immutable
public final class DefaultBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = -6873740918589930633L;
    private final int chunkSize;

    @InternalApi
    DefaultBlobWriteSessionConfig(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @BetaApi
    public DefaultBlobWriteSessionConfig withChunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize >= 262144 ? 1 : 0) != 0, (String)"chunkSize must be >= %d", (int)262144);
        return new DefaultBlobWriteSessionConfig(chunkSize);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) {
        return new Factory(this.chunkSize);
    }

    @InternalApi
    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private static final Conversions.Decoder<WriteObjectResponse, BlobInfo> WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER = Conversions.grpc().blobInfo().compose(WriteObjectResponse::getResource);
        private final int chunkSize;

        private Factory(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            if (s instanceof GrpcStorageImpl) {
                return new DecoratedWritableByteChannelSession(new LazySession(new LazyWriteChannel(() -> {
                    GrpcStorageImpl grpc = (GrpcStorageImpl)s;
                    GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
                    WriteObjectRequest req = grpc.getWriteObjectRequest(info, opts);
                    ApiFuture<ResumableWrite> startResumableWrite = grpc.startResumableWrite(grpcCallContext, req);
                    return ResumableMedia.gapic().write().byteChannel((ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse>)grpc.storageClient.writeObjectCallable()).setHasher(Hasher.noop()).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(grpc.getOptions(), grpc.retryAlgorithmManager.idempotent()).buffered(BufferHandle.allocate(this.chunkSize)).setStartAsync(startResumableWrite).build();
                })), WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER);
            }
            throw new IllegalStateException("Unknown Storage implementation: " + s.getClass().getName());
        }
    }

    private static final class LazySession<R>
    implements WritableByteChannelSession<BufferedWritableByteChannelSession.BufferedWritableByteChannel, R> {
        private final LazyWriteChannel<R> lazy;

        private LazySession(LazyWriteChannel<R> lazy) {
            this.lazy = lazy;
        }

        @Override
        public ApiFuture<BufferedWritableByteChannelSession.BufferedWritableByteChannel> openAsync() {
            return this.lazy.getSession().openAsync();
        }

        @Override
        public ApiFuture<R> getResult() {
            return this.lazy.getSession().getResult();
        }
    }

    private static final class DecoratedWritableByteChannelSession<WBC extends WritableByteChannel, T>
    implements WritableByteChannelSession<WBC, BlobInfo> {
        private final WritableByteChannelSession<WBC, T> delegate;
        private final Conversions.Decoder<T, BlobInfo> decoder;

        private DecoratedWritableByteChannelSession(WritableByteChannelSession<WBC, T> delegate, Conversions.Decoder<T, BlobInfo> decoder) {
            this.delegate = delegate;
            this.decoder = decoder;
        }

        @Override
        public WBC open() {
            try {
                return WritableByteChannelSession.super.open();
            }
            catch (Exception e) {
                throw StorageException.coalesce(e);
            }
        }

        @Override
        public ApiFuture<WBC> openAsync() {
            return this.delegate.openAsync();
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return ApiFutures.transform(this.delegate.getResult(), this.decoder::decode, (Executor)MoreExecutors.directExecutor());
        }
    }
}

