/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.ChannelSession;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.DefaultBufferedWritableByteChannel;
import com.google.cloud.storage.GapicBidiUnbufferedWritableByteChannel;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.WriteFlushStrategy;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

final class GapicBidiWritableByteChannelSessionBuilder {
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private Hasher hasher;
    private ByteStringStrategy byteStringStrategy;

    GapicBidiWritableByteChannelSessionBuilder(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write) {
        this.write = write;
        this.hasher = Hasher.noop();
        this.byteStringStrategy = ByteStringStrategy.copy();
    }

    GapicBidiWritableByteChannelSessionBuilder setHasher(Hasher hasher) {
        this.hasher = Objects.requireNonNull(hasher, "hasher must be non null");
        return this;
    }

    GapicBidiWritableByteChannelSessionBuilder setByteStringStrategy(ByteStringStrategy byteStringStrategy) {
        this.byteStringStrategy = Objects.requireNonNull(byteStringStrategy, "byteStringStrategy must be non null");
        return this;
    }

    private <StartT, RequestFactoryT extends BidiWriteCtx.BidiWriteObjectRequestBuilderFactory> BiFunction<StartT, SettableApiFuture<BidiWriteObjectResponse>, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel> bindFunction(WriteFlushStrategy.BidiFlusherFactory flusherFactory, Function<StartT, RequestFactoryT> f) {
        ByteStringStrategy boundStrategy = this.byteStringStrategy;
        Hasher boundHasher = this.hasher;
        return (start, resultFuture) -> new GapicBidiUnbufferedWritableByteChannel<BidiWriteCtx.BidiWriteObjectRequestBuilderFactory>((SettableApiFuture<BidiWriteObjectResponse>)resultFuture, new ChunkSegmenter(boundHasher, boundStrategy, 0x200000), (BidiWriteCtx.BidiWriteObjectRequestBuilderFactory)f.apply(start), flusherFactory);
    }

    ResumableUploadBuilder resumable() {
        return new ResumableUploadBuilder();
    }

    final class ResumableUploadBuilder {
        private Retrying.RetryingDependencies deps = Retrying.RetryingDependencies.attemptOnce();
        private ResultRetryAlgorithm<?> alg = Retrying.neverRetry();

        ResumableUploadBuilder() {
        }

        ResumableUploadBuilder withRetryConfig(Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg) {
            this.deps = Objects.requireNonNull(deps, "deps must be non null");
            this.alg = Objects.requireNonNull(alg, "alg must be non null");
            return this;
        }

        BufferedResumableUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedResumableUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedResumableUploadBuilder(bufferHandle);
        }

        final class BufferedResumableUploadBuilder {
            private final BufferHandle bufferHandle;
            private ApiFuture<BidiResumableWrite> start;

            BufferedResumableUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedResumableUploadBuilder setStartAsync(ApiFuture<BidiResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<BidiWriteObjectResponse> build() {
                return new ChannelSession.BufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), GapicBidiWritableByteChannelSessionBuilder.this.bindFunction(WriteFlushStrategy.defaultBidiFlusher((BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse>)GapicBidiWritableByteChannelSessionBuilder.this.write, ResumableUploadBuilder.this.deps, ResumableUploadBuilder.this.alg, Retrying::newCallContext), BidiResumableWrite::identity).andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }
}

