/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.protobuf.MessageOrBuilder;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BidiResumableWrite
implements BidiWriteCtx.BidiWriteObjectRequestBuilderFactory {
    private final StartResumableWriteRequest req;
    private final StartResumableWriteResponse res;
    private final BidiWriteObjectRequest writeRequest;

    public BidiResumableWrite(StartResumableWriteRequest req, StartResumableWriteResponse res, Function<String, BidiWriteObjectRequest> f) {
        this.req = req;
        this.res = res;
        this.writeRequest = f.apply(res.getUploadId());
    }

    public StartResumableWriteRequest getReq() {
        return this.req;
    }

    public StartResumableWriteResponse getRes() {
        return this.res;
    }

    @Override
    public BidiWriteObjectRequest.Builder newBuilder() {
        return this.writeRequest.toBuilder().clearWriteObjectSpec();
    }

    @Override
    public @Nullable String bucketName() {
        if (this.req.hasWriteObjectSpec() && this.req.getWriteObjectSpec().hasResource()) {
            return this.req.getWriteObjectSpec().getResource().getBucket();
        }
        return null;
    }

    public String toString() {
        return "BidiResumableWrite{req=" + StorageV2ProtoUtils.fmtProto((MessageOrBuilder)this.req) + ", res=" + StorageV2ProtoUtils.fmtProto((MessageOrBuilder)this.res) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResumableWrite)) {
            return false;
        }
        ResumableWrite resumableWrite = (ResumableWrite)o;
        return Objects.equals(this.req, resumableWrite.getReq()) && Objects.equals(this.res, resumableWrite.getRes());
    }

    public int hashCode() {
        return Objects.hash(this.req, this.res);
    }

    static BidiResumableWrite identity(BidiResumableWrite w) {
        return w;
    }
}

