/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.CreateTenantRequest;
import com.google.cloud.talent.v4beta1.DeleteTenantRequest;
import com.google.cloud.talent.v4beta1.GetTenantRequest;
import com.google.cloud.talent.v4beta1.ListTenantsRequest;
import com.google.cloud.talent.v4beta1.ListTenantsResponse;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.Tenant;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.TenantServiceSettings;
import com.google.cloud.talent.v4beta1.UpdateTenantRequest;
import com.google.cloud.talent.v4beta1.stub.TenantServiceStub;
import com.google.cloud.talent.v4beta1.stub.TenantServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TenantServiceClient
implements BackgroundResource {
    private final TenantServiceSettings settings;
    private final TenantServiceStub stub;

    public static final TenantServiceClient create() throws IOException {
        return TenantServiceClient.create(TenantServiceSettings.newBuilder().build());
    }

    public static final TenantServiceClient create(TenantServiceSettings settings) throws IOException {
        return new TenantServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TenantServiceClient create(TenantServiceStub stub) {
        return new TenantServiceClient(stub);
    }

    protected TenantServiceClient(TenantServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TenantServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TenantServiceClient(TenantServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TenantServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TenantServiceStub getStub() {
        return this.stub;
    }

    public final void deleteTenant(TenantName name) {
        DeleteTenantRequest request = DeleteTenantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTenant(request);
    }

    public final void deleteTenant(String name) {
        DeleteTenantRequest request = DeleteTenantRequest.newBuilder().setName(name).build();
        this.deleteTenant(request);
    }

    public final void deleteTenant(DeleteTenantRequest request) {
        this.deleteTenantCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTenantRequest, Empty> deleteTenantCallable() {
        return this.stub.deleteTenantCallable();
    }

    public final Tenant createTenant(ProjectName parent, Tenant tenant) {
        CreateTenantRequest request = CreateTenantRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTenant(tenant).build();
        return this.createTenant(request);
    }

    public final Tenant createTenant(String parent, Tenant tenant) {
        CreateTenantRequest request = CreateTenantRequest.newBuilder().setParent(parent).setTenant(tenant).build();
        return this.createTenant(request);
    }

    public final Tenant createTenant(CreateTenantRequest request) {
        return (Tenant)this.createTenantCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTenantRequest, Tenant> createTenantCallable() {
        return this.stub.createTenantCallable();
    }

    public final Tenant getTenant(TenantName name) {
        GetTenantRequest request = GetTenantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTenant(request);
    }

    public final Tenant getTenant(String name) {
        GetTenantRequest request = GetTenantRequest.newBuilder().setName(name).build();
        return this.getTenant(request);
    }

    public final Tenant getTenant(GetTenantRequest request) {
        return (Tenant)this.getTenantCallable().call((Object)request);
    }

    public final UnaryCallable<GetTenantRequest, Tenant> getTenantCallable() {
        return this.stub.getTenantCallable();
    }

    public final Tenant updateTenant(Tenant tenant) {
        UpdateTenantRequest request = UpdateTenantRequest.newBuilder().setTenant(tenant).build();
        return this.updateTenant(request);
    }

    public final Tenant updateTenant(UpdateTenantRequest request) {
        return (Tenant)this.updateTenantCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTenantRequest, Tenant> updateTenantCallable() {
        return this.stub.updateTenantCallable();
    }

    public final ListTenantsPagedResponse listTenants(ProjectName parent) {
        ListTenantsRequest request = ListTenantsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTenants(request);
    }

    public final ListTenantsPagedResponse listTenants(String parent) {
        ListTenantsRequest request = ListTenantsRequest.newBuilder().setParent(parent).build();
        return this.listTenants(request);
    }

    public final ListTenantsPagedResponse listTenants(ListTenantsRequest request) {
        return (ListTenantsPagedResponse)((Object)this.listTenantsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTenantsRequest, ListTenantsPagedResponse> listTenantsPagedCallable() {
        return this.stub.listTenantsPagedCallable();
    }

    public final UnaryCallable<ListTenantsRequest, ListTenantsResponse> listTenantsCallable() {
        return this.stub.listTenantsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTenantsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTenantsRequest, ListTenantsResponse, Tenant, ListTenantsPage, ListTenantsFixedSizeCollection> {
        private ListTenantsFixedSizeCollection(List<ListTenantsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTenantsFixedSizeCollection createEmptyCollection() {
            return new ListTenantsFixedSizeCollection(null, 0);
        }

        protected ListTenantsFixedSizeCollection createCollection(List<ListTenantsPage> pages, int collectionSize) {
            return new ListTenantsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTenantsPage
    extends AbstractPage<ListTenantsRequest, ListTenantsResponse, Tenant, ListTenantsPage> {
        private ListTenantsPage(PageContext<ListTenantsRequest, ListTenantsResponse, Tenant> context, ListTenantsResponse response) {
            super(context, (Object)response);
        }

        private static ListTenantsPage createEmptyPage() {
            return new ListTenantsPage(null, null);
        }

        protected ListTenantsPage createPage(PageContext<ListTenantsRequest, ListTenantsResponse, Tenant> context, ListTenantsResponse response) {
            return new ListTenantsPage(context, response);
        }

        public ApiFuture<ListTenantsPage> createPageAsync(PageContext<ListTenantsRequest, ListTenantsResponse, Tenant> context, ApiFuture<ListTenantsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTenantsPagedResponse
    extends AbstractPagedListResponse<ListTenantsRequest, ListTenantsResponse, Tenant, ListTenantsPage, ListTenantsFixedSizeCollection> {
        public static ApiFuture<ListTenantsPagedResponse> createAsync(PageContext<ListTenantsRequest, ListTenantsResponse, Tenant> context, ApiFuture<ListTenantsResponse> futureResponse) {
            ApiFuture<ListTenantsPage> futurePage = ListTenantsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTenantsPage, ListTenantsPagedResponse>(){

                public ListTenantsPagedResponse apply(ListTenantsPage input) {
                    return new ListTenantsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTenantsPagedResponse(ListTenantsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTenantsFixedSizeCollection.createEmptyCollection());
        }
    }
}

