/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4beta1.CreateJobRequest;
import com.google.cloud.talent.v4beta1.DeleteJobRequest;
import com.google.cloud.talent.v4beta1.GetJobRequest;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobServiceClient;
import com.google.cloud.talent.v4beta1.ListJobsRequest;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.UpdateJobRequest;
import com.google.cloud.talent.v4beta1.stub.GrpcJobServiceStub;
import com.google.cloud.talent.v4beta1.stub.JobServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class JobServiceStubSettings
extends StubSettings<JobServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/jobs").build();
    private final UnaryCallSettings<CreateJobRequest, Job> createJobSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings;
    private final UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<BatchDeleteJobsRequest, Empty> batchDeleteJobsSettings;
    private final PagedCallSettings<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsPagedResponse> searchJobsSettings;
    private final PagedCallSettings<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() != null ? payload.getJobsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> SEARCH_JOBS_PAGE_STR_DESC = new PagedListDescriptor<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob>(){

        public String emptyToken() {
            return "";
        }

        public SearchJobsRequest injectToken(SearchJobsRequest payload, String token) {
            return SearchJobsRequest.newBuilder((SearchJobsRequest)payload).setPageToken(token).build();
        }

        public SearchJobsRequest injectPageSize(SearchJobsRequest payload, int pageSize) {
            return SearchJobsRequest.newBuilder((SearchJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchJobsResponse.MatchingJob> extractResources(SearchJobsResponse payload) {
            return payload.getMatchingJobsList() != null ? payload.getMatchingJobsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> SEARCH_JOBS_FOR_ALERT_PAGE_STR_DESC = new PagedListDescriptor<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob>(){

        public String emptyToken() {
            return "";
        }

        public SearchJobsRequest injectToken(SearchJobsRequest payload, String token) {
            return SearchJobsRequest.newBuilder((SearchJobsRequest)payload).setPageToken(token).build();
        }

        public SearchJobsRequest injectPageSize(SearchJobsRequest payload, int pageSize) {
            return SearchJobsRequest.newBuilder((SearchJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchJobsResponse.MatchingJob> extractResources(SearchJobsResponse payload) {
            return payload.getMatchingJobsList() != null ? payload.getMatchingJobsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse>(){

        public ApiFuture<JobServiceClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobServiceClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsPagedResponse> SEARCH_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsPagedResponse>(){

        public ApiFuture<JobServiceClient.SearchJobsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchJobsRequest, SearchJobsResponse> callable, SearchJobsRequest request, ApiCallContext context, ApiFuture<SearchJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobServiceClient.SearchJobsPagedResponse.createAsync((PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsForAlertPagedResponse> SEARCH_JOBS_FOR_ALERT_PAGE_STR_FACT = new PagedListResponseFactory<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsForAlertPagedResponse>(){

        public ApiFuture<JobServiceClient.SearchJobsForAlertPagedResponse> getFuturePagedResponse(UnaryCallable<SearchJobsRequest, SearchJobsResponse> callable, SearchJobsRequest request, ApiCallContext context, ApiFuture<SearchJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_JOBS_FOR_ALERT_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobServiceClient.SearchJobsForAlertPagedResponse.createAsync((PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateJobRequest, Job> createJobSettings() {
        return this.createJobSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings() {
        return this.updateJobSettings;
    }

    public UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings() {
        return this.deleteJobSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<BatchDeleteJobsRequest, Empty> batchDeleteJobsSettings() {
        return this.batchDeleteJobsSettings;
    }

    public PagedCallSettings<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsPagedResponse> searchJobsSettings() {
        return this.searchJobsSettings;
    }

    public PagedCallSettings<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertSettings() {
        return this.searchJobsForAlertSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public JobServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcJobServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "jobs.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return JobServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(JobServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected JobServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createJobSettings = settingsBuilder.createJobSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.updateJobSettings = settingsBuilder.updateJobSettings().build();
        this.deleteJobSettings = settingsBuilder.deleteJobSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.batchDeleteJobsSettings = settingsBuilder.batchDeleteJobsSettings().build();
        this.searchJobsSettings = settingsBuilder.searchJobsSettings().build();
        this.searchJobsForAlertSettings = settingsBuilder.searchJobsForAlertSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<JobServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings;
        private final UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<BatchDeleteJobsRequest, Empty> batchDeleteJobsSettings;
        private final PagedCallSettings.Builder<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsPagedResponse> searchJobsSettings;
        private final PagedCallSettings.Builder<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.batchDeleteJobsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_JOBS_PAGE_STR_FACT);
            this.searchJobsForAlertSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_JOBS_FOR_ALERT_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.getJobSettings, this.updateJobSettings, this.deleteJobSettings, this.listJobsSettings, this.batchDeleteJobsSettings, this.searchJobsSettings, this.searchJobsForAlertSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(JobServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)JobServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)JobServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(JobServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchDeleteJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.searchJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.searchJobsForAlertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(JobServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createJobSettings = settings.createJobSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.updateJobSettings = settings.updateJobSettings.toBuilder();
            this.deleteJobSettings = settings.deleteJobSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.batchDeleteJobsSettings = settings.batchDeleteJobsSettings.toBuilder();
            this.searchJobsSettings = settings.searchJobsSettings.toBuilder();
            this.searchJobsForAlertSettings = settings.searchJobsForAlertSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.getJobSettings, this.updateJobSettings, this.deleteJobSettings, this.listJobsSettings, this.batchDeleteJobsSettings, this.searchJobsSettings, this.searchJobsForAlertSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings() {
            return this.createJobSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings() {
            return this.updateJobSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings() {
            return this.deleteJobSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteJobsRequest, Empty> batchDeleteJobsSettings() {
            return this.batchDeleteJobsSettings;
        }

        public PagedCallSettings.Builder<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsPagedResponse> searchJobsSettings() {
            return this.searchJobsSettings;
        }

        public PagedCallSettings.Builder<SearchJobsRequest, SearchJobsResponse, JobServiceClient.SearchJobsForAlertPagedResponse> searchJobsForAlertSettings() {
            return this.searchJobsForAlertSettings;
        }

        public JobServiceStubSettings build() throws IOException {
            return new JobServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

