/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.texttospeech.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.texttospeech.v1beta1.ListVoicesRequest;
import com.google.cloud.texttospeech.v1beta1.ListVoicesResponse;
import com.google.cloud.texttospeech.v1beta1.StreamingSynthesizeRequest;
import com.google.cloud.texttospeech.v1beta1.StreamingSynthesizeResponse;
import com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest;
import com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Base stub class for the TextToSpeech service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@BetaApi
@Generated("by gapic-generator-java")
public abstract class TextToSpeechStub implements BackgroundResource {

  public UnaryCallable<ListVoicesRequest, ListVoicesResponse> listVoicesCallable() {
    throw new UnsupportedOperationException("Not implemented: listVoicesCallable()");
  }

  public UnaryCallable<SynthesizeSpeechRequest, SynthesizeSpeechResponse>
      synthesizeSpeechCallable() {
    throw new UnsupportedOperationException("Not implemented: synthesizeSpeechCallable()");
  }

  public BidiStreamingCallable<StreamingSynthesizeRequest, StreamingSynthesizeResponse>
      streamingSynthesizeCallable() {
    throw new UnsupportedOperationException("Not implemented: streamingSynthesizeCallable()");
  }

  @Override
  public abstract void close();
}
