/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.spi.v1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.trace.spi.v1.PagedResponseWrappers;
import com.google.cloud.trace.spi.v1.TraceServiceSettings;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.Traces;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class TraceServiceClient
implements AutoCloseable {
    private final TraceServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable;
    private final UnaryCallable<GetTraceRequest, Trace> getTraceCallable;
    private final UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable;
    private final UnaryCallable<ListTracesRequest, PagedResponseWrappers.ListTracesPagedResponse> listTracesPagedCallable;

    public static final TraceServiceClient create() throws IOException {
        return TraceServiceClient.create(TraceServiceSettings.defaultBuilder().build());
    }

    public static final TraceServiceClient create(TraceServiceSettings settings) throws IOException {
        return new TraceServiceClient(settings);
    }

    protected TraceServiceClient(TraceServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.patchTracesCallable = UnaryCallable.create(settings.patchTracesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.getTraceCallable = UnaryCallable.create(settings.getTraceSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTracesCallable = UnaryCallable.create(settings.listTracesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTracesPagedCallable = UnaryCallable.createPagedVariant(settings.listTracesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    TraceServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    TraceServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final TraceServiceSettings getSettings() {
        return this.settings;
    }

    public final void patchTraces(String projectId, Traces traces) {
        PatchTracesRequest request = PatchTracesRequest.newBuilder().setProjectId(projectId).setTraces(traces).build();
        this.patchTraces(request);
    }

    public final void patchTraces(PatchTracesRequest request) {
        this.patchTracesCallable().call((Object)request);
    }

    public final UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable() {
        return this.patchTracesCallable;
    }

    public final Trace getTrace(String projectId, String traceId) {
        GetTraceRequest request = GetTraceRequest.newBuilder().setProjectId(projectId).setTraceId(traceId).build();
        return this.getTrace(request);
    }

    private final Trace getTrace(GetTraceRequest request) {
        return (Trace)this.getTraceCallable().call((Object)request);
    }

    public final UnaryCallable<GetTraceRequest, Trace> getTraceCallable() {
        return this.getTraceCallable;
    }

    public final PagedResponseWrappers.ListTracesPagedResponse listTraces(String projectId) {
        ListTracesRequest request = ListTracesRequest.newBuilder().setProjectId(projectId).build();
        return this.listTraces(request);
    }

    public final PagedResponseWrappers.ListTracesPagedResponse listTraces(ListTracesRequest request) {
        return (PagedResponseWrappers.ListTracesPagedResponse)((Object)this.listTracesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTracesRequest, PagedResponseWrappers.ListTracesPagedResponse> listTracesPagedCallable() {
        return this.listTracesPagedCallable;
    }

    public final UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable() {
        return this.listTracesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

