/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai.preview;

import com.google.cloud.vertexai.api.Blob;
import com.google.cloud.vertexai.api.FileData;
import com.google.cloud.vertexai.api.Part;
import com.google.protobuf.ByteString;
import java.net.URI;
import java.net.URL;

public class PartMaker {
    private PartMaker() {
    }

    public static Part fromMimeTypeAndData(String mimeType, Object partData) {
        Part part;
        if (partData instanceof byte[]) {
            byte[] bytes = (byte[])partData;
            ByteString byteData = ByteString.copyFrom((byte[])bytes);
            part = Part.newBuilder().setInlineData(Blob.newBuilder().setMimeType(mimeType).setData(byteData)).build();
        } else if (partData instanceof String) {
            String url = (String)partData;
            part = Part.newBuilder().setFileData(FileData.newBuilder().setMimeType(mimeType).setFileUri(url)).build();
        } else if (partData instanceof URL) {
            URL url = (URL)partData;
            part = Part.newBuilder().setFileData(FileData.newBuilder().setMimeType(mimeType).setFileUri(partData.toString())).build();
        } else if (partData instanceof URI) {
            URI uri = (URI)partData;
            part = Part.newBuilder().setFileData(FileData.newBuilder().setMimeType(mimeType).setFileUri(uri.toString())).build();
        } else if (partData instanceof ByteString) {
            ByteString byteData = (ByteString)partData;
            part = Part.newBuilder().setInlineData(Blob.newBuilder().setMimeType(mimeType).setData(byteData)).build();
        } else {
            throw new IllegalArgumentException("The second element of the input List can only be one of the following format: byte[], String, URL, URI, ByteString");
        }
        return part;
    }
}

