/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.api.core.BetaApi;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Tool;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class GenerateContentConfig {
    private final GenerationConfig generationConfig;
    private final ImmutableList<SafetySetting> safetySettings;
    private final ImmutableList<Tool> tools;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GenerateContentConfig(Builder builder) {
        this.generationConfig = builder.generationConfig != null ? builder.generationConfig : null;
        this.safetySettings = builder.safetySettings != null ? builder.safetySettings : ImmutableList.of();
        this.tools = builder.tools != null ? builder.tools : ImmutableList.of();
    }

    @BetaApi
    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    @BetaApi(value="safetySettings is a preview feature.")
    public ImmutableList<SafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    @BetaApi(value="tools is a preview feature.")
    public ImmutableList<Tool> getTools() {
        return this.tools;
    }

    public static class Builder {
        private GenerationConfig generationConfig;
        private ImmutableList<SafetySetting> safetySettings;
        private ImmutableList<Tool> tools;

        private Builder() {
        }

        public GenerateContentConfig build() {
            return new GenerateContentConfig(this);
        }

        @BetaApi
        public Builder setGenerationConfig(GenerationConfig generationConfig) {
            this.generationConfig = generationConfig;
            return this;
        }

        @BetaApi
        public Builder setSafetySettings(List<SafetySetting> safetySettings) {
            this.safetySettings = ImmutableList.copyOf(safetySettings);
            return this;
        }

        @BetaApi
        public Builder setTools(List<Tool> tools) {
            this.tools = ImmutableList.copyOf(tools);
            return this;
        }
    }
}

