/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.webrisk.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.webrisk.v1.WebRiskServiceSettings;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStub;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStubSettings;
import com.google.protobuf.ByteString;
import com.google.webrisk.v1.ComputeThreatListDiffRequest;
import com.google.webrisk.v1.ComputeThreatListDiffResponse;
import com.google.webrisk.v1.CreateSubmissionRequest;
import com.google.webrisk.v1.ProjectName;
import com.google.webrisk.v1.SearchHashesRequest;
import com.google.webrisk.v1.SearchHashesResponse;
import com.google.webrisk.v1.SearchUrisRequest;
import com.google.webrisk.v1.SearchUrisResponse;
import com.google.webrisk.v1.Submission;
import com.google.webrisk.v1.ThreatType;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WebRiskServiceClient
implements BackgroundResource {
    private final WebRiskServiceSettings settings;
    private final WebRiskServiceStub stub;

    public static final WebRiskServiceClient create() throws IOException {
        return WebRiskServiceClient.create(WebRiskServiceSettings.newBuilder().build());
    }

    public static final WebRiskServiceClient create(WebRiskServiceSettings settings) throws IOException {
        return new WebRiskServiceClient(settings);
    }

    public static final WebRiskServiceClient create(WebRiskServiceStub stub) {
        return new WebRiskServiceClient(stub);
    }

    protected WebRiskServiceClient(WebRiskServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WebRiskServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected WebRiskServiceClient(WebRiskServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final WebRiskServiceSettings getSettings() {
        return this.settings;
    }

    public WebRiskServiceStub getStub() {
        return this.stub;
    }

    public final ComputeThreatListDiffResponse computeThreatListDiff(ThreatType threatType, ByteString versionToken, ComputeThreatListDiffRequest.Constraints constraints) {
        ComputeThreatListDiffRequest request = ComputeThreatListDiffRequest.newBuilder().setThreatType(threatType).setVersionToken(versionToken).setConstraints(constraints).build();
        return this.computeThreatListDiff(request);
    }

    public final ComputeThreatListDiffResponse computeThreatListDiff(ComputeThreatListDiffRequest request) {
        return (ComputeThreatListDiffResponse)this.computeThreatListDiffCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffCallable() {
        return this.stub.computeThreatListDiffCallable();
    }

    public final SearchUrisResponse searchUris(String uri, List<ThreatType> threatTypes) {
        SearchUrisRequest request = SearchUrisRequest.newBuilder().setUri(uri).addAllThreatTypes(threatTypes).build();
        return this.searchUris(request);
    }

    public final SearchUrisResponse searchUris(SearchUrisRequest request) {
        return (SearchUrisResponse)this.searchUrisCallable().call((Object)request);
    }

    public final UnaryCallable<SearchUrisRequest, SearchUrisResponse> searchUrisCallable() {
        return this.stub.searchUrisCallable();
    }

    public final SearchHashesResponse searchHashes(ByteString hashPrefix, List<ThreatType> threatTypes) {
        SearchHashesRequest request = SearchHashesRequest.newBuilder().setHashPrefix(hashPrefix).addAllThreatTypes(threatTypes).build();
        return this.searchHashes(request);
    }

    public final SearchHashesResponse searchHashes(SearchHashesRequest request) {
        return (SearchHashesResponse)this.searchHashesCallable().call((Object)request);
    }

    public final UnaryCallable<SearchHashesRequest, SearchHashesResponse> searchHashesCallable() {
        return this.stub.searchHashesCallable();
    }

    public final Submission createSubmission(ProjectName parent, Submission submission) {
        CreateSubmissionRequest request = CreateSubmissionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSubmission(submission).build();
        return this.createSubmission(request);
    }

    public final Submission createSubmission(String parent, Submission submission) {
        CreateSubmissionRequest request = CreateSubmissionRequest.newBuilder().setParent(parent).setSubmission(submission).build();
        return this.createSubmission(request);
    }

    public final Submission createSubmission(CreateSubmissionRequest request) {
        return (Submission)this.createSubmissionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSubmissionRequest, Submission> createSubmissionCallable() {
        return this.stub.createSubmissionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

