/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.executions.v1.CancelExecutionRequest;
import com.google.cloud.workflows.executions.v1.CreateExecutionRequest;
import com.google.cloud.workflows.executions.v1.Execution;
import com.google.cloud.workflows.executions.v1.ExecutionsClient;
import com.google.cloud.workflows.executions.v1.GetExecutionRequest;
import com.google.cloud.workflows.executions.v1.ListExecutionsRequest;
import com.google.cloud.workflows.executions.v1.ListExecutionsResponse;
import com.google.cloud.workflows.executions.v1.stub.ExecutionsStub;
import com.google.cloud.workflows.executions.v1.stub.ExecutionsStubSettings;
import com.google.cloud.workflows.executions.v1.stub.HttpJsonExecutionsCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonExecutionsStub
extends ExecutionsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListExecutionsRequest, ListExecutionsResponse> listExecutionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.executions.v1.Executions/ListExecutions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workflows/*}/executions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListExecutionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateExecutionRequest, Execution> createExecutionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.executions.v1.Executions/CreateExecution").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workflows/*}/executions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("execution", (Message)request.getExecution(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Execution.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetExecutionRequest, Execution> getExecutionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.executions.v1.Executions/GetExecution").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workflows/*/executions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Execution.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CancelExecutionRequest, Execution> cancelExecutionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workflows.executions.v1.Executions/CancelExecution").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workflows/*/executions/*}:cancel", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Execution.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable;
    private final UnaryCallable<ListExecutionsRequest, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsPagedCallable;
    private final UnaryCallable<CreateExecutionRequest, Execution> createExecutionCallable;
    private final UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable;
    private final UnaryCallable<CancelExecutionRequest, Execution> cancelExecutionCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonExecutionsStub create(ExecutionsStubSettings settings) throws IOException {
        return new HttpJsonExecutionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonExecutionsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonExecutionsStub(ExecutionsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonExecutionsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonExecutionsStub(ExecutionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonExecutionsStub(ExecutionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonExecutionsCallableFactory());
    }

    protected HttpJsonExecutionsStub(ExecutionsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listExecutionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listExecutionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createExecutionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createExecutionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getExecutionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getExecutionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings cancelExecutionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(cancelExecutionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listExecutionsCallable = callableFactory.createUnaryCallable(listExecutionsTransportSettings, settings.listExecutionsSettings(), clientContext);
        this.listExecutionsPagedCallable = callableFactory.createPagedCallable(listExecutionsTransportSettings, settings.listExecutionsSettings(), clientContext);
        this.createExecutionCallable = callableFactory.createUnaryCallable(createExecutionTransportSettings, settings.createExecutionSettings(), clientContext);
        this.getExecutionCallable = callableFactory.createUnaryCallable(getExecutionTransportSettings, settings.getExecutionSettings(), clientContext);
        this.cancelExecutionCallable = callableFactory.createUnaryCallable(cancelExecutionTransportSettings, settings.cancelExecutionSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listExecutionsMethodDescriptor);
        methodDescriptors.add(createExecutionMethodDescriptor);
        methodDescriptors.add(getExecutionMethodDescriptor);
        methodDescriptors.add(cancelExecutionMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable() {
        return this.listExecutionsCallable;
    }

    @Override
    public UnaryCallable<ListExecutionsRequest, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsPagedCallable() {
        return this.listExecutionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateExecutionRequest, Execution> createExecutionCallable() {
        return this.createExecutionCallable;
    }

    @Override
    public UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable() {
        return this.getExecutionCallable;
    }

    @Override
    public UnaryCallable<CancelExecutionRequest, Execution> cancelExecutionCallable() {
        return this.cancelExecutionCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

