/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.executions.v1beta.CancelExecutionRequest;
import com.google.cloud.workflows.executions.v1beta.CreateExecutionRequest;
import com.google.cloud.workflows.executions.v1beta.Execution;
import com.google.cloud.workflows.executions.v1beta.ExecutionName;
import com.google.cloud.workflows.executions.v1beta.ExecutionsSettings;
import com.google.cloud.workflows.executions.v1beta.GetExecutionRequest;
import com.google.cloud.workflows.executions.v1beta.ListExecutionsRequest;
import com.google.cloud.workflows.executions.v1beta.ListExecutionsResponse;
import com.google.cloud.workflows.executions.v1beta.WorkflowName;
import com.google.cloud.workflows.executions.v1beta.stub.ExecutionsStub;
import com.google.cloud.workflows.executions.v1beta.stub.ExecutionsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExecutionsClient
implements BackgroundResource {
    private final ExecutionsSettings settings;
    private final ExecutionsStub stub;

    public static final ExecutionsClient create() throws IOException {
        return ExecutionsClient.create(ExecutionsSettings.newBuilder().build());
    }

    public static final ExecutionsClient create(ExecutionsSettings settings) throws IOException {
        return new ExecutionsClient(settings);
    }

    public static final ExecutionsClient create(ExecutionsStub stub) {
        return new ExecutionsClient(stub);
    }

    protected ExecutionsClient(ExecutionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExecutionsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ExecutionsClient(ExecutionsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExecutionsSettings getSettings() {
        return this.settings;
    }

    public ExecutionsStub getStub() {
        return this.stub;
    }

    public final ListExecutionsPagedResponse listExecutions(WorkflowName parent) {
        ListExecutionsRequest request = ListExecutionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExecutions(request);
    }

    public final ListExecutionsPagedResponse listExecutions(String parent) {
        ListExecutionsRequest request = ListExecutionsRequest.newBuilder().setParent(parent).build();
        return this.listExecutions(request);
    }

    public final ListExecutionsPagedResponse listExecutions(ListExecutionsRequest request) {
        return (ListExecutionsPagedResponse)((Object)this.listExecutionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExecutionsRequest, ListExecutionsPagedResponse> listExecutionsPagedCallable() {
        return this.stub.listExecutionsPagedCallable();
    }

    public final UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable() {
        return this.stub.listExecutionsCallable();
    }

    public final Execution createExecution(WorkflowName parent, Execution execution) {
        CreateExecutionRequest request = CreateExecutionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExecution(execution).build();
        return this.createExecution(request);
    }

    public final Execution createExecution(String parent, Execution execution) {
        CreateExecutionRequest request = CreateExecutionRequest.newBuilder().setParent(parent).setExecution(execution).build();
        return this.createExecution(request);
    }

    public final Execution createExecution(CreateExecutionRequest request) {
        return (Execution)this.createExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateExecutionRequest, Execution> createExecutionCallable() {
        return this.stub.createExecutionCallable();
    }

    public final Execution getExecution(ExecutionName name) {
        GetExecutionRequest request = GetExecutionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExecution(request);
    }

    public final Execution getExecution(String name) {
        GetExecutionRequest request = GetExecutionRequest.newBuilder().setName(name).build();
        return this.getExecution(request);
    }

    public final Execution getExecution(GetExecutionRequest request) {
        return (Execution)this.getExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable() {
        return this.stub.getExecutionCallable();
    }

    public final Execution cancelExecution(ExecutionName name) {
        CancelExecutionRequest request = CancelExecutionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.cancelExecution(request);
    }

    public final Execution cancelExecution(String name) {
        CancelExecutionRequest request = CancelExecutionRequest.newBuilder().setName(name).build();
        return this.cancelExecution(request);
    }

    public final Execution cancelExecution(CancelExecutionRequest request) {
        return (Execution)this.cancelExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<CancelExecutionRequest, Execution> cancelExecutionCallable() {
        return this.stub.cancelExecutionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListExecutionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage, ListExecutionsFixedSizeCollection> {
        private ListExecutionsFixedSizeCollection(List<ListExecutionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExecutionsFixedSizeCollection createEmptyCollection() {
            return new ListExecutionsFixedSizeCollection(null, 0);
        }

        protected ListExecutionsFixedSizeCollection createCollection(List<ListExecutionsPage> pages, int collectionSize) {
            return new ListExecutionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExecutionsPage
    extends AbstractPage<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage> {
        private ListExecutionsPage(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ListExecutionsResponse response) {
            super(context, (Object)response);
        }

        private static ListExecutionsPage createEmptyPage() {
            return new ListExecutionsPage(null, null);
        }

        protected ListExecutionsPage createPage(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ListExecutionsResponse response) {
            return new ListExecutionsPage(context, response);
        }

        public ApiFuture<ListExecutionsPage> createPageAsync(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ApiFuture<ListExecutionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExecutionsPagedResponse
    extends AbstractPagedListResponse<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage, ListExecutionsFixedSizeCollection> {
        public static ApiFuture<ListExecutionsPagedResponse> createAsync(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ApiFuture<ListExecutionsResponse> futureResponse) {
            ApiFuture<ListExecutionsPage> futurePage = ListExecutionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExecutionsPagedResponse((ListExecutionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExecutionsPagedResponse(ListExecutionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExecutionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

