/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.v1beta.CreateWorkflowRequest;
import com.google.cloud.workflows.v1beta.DeleteWorkflowRequest;
import com.google.cloud.workflows.v1beta.GetWorkflowRequest;
import com.google.cloud.workflows.v1beta.ListWorkflowsRequest;
import com.google.cloud.workflows.v1beta.ListWorkflowsResponse;
import com.google.cloud.workflows.v1beta.OperationMetadata;
import com.google.cloud.workflows.v1beta.UpdateWorkflowRequest;
import com.google.cloud.workflows.v1beta.Workflow;
import com.google.cloud.workflows.v1beta.WorkflowsClient;
import com.google.cloud.workflows.v1beta.stub.GrpcWorkflowsStub;
import com.google.cloud.workflows.v1beta.stub.HttpJsonWorkflowsStub;
import com.google.cloud.workflows.v1beta.stub.WorkflowsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class WorkflowsStubSettings
extends StubSettings<WorkflowsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListWorkflowsRequest, ListWorkflowsResponse, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsSettings;
    private final UnaryCallSettings<GetWorkflowRequest, Workflow> getWorkflowSettings;
    private final UnaryCallSettings<CreateWorkflowRequest, Operation> createWorkflowSettings;
    private final OperationCallSettings<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationSettings;
    private final UnaryCallSettings<DeleteWorkflowRequest, Operation> deleteWorkflowSettings;
    private final OperationCallSettings<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationSettings;
    private final UnaryCallSettings<UpdateWorkflowRequest, Operation> updateWorkflowSettings;
    private final OperationCallSettings<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationSettings;
    private static final PagedListDescriptor<ListWorkflowsRequest, ListWorkflowsResponse, Workflow> LIST_WORKFLOWS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkflowsRequest, ListWorkflowsResponse, Workflow>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkflowsRequest injectToken(ListWorkflowsRequest payload, String token) {
            return ListWorkflowsRequest.newBuilder((ListWorkflowsRequest)payload).setPageToken(token).build();
        }

        public ListWorkflowsRequest injectPageSize(ListWorkflowsRequest payload, int pageSize) {
            return ListWorkflowsRequest.newBuilder((ListWorkflowsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkflowsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkflowsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workflow> extractResources(ListWorkflowsResponse payload) {
            return payload.getWorkflowsList() == null ? ImmutableList.of() : payload.getWorkflowsList();
        }
    };
    private static final PagedListResponseFactory<ListWorkflowsRequest, ListWorkflowsResponse, WorkflowsClient.ListWorkflowsPagedResponse> LIST_WORKFLOWS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkflowsRequest, ListWorkflowsResponse, WorkflowsClient.ListWorkflowsPagedResponse>(){

        public ApiFuture<WorkflowsClient.ListWorkflowsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkflowsRequest, ListWorkflowsResponse> callable, ListWorkflowsRequest request, ApiCallContext context, ApiFuture<ListWorkflowsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKFLOWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkflowsClient.ListWorkflowsPagedResponse.createAsync((PageContext<ListWorkflowsRequest, ListWorkflowsResponse, Workflow>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListWorkflowsRequest, ListWorkflowsResponse, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsSettings() {
        return this.listWorkflowsSettings;
    }

    public UnaryCallSettings<GetWorkflowRequest, Workflow> getWorkflowSettings() {
        return this.getWorkflowSettings;
    }

    public UnaryCallSettings<CreateWorkflowRequest, Operation> createWorkflowSettings() {
        return this.createWorkflowSettings;
    }

    public OperationCallSettings<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationSettings() {
        return this.createWorkflowOperationSettings;
    }

    public UnaryCallSettings<DeleteWorkflowRequest, Operation> deleteWorkflowSettings() {
        return this.deleteWorkflowSettings;
    }

    public OperationCallSettings<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationSettings() {
        return this.deleteWorkflowOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkflowRequest, Operation> updateWorkflowSettings() {
        return this.updateWorkflowSettings;
    }

    public OperationCallSettings<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationSettings() {
        return this.updateWorkflowOperationSettings;
    }

    public WorkflowsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWorkflowsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonWorkflowsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "workflows";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "workflows.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "workflows.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WorkflowsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkflowsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkflowsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return WorkflowsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WorkflowsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listWorkflowsSettings = settingsBuilder.listWorkflowsSettings().build();
        this.getWorkflowSettings = settingsBuilder.getWorkflowSettings().build();
        this.createWorkflowSettings = settingsBuilder.createWorkflowSettings().build();
        this.createWorkflowOperationSettings = settingsBuilder.createWorkflowOperationSettings().build();
        this.deleteWorkflowSettings = settingsBuilder.deleteWorkflowSettings().build();
        this.deleteWorkflowOperationSettings = settingsBuilder.deleteWorkflowOperationSettings().build();
        this.updateWorkflowSettings = settingsBuilder.updateWorkflowSettings().build();
        this.updateWorkflowOperationSettings = settingsBuilder.updateWorkflowOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WorkflowsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListWorkflowsRequest, ListWorkflowsResponse, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsSettings;
        private final UnaryCallSettings.Builder<GetWorkflowRequest, Workflow> getWorkflowSettings;
        private final UnaryCallSettings.Builder<CreateWorkflowRequest, Operation> createWorkflowSettings;
        private final OperationCallSettings.Builder<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationSettings;
        private final UnaryCallSettings.Builder<DeleteWorkflowRequest, Operation> deleteWorkflowSettings;
        private final OperationCallSettings.Builder<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkflowRequest, Operation> updateWorkflowSettings;
        private final OperationCallSettings.Builder<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listWorkflowsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKFLOWS_PAGE_STR_FACT);
            this.getWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWorkflowOperationSettings = OperationCallSettings.newBuilder();
            this.deleteWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWorkflowOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkflowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWorkflowOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listWorkflowsSettings, this.getWorkflowSettings, this.createWorkflowSettings, this.deleteWorkflowSettings, this.updateWorkflowSettings);
            Builder.initDefaults(this);
        }

        protected Builder(WorkflowsStubSettings settings) {
            super((StubSettings)settings);
            this.listWorkflowsSettings = settings.listWorkflowsSettings.toBuilder();
            this.getWorkflowSettings = settings.getWorkflowSettings.toBuilder();
            this.createWorkflowSettings = settings.createWorkflowSettings.toBuilder();
            this.createWorkflowOperationSettings = settings.createWorkflowOperationSettings.toBuilder();
            this.deleteWorkflowSettings = settings.deleteWorkflowSettings.toBuilder();
            this.deleteWorkflowOperationSettings = settings.deleteWorkflowOperationSettings.toBuilder();
            this.updateWorkflowSettings = settings.updateWorkflowSettings.toBuilder();
            this.updateWorkflowOperationSettings = settings.updateWorkflowOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listWorkflowsSettings, this.getWorkflowSettings, this.createWorkflowSettings, this.deleteWorkflowSettings, this.updateWorkflowSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WorkflowsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WorkflowsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkflowsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(WorkflowsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(WorkflowsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)WorkflowsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)WorkflowsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkflowsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(WorkflowsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(WorkflowsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listWorkflowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateWorkflowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createWorkflowOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workflow.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteWorkflowOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateWorkflowOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Workflow.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListWorkflowsRequest, ListWorkflowsResponse, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsSettings() {
            return this.listWorkflowsSettings;
        }

        public UnaryCallSettings.Builder<GetWorkflowRequest, Workflow> getWorkflowSettings() {
            return this.getWorkflowSettings;
        }

        public UnaryCallSettings.Builder<CreateWorkflowRequest, Operation> createWorkflowSettings() {
            return this.createWorkflowSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationSettings() {
            return this.createWorkflowOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkflowRequest, Operation> deleteWorkflowSettings() {
            return this.deleteWorkflowSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationSettings() {
            return this.deleteWorkflowOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkflowRequest, Operation> updateWorkflowSettings() {
            return this.updateWorkflowSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationSettings() {
            return this.updateWorkflowOperationSettings;
        }

        public WorkflowsStubSettings build() throws IOException {
            return new WorkflowsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

