/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.api.core.ApiFunction;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.List;

public class GcpMultiEndpointOptions {
    private final String name;
    private final List<String> endpoints;
    private final ApiFunction<ManagedChannelBuilder<?>, ManagedChannelBuilder<?>> channelConfigurator;
    private final ChannelCredentials channelCredentials;
    private final Duration recoveryTimeout;
    private final Duration switchingDelay;
    public static String DEFAULT_NAME = "default";

    public GcpMultiEndpointOptions(Builder builder) {
        this.name = builder.name;
        this.endpoints = builder.endpoints;
        this.channelConfigurator = builder.channelConfigurator;
        this.channelCredentials = builder.channelCredentials;
        this.recoveryTimeout = builder.recoveryTimeout;
        this.switchingDelay = builder.switchingDelay;
    }

    public static Builder newBuilder(List<String> endpoints) {
        return new Builder(endpoints);
    }

    public static Builder newBuilder(GcpMultiEndpointOptions options) {
        return new Builder(options);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public ApiFunction<ManagedChannelBuilder<?>, ManagedChannelBuilder<?>> getChannelConfigurator() {
        return this.channelConfigurator;
    }

    public ChannelCredentials getChannelCredentials() {
        return this.channelCredentials;
    }

    public Duration getRecoveryTimeout() {
        return this.recoveryTimeout;
    }

    public Duration getSwitchingDelay() {
        return this.switchingDelay;
    }

    public static class Builder {
        private String name = DEFAULT_NAME;
        private List<String> endpoints;
        private ApiFunction<ManagedChannelBuilder<?>, ManagedChannelBuilder<?>> channelConfigurator;
        private ChannelCredentials channelCredentials;
        private Duration recoveryTimeout = Duration.ZERO;
        private Duration switchingDelay = Duration.ZERO;

        public Builder(List<String> endpoints) {
            this.setEndpoints(endpoints);
        }

        public Builder(GcpMultiEndpointOptions options) {
            this.name = options.getName();
            this.endpoints = options.getEndpoints();
            this.channelConfigurator = options.getChannelConfigurator();
            this.channelCredentials = options.getChannelCredentials();
            this.recoveryTimeout = options.getRecoveryTimeout();
            this.switchingDelay = options.getSwitchingDelay();
        }

        public GcpMultiEndpointOptions build() {
            return new GcpMultiEndpointOptions(this);
        }

        private void setEndpoints(List<String> endpoints) {
            Preconditions.checkNotNull(endpoints);
            Preconditions.checkArgument((!endpoints.isEmpty() ? 1 : 0) != 0, (Object)"At least one endpoint must be specified.");
            Preconditions.checkArgument((boolean)endpoints.stream().noneMatch(s -> s.trim().isEmpty()), (Object)"No empty endpoints allowed.");
            this.endpoints = endpoints;
        }

        @CanIgnoreReturnValue
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withEndpoints(List<String> endpoints) {
            this.setEndpoints(endpoints);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withChannelConfigurator(ApiFunction<ManagedChannelBuilder<?>, ManagedChannelBuilder<?>> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withChannelCredentials(ChannelCredentials channelCredentials) {
            this.channelCredentials = channelCredentials;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecoveryTimeout(Duration recoveryTimeout) {
            this.recoveryTimeout = recoveryTimeout;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withSwitchingDelay(Duration switchingDelay) {
            this.switchingDelay = switchingDelay;
            return this;
        }
    }
}

