/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.nativeimage.features.gcp;

import com.google.cloud.nativeimage.features.NativeImageUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
final class CloudSqlFeature
implements Feature {
    private static final String CLOUD_SQL_SOCKET_CLASS = "com.google.cloud.sql.core.CoreSocketFactory";
    private static final String POSTGRES_SOCKET_CLASS = "com.google.cloud.sql.postgres.SocketFactory";
    private static final String MYSQL_SOCKET_CLASS = "com.google.cloud.sql.mysql.SocketFactory";

    CloudSqlFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (access.findClassByName(CLOUD_SQL_SOCKET_CLASS) == null) {
            return;
        }
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, CLOUD_SQL_SOCKET_CLASS);
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        resourcesRegistry.addResources("\\Qcom.google.cloud.sql/project.properties\\E");
        resourcesRegistry.addResources("\\QMETA-INF/services/java.sql.Driver\\E");
        if (access.findClassByName("com.zaxxer.hikari.HikariConfig") != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.zaxxer.hikari.HikariConfig");
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("[Lcom.zaxxer.hikari.util.ConcurrentBag$IConcurrentBagEntry;")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("[Ljava.sql.Statement;")});
        }
        if (access.findClassByName(POSTGRES_SOCKET_CLASS) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, POSTGRES_SOCKET_CLASS);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "org.postgresql.PGProperty");
        }
        if (access.findClassByName(MYSQL_SOCKET_CLASS) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, MYSQL_SOCKET_CLASS);
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, "com.mysql.cj.conf.url.SingleConnectionUrl");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, "com.mysql.cj.log.StandardLogger");
            access.registerSubtypeReachabilityHandler((duringAccess, exceptionClass) -> NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)duringAccess, exceptionClass.getName()), access.findClassByName("com.mysql.cj.exceptions.CJException"));
            RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"com.mysql.cj.jdbc"});
            resourcesRegistry.addResourceBundles("com.mysql.cj.LocalizedErrorMessages");
        }
    }
}

