/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.nativeimage.features;

import com.google.cloud.nativeimage.features.NativeImageUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class GrpcNettyFeature
implements Feature {
    private static final String GRPC_NETTY_SHADED_CLASS = "io.grpc.netty.shaded.io.grpc.netty.NettyServer";
    private static final String GOOGLE_AUTH_CLASS = "com.google.auth.oauth2.ServiceAccountCredentials";

    GrpcNettyFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        GrpcNettyFeature.loadGoogleAuthClasses(access);
        GrpcNettyFeature.loadGrpcNettyClasses(access);
        GrpcNettyFeature.loadMiscClasses(access);
    }

    private static void loadGoogleAuthClasses(Feature.BeforeAnalysisAccess access) {
        Class authClass = access.findClassByName(GOOGLE_AUTH_CLASS);
        if (authClass != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, GOOGLE_AUTH_CLASS);
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, "com.google.auth.oauth2.ServiceAccountJwtAccessCredentials");
        }
    }

    private static void loadGrpcNettyClasses(Feature.BeforeAnalysisAccess access) {
        Class nettyShadedClass = access.findClassByName(GRPC_NETTY_SHADED_CLASS);
        if (nettyShadedClass != null) {
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryUtil");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.buffer.AbstractByteBufAllocator");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.Epoll");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollChannelOption");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup");
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel");
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.channel.epoll.EpollSocketChannel");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerIndexField", "producerIndex");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerLimitField", "producerLimit");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueConsumerIndexField", "consumerIndex");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueProducerFields", "producerIndex");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields", "producerLimit");
            NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueConsumerFields", "consumerIndex");
        }
    }

    private static void loadMiscClasses(Feature.BeforeAnalysisAccess access) {
        NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, "com.google.protobuf.DescriptorProtos");
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.api.FieldBehavior");
        NativeImageUtils.registerForUnsafeFieldAccess((Feature.FeatureAccess)access, "javax.net.ssl.SSLContext", "contextSpi");
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "java.lang.management.ManagementFactory");
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "java.lang.management.RuntimeMXBean");
    }
}

