/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.nativeimage.features;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class NativeImageUtils {
    private static final Logger LOGGER = Logger.getLogger(NativeImageUtils.class.getName());

    public static Method getMethodOrFail(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            return clazz.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find method " + methodName + " for class " + clazz.getName(), e);
        }
    }

    public static void registerForReflectiveInstantiation(Feature.FeatureAccess access, String className) {
        Class clazz = access.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
        } else {
            LOGGER.warning("Failed to find " + className + " on the classpath for reflective instantiation.");
        }
    }

    public static void registerConstructorsForReflection(Feature.FeatureAccess access, String name) {
        Class clazz = access.findClassByName(name);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])clazz.getDeclaredConstructors());
        } else {
            LOGGER.warning("Failed to find " + name + " on the classpath for reflection.");
        }
    }

    public static void registerClassForReflection(Feature.FeatureAccess access, String name) {
        Class clazz = access.findClassByName(name);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])clazz.getDeclaredConstructors());
            RuntimeReflection.register((Field[])clazz.getDeclaredFields());
            RuntimeReflection.register((Executable[])clazz.getDeclaredMethods());
        } else {
            LOGGER.warning("Failed to find " + name + " on the classpath for reflection.");
        }
    }

    public static void registerClassHierarchyForReflection(Feature.FeatureAccess access, String className) {
        Class clazz = access.findClassByName(className);
        if (clazz != null) {
            NativeImageUtils.registerClassForReflection(access, className);
            for (Class<?> nestedClass : clazz.getDeclaredClasses()) {
                if (Modifier.isPrivate(nestedClass.getModifiers())) continue;
                NativeImageUtils.registerClassHierarchyForReflection(access, nestedClass.getName());
            }
        } else {
            LOGGER.warning("Failed to find " + className + " on the classpath for reflection.");
        }
    }

    public static void registerForUnsafeFieldAccess(Feature.FeatureAccess access, String className, String ... fields) {
        Class clazz = access.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            for (String fieldName : fields) {
                try {
                    RuntimeReflection.register((Field[])new Field[]{clazz.getDeclaredField(fieldName)});
                }
                catch (NoSuchFieldException ex) {
                    LOGGER.warning("Failed to register field " + fieldName + " for class " + className);
                    LOGGER.warning(ex.getMessage());
                }
            }
        } else {
            LOGGER.warning("Failed to find " + className + " on the classpath for unsafe fields access registration.");
        }
    }

    public static void registerPackageForReflection(Feature.FeatureAccess access, String packageName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                List<String> classes = NativeImageUtils.findClassesInJar((JarURLConnection)connection, packageName);
                for (String className : classes) {
                    NativeImageUtils.registerClassHierarchyForReflection(access, className);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load classes under package name.", e);
        }
    }

    private static List<String> findClassesInJar(JarURLConnection urlConnection, String packageName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        JarFile jarFile = urlConnection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String javaClassName;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || !(javaClassName = entryName.replace(".class", "").replace('/', '.')).startsWith(packageName)) continue;
            result.add(javaClassName);
        }
        return result;
    }
}

