/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.nativeimage.features.clients;

import com.google.cloud.nativeimage.features.NativeImageUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
final class CloudFunctionsFeature
implements Feature {
    private static final String FUNCTION_INVOKER_CLASS = "com.google.cloud.functions.invoker.runner.Invoker";
    private static final List<String> FUNCTIONS_CLASSES = Arrays.asList("com.google.cloud.functions.HttpFunction", "com.google.cloud.functions.RawBackgroundFunction", "com.google.cloud.functions.BackgroundFunction");

    CloudFunctionsFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class invokerClass = access.findClassByName(FUNCTION_INVOKER_CLASS);
        if (invokerClass != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.beust.jcommander.converters.StringConverter");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.beust.jcommander.validators.NoValidator");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.beust.jcommander.validators.NoValueValidator");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "org.eclipse.jetty.http.HttpTokens");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "org.eclipse.jetty.util.TypeUtil");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.cloud.functions.invoker.runner.Invoker$Options");
            ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
            resourcesRegistry.addResources("\\QMETA-INF/services/org.eclipse.jetty.http.HttpFieldPreEncoder\\E");
            resourcesRegistry.addResources("\\Qorg/eclipse/jetty/http/encoding.properties\\E");
            resourcesRegistry.addResources("\\Qorg/eclipse/jetty/http/mime.properties\\E");
            resourcesRegistry.addResources("\\Qorg/eclipse/jetty/version/build.properties\\E");
            resourcesRegistry.addResourceBundles("javax.servlet.LocalStrings");
            resourcesRegistry.addResourceBundles("javax.servlet.http.LocalStrings");
            List functionClasses = FUNCTIONS_CLASSES.stream().map(name -> access.findClassByName(name)).collect(Collectors.toList());
            CloudFunctionsFeature.scanJarClasspath((Feature.FeatureAccess)access, clazz -> {
                boolean isFunctionSubtype = functionClasses.stream().anyMatch(function -> function.isAssignableFrom((Class<?>)clazz) && !Modifier.isAbstract(clazz.getModifiers()));
                if (isFunctionSubtype) {
                    RuntimeReflection.register((Class[])new Class[]{clazz});
                    RuntimeReflection.register((Executable[])clazz.getDeclaredConstructors());
                    RuntimeReflection.register((Executable[])clazz.getDeclaredMethods());
                    for (Type type : clazz.getGenericInterfaces()) {
                        if (!(type instanceof ParameterizedType)) continue;
                        ParameterizedType paramType = (ParameterizedType)type;
                        for (Type argument : paramType.getActualTypeArguments()) {
                            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, argument.getTypeName());
                        }
                    }
                }
            });
        }
    }

    private static void scanJarClasspath(Feature.FeatureAccess access, Consumer<Class<?>> classProcessorCallback) {
        List classPath = access.getApplicationClassPath();
        try {
            for (Path path : classPath) {
                JarFile jarFile = new JarFile(path.toFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String className;
                    Class clazz;
                    JarEntry jarEntry = entries.nextElement();
                    String fileName = jarEntry.getName();
                    if (!fileName.endsWith(".class") || (clazz = access.findClassByName(className = fileName.substring(0, fileName.length() - 6).replaceAll("/", "."))) == null) continue;
                    classProcessorCallback.accept(clazz);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read classpath: ", e);
        }
    }
}

