/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.nativeimage.features.clients;

import com.google.cloud.nativeimage.features.NativeImageUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class SpannerFeature
implements Feature {
    private static final String SPANNER_CLASS = "com.google.spanner.v1.SpannerGrpc";
    private static final String SPANNER_TEST_CLASS = "com.google.cloud.spanner.GceTestEnvConfig";

    SpannerFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class spannerClass;
        Class spannerTestClass = access.findClassByName(SPANNER_TEST_CLASS);
        if (spannerTestClass != null) {
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, SPANNER_TEST_CLASS);
        }
        if ((spannerClass = access.findClassByName(SPANNER_CLASS)) != null) {
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, "com.google.spanner.admin.database.v1.Database");
            NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, "com.google.spanner.admin.instance.v1.Instance");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.spanner.admin.database.v1.RestoreInfo");
            ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
            resourcesRegistry.addResources("\\Qcom/google/cloud/spanner/connection/ClientSideStatements.json\\E");
            resourcesRegistry.addResources("\\Qcom/google/cloud/spanner/spi/v1/grpc-gcp-apiconfig.json\\E");
        }
    }
}

