/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.api.client.util.Strings;
import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceOptions;
import com.google.cloud.opentelemetry.trace.AutoValue_TraceConfiguration;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.cloud.trace.v2.stub.TraceServiceStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class TraceConfiguration {
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.ofSeconds(10L, 0L);
    @VisibleForTesting
    static final ImmutableMap<String, String> DEFAULT_ATTRIBUTE_MAPPING = ImmutableMap.builder().put((Object)"http.host", (Object)"/http/host").put((Object)"http.method", (Object)"/http/method").put((Object)"http.target", (Object)"/http/path").put((Object)"http.status_code", (Object)"/http/status_code").put((Object)"http.url", (Object)"/http/url").put((Object)"http.request_content_length", (Object)"/http/request/size").put((Object)"http.response_content_length", (Object)"/http/response/size").put((Object)"http.scheme", (Object)"/http/client_protocol").put((Object)"http.route", (Object)"/http/route").put((Object)"http.user_agent", (Object)"/http/user_agent").put((Object)"exception.type", (Object)"/error/name").put((Object)"exception.message", (Object)"/error/message").put((Object)"thread.id", (Object)"/tid").build();

    TraceConfiguration() {
    }

    abstract Supplier<String> getProjectIdSupplier();

    @Nullable
    public abstract Credentials getCredentials();

    public final String getProjectId() {
        return this.getProjectIdSupplier().get();
    }

    @Nullable
    @Deprecated
    public abstract TraceServiceStub getTraceServiceStub();

    @Nullable
    public abstract String getTraceServiceEndpoint();

    public abstract Map<String, AttributeValue> getFixedAttributes();

    public abstract ImmutableMap<String, String> getAttributeMapping();

    public abstract Duration getDeadline();

    @VisibleForTesting
    abstract boolean getInsecureEndpoint();

    public static Builder builder() {
        return new AutoValue_TraceConfiguration.Builder().setProjectIdSupplier((Supplier<String>)Suppliers.memoize(ServiceOptions::getDefaultProjectId)).setFixedAttributes(Collections.emptyMap()).setDeadline(DEFAULT_DEADLINE).setTraceServiceEndpoint(TraceServiceStubSettings.getDefaultEndpoint()).setInsecureEndpoint(false).setAttributeMapping(DEFAULT_ATTRIBUTE_MAPPING);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.ZERO;

        Builder() {
        }

        abstract Builder setProjectIdSupplier(Supplier<String> var1);

        public abstract Builder setCredentials(Credentials var1);

        public final Builder setProjectId(String projectId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID cannot be null or empty.");
            this.setProjectIdSupplier(() -> projectId);
            return this;
        }

        @Deprecated
        public abstract Builder setTraceServiceStub(TraceServiceStub var1);

        public abstract Builder setTraceServiceEndpoint(String var1);

        public abstract Builder setFixedAttributes(Map<String, AttributeValue> var1);

        public abstract Builder setAttributeMapping(ImmutableMap<String, String> var1);

        public abstract ImmutableMap.Builder<String, String> attributeMappingBuilder();

        public final Builder addAttributeMapping(String otelKey, String gcpKey) {
            this.attributeMappingBuilder().put((Object)otelKey, (Object)gcpKey);
            return this;
        }

        public abstract Builder setDeadline(Duration var1);

        abstract Map<String, AttributeValue> getFixedAttributes();

        abstract Duration getDeadline();

        @VisibleForTesting
        abstract Builder setInsecureEndpoint(boolean var1);

        abstract TraceConfiguration autoBuild();

        public TraceConfiguration build() {
            this.setFixedAttributes(Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(this.getFixedAttributes())));
            for (Map.Entry<String, AttributeValue> fixedAttribute : this.getFixedAttributes().entrySet()) {
                Preconditions.checkNotNull((Object)fixedAttribute.getKey(), (Object)"attribute key");
                Preconditions.checkNotNull((Object)fixedAttribute.getValue(), (Object)"attribute value");
            }
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

