/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.cloud.opentelemetry.trace.InternalTraceExporter;
import com.google.cloud.opentelemetry.trace.NoopSpanExporter;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.common.base.Suppliers;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceExporter
implements SpanExporter {
    private static final Logger logger = LoggerFactory.getLogger(TraceExporter.class);
    private final Supplier<SpanExporter> internalTraceExporterSupplier = Suppliers.memoize(() -> {
        try {
            return InternalTraceExporter.createWithConfiguration(configuration);
        }
        catch (IOException e) {
            logger.warn("Unable to initialize Google Cloud TraceExporter. Export operation failed, switching to NoopSpanExporter.", (Throwable)e);
            return new NoopSpanExporter();
        }
    });

    private TraceExporter(TraceConfiguration configuration) {
    }

    public static SpanExporter createWithDefaultConfiguration() {
        return new TraceExporter(TraceConfiguration.builder().build());
    }

    public static SpanExporter createWithConfiguration(TraceConfiguration configuration) {
        return new TraceExporter(configuration);
    }

    public CompletableResultCode flush() {
        return this.internalTraceExporterSupplier.get().flush();
    }

    public CompletableResultCode export(@Nonnull Collection<SpanData> spanDataList) {
        return this.internalTraceExporterSupplier.get().export(spanDataList);
    }

    public CompletableResultCode shutdown() {
        return this.internalTraceExporterSupplier.get().shutdown();
    }
}

