/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.beam;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.beam.PublisherOptions;
import com.google.cloud.pubsublite.beam.Publishers;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashMap;
import java.util.concurrent.Executor;

class PublisherCache
implements AutoCloseable {
    @GuardedBy(value="this")
    private final HashMap<PublisherOptions, Publisher<MessageMetadata>> livePublishers = new HashMap();

    PublisherCache() {
    }

    private synchronized void evict(PublisherOptions options) {
        this.livePublishers.remove(options);
    }

    synchronized Publisher<MessageMetadata> get(final PublisherOptions options) throws ApiException {
        UncheckedApiPreconditions.checkArgument((boolean)options.usesCache());
        Publisher<MessageMetadata> publisher = this.livePublishers.get(options);
        if (publisher != null) {
            return publisher;
        }
        publisher = Publishers.newPublisher(options);
        this.livePublishers.put(options, publisher);
        publisher.addListener(new ApiService.Listener(){

            public void failed(ApiService.State s, Throwable t) {
                PublisherCache.this.evict(options);
            }
        }, (Executor)SystemExecutors.getAlarmExecutor());
        publisher.startAsync().awaitRunning();
        return publisher;
    }

    @VisibleForTesting
    synchronized void set(PublisherOptions options, Publisher<MessageMetadata> toCache) {
        this.livePublishers.put(options, toCache);
    }

    @Override
    public synchronized void close() {
        this.livePublishers.forEach((options, publisher) -> publisher.stopAsync());
        this.livePublishers.clear();
    }
}

