/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.beam;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.beam.PublisherOptions;
import com.google.cloud.pubsublite.beam.SerializableSupplier;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import com.google.common.reflect.TypeToken;

class Publishers {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    private Publishers() {
    }

    private static AdminClient newAdminClient(PublisherOptions options) throws ApiException {
        try {
            return AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setServiceClient(AdminServiceClient.create((AdminServiceSettings)((AdminServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)options.topicPath().location().region(), (ClientSettings.Builder)AdminServiceSettings.newBuilder())))).setRegion(options.topicPath().location().region()).build());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private static PublisherServiceClient newServiceClient(PublisherOptions options, Partition partition) {
        PublisherServiceSettings.Builder settingsBuilder = PublisherServiceSettings.newBuilder();
        settingsBuilder = (PublisherServiceSettings.Builder)ServiceClients.addDefaultMetadata((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((TopicPath)options.topicPath(), (Partition)partition), (ClientSettings.Builder)settingsBuilder);
        try {
            return PublisherServiceClient.create((PublisherServiceSettings)((PublisherServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)options.topicPath().location().region(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    static Publisher<MessageMetadata> newPublisher(PublisherOptions options) throws ApiException {
        SerializableSupplier<Object> supplier = options.publisherSupplier();
        if (supplier != null) {
            Object supplied = supplier.get();
            TypeToken<Publisher<MessageMetadata>> token = new TypeToken<Publisher<MessageMetadata>>(){};
            UncheckedApiPreconditions.checkArgument((boolean)token.isSupertypeOf(supplied.getClass()));
            return (Publisher)supplied;
        }
        return PartitionCountWatchingPublisherSettings.newBuilder().setTopic(options.topicPath()).setPublisherFactory(partition -> SinglePartitionPublisherBuilder.newBuilder().setTopic(options.topicPath()).setPartition(partition).setServiceClient(Publishers.newServiceClient(options, partition)).setBatchingSettings(PublisherSettings.DEFAULT_BATCHING_SETTINGS).build()).setAdminClient(Publishers.newAdminClient(options)).build().instantiate();
    }
}

