/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.beam;

import com.google.cloud.pubsublite.beam.AddUuidsTransform;
import com.google.cloud.pubsublite.beam.PublisherOptions;
import com.google.cloud.pubsublite.beam.PubsubLiteSink;
import com.google.cloud.pubsublite.beam.SubscribeTransform;
import com.google.cloud.pubsublite.beam.SubscriberOptions;
import com.google.cloud.pubsublite.beam.UuidDeduplicationOptions;
import com.google.cloud.pubsublite.beam.UuidDeduplicationTransform;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

@Experimental
public final class PubsubLiteIO {
    private PubsubLiteIO() {
    }

    public static PTransform<PBegin, PCollection<SequencedMessage>> read(SubscriberOptions options) {
        return new SubscribeTransform(options);
    }

    public static PTransform<PCollection<SequencedMessage>, PCollection<SequencedMessage>> deduplicate(UuidDeduplicationOptions options) {
        return new UuidDeduplicationTransform(options);
    }

    public static PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>> addUuids() {
        return new AddUuidsTransform();
    }

    public static PTransform<PCollection<PubSubMessage>, PDone> write(final PublisherOptions options) {
        return new PTransform<PCollection<PubSubMessage>, PDone>("PubsubLiteIO"){

            public PDone expand(PCollection<PubSubMessage> input) {
                PubsubLiteSink sink = new PubsubLiteSink(options);
                input.apply("Write", (PTransform)ParDo.of((DoFn)sink));
                return PDone.in((Pipeline)input.getPipeline());
            }
        };
    }
}

