/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.beam;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.beam.OffsetByteProgress;
import com.google.cloud.pubsublite.beam.SubscriptionPartitionProcessor;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.joda.time.Duration;
import org.joda.time.Instant;

class SubscriptionPartitionProcessorImpl
extends ApiService.Listener
implements SubscriptionPartitionProcessor {
    private final RestrictionTracker<OffsetRange, OffsetByteProgress> tracker;
    private final DoFn.OutputReceiver<SequencedMessage> receiver;
    private final Subscriber subscriber;
    private final SettableFuture<Void> completionFuture = SettableFuture.create();
    private final FlowControlSettings flowControlSettings;
    private Optional<Offset> lastClaimedOffset = Optional.empty();

    SubscriptionPartitionProcessorImpl(RestrictionTracker<OffsetRange, OffsetByteProgress> tracker, DoFn.OutputReceiver<SequencedMessage> receiver, Function<Consumer<List<SequencedMessage>>, Subscriber> subscriberFactory, FlowControlSettings flowControlSettings) {
        this.tracker = tracker;
        this.receiver = receiver;
        this.subscriber = subscriberFactory.apply(this::onMessages);
        this.flowControlSettings = flowControlSettings;
    }

    @Override
    public void start() throws CheckedApiException {
        this.subscriber.addListener((ApiService.Listener)this, MoreExecutors.directExecutor());
        this.subscriber.startAsync();
        this.subscriber.awaitRunning();
        try {
            this.subscriber.seek(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(((OffsetRange)this.tracker.currentRestriction()).getFrom())).build()).get();
            this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(this.flowControlSettings.bytesOutstanding()).setAllowedMessages(this.flowControlSettings.messagesOutstanding()).build());
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical((Throwable)e.getCause());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t);
        }
    }

    private void onMessages(List<SequencedMessage> messages) {
        long byteSize;
        if (this.completionFuture.isDone()) {
            return;
        }
        Offset lastOffset = Offset.of((long)((SequencedMessage)Iterables.getLast(messages)).getCursor().getOffset());
        if (this.tracker.tryClaim((Object)OffsetByteProgress.of(lastOffset, byteSize = messages.stream().mapToLong(SequencedMessage::getSizeBytes).sum()))) {
            this.lastClaimedOffset = Optional.of(lastOffset);
            messages.forEach(message -> this.receiver.outputWithTimestamp(message, new Instant(Timestamps.toMillis((Timestamp)message.getPublishTime()))));
            try {
                this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(byteSize).setAllowedMessages((long)messages.size()).build());
            }
            catch (CheckedApiException e) {
                this.completionFuture.setException((Throwable)e);
            }
        } else {
            this.completionFuture.set(null);
        }
    }

    public void failed(ApiService.State from, Throwable failure) {
        this.completionFuture.setException((Throwable)ExtractStatus.toCanonical((Throwable)failure));
    }

    @Override
    public void close() {
        this.subscriber.stopAsync().awaitTerminated();
    }

    @Override
    public DoFn.ProcessContinuation waitForCompletion(Duration duration) {
        try {
            this.completionFuture.get(duration.getMillis(), TimeUnit.MILLISECONDS);
            return DoFn.ProcessContinuation.stop();
        }
        catch (TimeoutException ignored) {
            return DoFn.ProcessContinuation.resume();
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical((Throwable)e.getCause()).underlying;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public Optional<Offset> lastClaimed() {
        return this.lastClaimedOffset;
    }
}

