/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.beam;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.beam.AutoValue_TopicBacklogReaderSettings;
import com.google.cloud.pubsublite.beam.LimitingTopicBacklogReader;
import com.google.cloud.pubsublite.beam.TopicBacklogReader;
import com.google.cloud.pubsublite.beam.TopicBacklogReaderImpl;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientSettings;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;

@AutoValue
abstract class TopicBacklogReaderSettings
implements Serializable {
    private static final long serialVersionUID = -4001752066450248673L;

    TopicBacklogReaderSettings() {
    }

    abstract TopicPath topicPath();

    abstract Partition partition();

    static Builder newBuilder() {
        return new AutoValue_TopicBacklogReaderSettings.Builder();
    }

    TopicBacklogReader instantiate() throws ApiException {
        TopicStatsClientSettings settings = TopicStatsClientSettings.newBuilder().setRegion(this.topicPath().location().region()).build();
        TopicBacklogReaderImpl impl = new TopicBacklogReaderImpl(TopicStatsClient.create((TopicStatsClientSettings)settings), this.topicPath(), this.partition());
        return new LimitingTopicBacklogReader(impl, Ticker.systemTicker());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setTopicPath(TopicPath var1);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Builder setTopicPathFromSubscriptionPath(SubscriptionPath subscriptionPath) throws ApiException {
            try (AdminClient adminClient = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(subscriptionPath.location().region()).build());){
                Builder builder = this.setTopicPath(TopicPath.parse((String)((Subscription)adminClient.getSubscription(subscriptionPath).get()).getTopic()));
                return builder;
            }
            catch (ExecutionException e) {
                Throwable cause = (Throwable)Preconditions.checkNotNull((Object)e.getCause());
                throw ExtractStatus.toCanonical((Throwable)cause).underlying;
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical((Throwable)t).underlying;
            }
        }

        abstract Builder setPartition(Partition var1);

        abstract TopicBacklogReaderSettings build();
    }
}

