/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.beam;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.beam.AutoValue_UuidDeduplicationOptions;
import com.google.cloud.pubsublite.beam.Uuid;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.Deduplicate;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.Duration;

@AutoValue
public abstract class UuidDeduplicationOptions
implements Serializable {
    private static final long serialVersionUID = 9837489720893L;
    public static final SerializableFunction<SequencedMessage, Uuid> DEFAULT_UUID_EXTRACTOR = (SerializableFunction & Serializable)message -> {
        UncheckedApiPreconditions.checkArgument((boolean)message.getMessage().getAttributesMap().containsKey("x-goog-pubsublite-dataflow-uuid"), (String)"Uuid attribute missing.");
        List attributes = ((AttributeValues)message.getMessage().getAttributesMap().get("x-goog-pubsublite-dataflow-uuid")).getValuesList();
        UncheckedApiPreconditions.checkArgument((attributes.size() == 1 ? 1 : 0) != 0, (String)"Duplicate Uuid attribute values exist.");
        return Uuid.of((ByteString)attributes.get(0));
    };
    public static final int DEFAULT_HASH_PARTITIONS = 10000;
    public static final TimeDomain DEFAULT_TIME_DOMAIN = TimeDomain.EVENT_TIME;
    public static final Duration DEFAULT_DEDUPLICATE_DURATION = Duration.standardDays((long)1L);

    public abstract SerializableFunction<SequencedMessage, Uuid> uuidExtractor();

    public abstract Deduplicate.KeyedValues<Uuid, SequencedMessage> deduplicate();

    public static Builder newBuilder() {
        AutoValue_UuidDeduplicationOptions.Builder builder = new AutoValue_UuidDeduplicationOptions.Builder();
        ((Builder)builder).setUuidExtractor(DEFAULT_UUID_EXTRACTOR);
        ((Builder)builder).setDeduplicate((Deduplicate.KeyedValues<Uuid, SequencedMessage>)Deduplicate.keyedValues().withTimeDomain(DEFAULT_TIME_DOMAIN).withDuration(DEFAULT_DEDUPLICATE_DURATION));
        return builder;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setUuidExtractor(SerializableFunction<SequencedMessage, Uuid> var1);

        public abstract Builder setDeduplicate(Deduplicate.KeyedValues<Uuid, SequencedMessage> var1);

        public abstract UuidDeduplicationOptions build();
    }
}

