/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.kafka.ConsumerSettings;
import java.util.Optional;

final class AutoValue_ConsumerSettings
extends ConsumerSettings {
    private final SubscriptionPath subscriptionPath;
    private final FlowControlSettings perPartitionFlowControlSettings;
    private final boolean autocommit;
    private final Optional<TopicPath> topicPathOverride;

    private AutoValue_ConsumerSettings(SubscriptionPath subscriptionPath, FlowControlSettings perPartitionFlowControlSettings, boolean autocommit, Optional<TopicPath> topicPathOverride) {
        this.subscriptionPath = subscriptionPath;
        this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
        this.autocommit = autocommit;
        this.topicPathOverride = topicPathOverride;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    FlowControlSettings perPartitionFlowControlSettings() {
        return this.perPartitionFlowControlSettings;
    }

    @Override
    boolean autocommit() {
        return this.autocommit;
    }

    @Override
    Optional<TopicPath> topicPathOverride() {
        return this.topicPathOverride;
    }

    public String toString() {
        return "ConsumerSettings{subscriptionPath=" + this.subscriptionPath + ", perPartitionFlowControlSettings=" + this.perPartitionFlowControlSettings + ", autocommit=" + this.autocommit + ", topicPathOverride=" + this.topicPathOverride + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerSettings) {
            ConsumerSettings that = (ConsumerSettings)o;
            return this.subscriptionPath.equals(that.subscriptionPath()) && this.perPartitionFlowControlSettings.equals(that.perPartitionFlowControlSettings()) && this.autocommit == that.autocommit() && this.topicPathOverride.equals(that.topicPathOverride());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.perPartitionFlowControlSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.autocommit ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.topicPathOverride.hashCode();
    }

    static final class Builder
    extends ConsumerSettings.Builder {
        private SubscriptionPath subscriptionPath;
        private FlowControlSettings perPartitionFlowControlSettings;
        private boolean autocommit;
        private Optional<TopicPath> topicPathOverride = Optional.empty();
        private byte set$0;

        Builder() {
        }

        @Override
        public ConsumerSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public ConsumerSettings.Builder setPerPartitionFlowControlSettings(FlowControlSettings perPartitionFlowControlSettings) {
            if (perPartitionFlowControlSettings == null) {
                throw new NullPointerException("Null perPartitionFlowControlSettings");
            }
            this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
            return this;
        }

        @Override
        public ConsumerSettings.Builder setAutocommit(boolean autocommit) {
            this.autocommit = autocommit;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public ConsumerSettings.Builder setTopicPathOverride(TopicPath topicPathOverride) {
            this.topicPathOverride = Optional.of(topicPathOverride);
            return this;
        }

        @Override
        public ConsumerSettings build() {
            if (this.set$0 != 1 || this.subscriptionPath == null || this.perPartitionFlowControlSettings == null) {
                StringBuilder missing = new StringBuilder();
                if (this.subscriptionPath == null) {
                    missing.append(" subscriptionPath");
                }
                if (this.perPartitionFlowControlSettings == null) {
                    missing.append(" perPartitionFlowControlSettings");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" autocommit");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ConsumerSettings(this.subscriptionPath, this.perPartitionFlowControlSettings, this.autocommit, this.topicPathOverride);
        }
    }
}

