/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;

class KafkaExceptionUtils {
    private KafkaExceptionUtils() {
    }

    static KafkaException toKafkaException(CheckedApiException source) {
        switch (source.code()) {
            case ABORTED: {
                return new BrokerNotAvailableException("Aborted.", (Throwable)source);
            }
            case ALREADY_EXISTS: {
                return new KafkaException("Already exists.", (Throwable)source);
            }
            case CANCELLED: {
                return new BrokerNotAvailableException("Cancelled.", (Throwable)source);
            }
            case DATA_LOSS: {
                return new KafkaException("Data loss.", (Throwable)source);
            }
            case DEADLINE_EXCEEDED: {
                return new BrokerNotAvailableException("Deadline exceeded.", (Throwable)source);
            }
            case FAILED_PRECONDITION: {
                return new InvalidRequestException("Failed precondition.", (Throwable)source);
            }
            case INTERNAL: {
                return new BrokerNotAvailableException("Internal.", (Throwable)source);
            }
            case INVALID_ARGUMENT: {
                return new InvalidRequestException("Invalid argument.", (Throwable)source);
            }
            case NOT_FOUND: {
                return new KafkaException("Not found.", (Throwable)source);
            }
            case OUT_OF_RANGE: {
                return new KafkaException("Out of range.", (Throwable)source);
            }
            case PERMISSION_DENIED: {
                return new AuthorizationException("Permission denied.", (Throwable)source);
            }
            case RESOURCE_EXHAUSTED: {
                return new KafkaException("Resource exhausted.", (Throwable)source);
            }
            case UNAUTHENTICATED: {
                return new AuthenticationException("Unauthenticated.", (Throwable)source);
            }
            case UNAVAILABLE: {
                return new BrokerNotAvailableException("Unavailable.", (Throwable)source);
            }
            case UNIMPLEMENTED: {
                return new KafkaException("Unimplemented.", (Throwable)source);
            }
            case UNKNOWN: {
                return new KafkaException("Unknown.", (Throwable)source);
            }
        }
        return new KafkaException("No case.", (Throwable)source);
    }

    static RuntimeException toKafka(Throwable t) {
        try {
            throw t;
        }
        catch (IllegalStateException | UnsupportedOperationException | KafkaException e) {
            return e;
        }
        catch (InterruptedException e) {
            return new InterruptException(e);
        }
        catch (java.util.concurrent.TimeoutException e) {
            return new TimeoutException((Throwable)e);
        }
        catch (Throwable e) {
            return KafkaExceptionUtils.toKafkaException(ExtractStatus.toCanonical((Throwable)t));
        }
    }
}

