/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

class LiteHeaders
implements Headers {
    private Map<String, AttributeValues> attributes;

    LiteHeaders(Map<String, AttributeValues> attributes) {
        this.attributes = attributes;
    }

    static Header toHeader(final String key, final ByteString value) {
        return new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return value.toByteArray();
            }
        };
    }

    public Headers add(Header header) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public Headers add(String s, byte[] bytes) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public Headers remove(String s) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public Header lastHeader(String s) {
        return (Header)Iterables.getLast((Iterable)((Object)this));
    }

    public Iterable<Header> headers(String s) {
        AttributeValues values = this.attributes.get(s);
        if (values == null) {
            return ImmutableList.of();
        }
        return values.getValuesList().stream().map(v -> LiteHeaders.toHeader(s, v)).collect(Collectors.toList());
    }

    public Header[] toArray() {
        return (Header[])Iterators.toArray(this.iterator(), Header.class);
    }

    public Iterator<Header> iterator() {
        return this.attributes.entrySet().stream().flatMap(entry -> ((AttributeValues)entry.getValue()).getValuesList().stream().map(v -> LiteHeaders.toHeader((String)entry.getKey(), v))).iterator();
    }
}

