/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.BlockingPullSubscriberImpl;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientSettings;
import com.google.cloud.pubsublite.internal.wire.AssignerFactory;
import com.google.cloud.pubsublite.internal.wire.AssignerSettings;
import com.google.cloud.pubsublite.internal.wire.CommitterSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.kafka.AutoValue_ConsumerSettings;
import com.google.cloud.pubsublite.kafka.CommitterFactory;
import com.google.cloud.pubsublite.kafka.ConsumerFactory;
import com.google.cloud.pubsublite.kafka.PubsubLiteConsumer;
import com.google.cloud.pubsublite.kafka.PullSubscriberFactory;
import com.google.cloud.pubsublite.kafka.SharedBehavior;
import com.google.cloud.pubsublite.kafka.SingleSubscriptionConsumerImpl;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceSettings;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import java.io.Serializable;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;

@AutoValue
public abstract class ConsumerSettings {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"KAFKA_SHIM");

    abstract SubscriptionPath subscriptionPath();

    abstract FlowControlSettings perPartitionFlowControlSettings();

    abstract boolean autocommit();

    abstract Optional<TopicPath> topicPathOverride();

    public static Builder newBuilder() {
        return new AutoValue_ConsumerSettings.Builder().setAutocommit(false);
    }

    public Consumer<byte[], byte[]> instantiate() throws ApiException {
        try {
            TopicPath topic;
            CloudRegion region = this.subscriptionPath().location().extractRegion();
            if (this.topicPathOverride().isPresent()) {
                topic = this.topicPathOverride().get();
            } else {
                try (AdminClient adminClient = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(region).build());){
                    Subscription subscription = (Subscription)adminClient.getSubscription(this.subscriptionPath()).get();
                    topic = TopicPath.parse((String)subscription.getTopic());
                }
            }
            AssignerFactory assignerFactory = receiver -> {
                try {
                    return AssignerSettings.newBuilder().setReceiver(receiver).setSubscriptionPath(this.subscriptionPath()).setServiceClient(PartitionAssignmentServiceClient.create((PartitionAssignmentServiceSettings)((PartitionAssignmentServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)region, (ClientSettings.Builder)PartitionAssignmentServiceSettings.newBuilder())))).build().instantiate();
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            };
            SubscriberServiceClient subscriberServiceClient = SubscriberServiceClient.create((SubscriberServiceSettings)((SubscriberServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)region, (ClientSettings.Builder)SubscriberServiceSettings.newBuilder())));
            PullSubscriberFactory pullSubscriberFactory = (partition, initialSeek, resetHandler) -> {
                SubscriberFactory & Serializable subscriberFactory = (SubscriberFactory & Serializable)consumer -> {
                    try {
                        return SubscriberBuilder.newBuilder().setPartition(partition).setSubscriptionPath(this.subscriptionPath()).setMessageConsumer(consumer).setStreamFactory(responseStream -> {
                            GrpcCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((SubscriptionPath)this.subscriptionPath(), (Partition)partition));
                            return subscriberServiceClient.subscribeCallable().splitCall(responseStream, (ApiCallContext)context);
                        }).setInitialLocation(initialSeek).setResetHandler(resetHandler).build();
                    }
                    catch (Throwable t) {
                        throw ExtractStatus.toCanonical((Throwable)t).underlying;
                    }
                };
                return new BlockingPullSubscriberImpl((SubscriberFactory)subscriberFactory, this.perPartitionFlowControlSettings());
            };
            CursorServiceClient cursorServiceClient = CursorServiceClient.create((CursorServiceSettings)((CursorServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)CursorServiceSettings.newBuilder())));
            CommitterFactory committerFactory = partition -> {
                try {
                    return CommitterSettings.newBuilder().setSubscriptionPath(this.subscriptionPath()).setPartition(partition).setStreamFactory(responseStream -> cursorServiceClient.streamingCommitCursorCallable().splitCall(responseStream)).build().instantiate();
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t);
                }
            };
            ConsumerFactory consumerFactory = () -> new SingleSubscriptionConsumerImpl(topic, this.autocommit(), pullSubscriberFactory, committerFactory);
            CursorClient cursorClient = CursorClient.create((CursorClientSettings)CursorClientSettings.newBuilder().setRegion(region).build());
            TopicStatsClient topicStatsClient = TopicStatsClient.create((TopicStatsClientSettings)TopicStatsClientSettings.newBuilder().setRegion(region).build());
            SharedBehavior shared = new SharedBehavior(AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(region).build()));
            return new PubsubLiteConsumer(this.subscriptionPath(), topic, shared, consumerFactory, assignerFactory, cursorClient, topicStatsClient, new AutoCloseable[]{cursorServiceClient, subscriberServiceClient});
        }
        catch (Exception e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPerPartitionFlowControlSettings(FlowControlSettings var1);

        public abstract Builder setAutocommit(boolean var1);

        public abstract Builder setTopicPathOverride(TopicPath var1);

        public abstract ConsumerSettings build();
    }
}

