/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.kafka.AutoValue_ProducerSettings;
import com.google.cloud.pubsublite.kafka.PubsubLiteProducer;
import com.google.cloud.pubsublite.kafka.SharedBehavior;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import org.apache.kafka.clients.producer.Producer;

@AutoValue
public abstract class ProducerSettings {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"KAFKA_SHIM");

    abstract TopicPath topicPath();

    public static Builder newBuilder() {
        return new AutoValue_ProducerSettings.Builder();
    }

    private AdminClient newAdminClient() {
        return AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(this.topicPath().location().extractRegion()).build());
    }

    private PublisherServiceClient newServiceClient() throws ApiException {
        try {
            return PublisherServiceClient.create((PublisherServiceSettings)((PublisherServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.topicPath().location().extractRegion(), (ClientSettings.Builder)PublisherServiceSettings.newBuilder())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private PartitionPublisherFactory getPartitionPublisherFactory() {
        final PublisherServiceClient client = this.newServiceClient();
        return new PartitionPublisherFactory(){

            public Publisher<MessageMetadata> newPublisher(Partition partition) throws ApiException {
                SinglePartitionPublisherBuilder.Builder singlePartitionBuilder = SinglePartitionPublisherBuilder.newBuilder().setTopic(ProducerSettings.this.topicPath()).setPartition(partition).setBatchingSettings(PublisherSettings.DEFAULT_BATCHING_SETTINGS).setStreamFactory(responseStream -> {
                    GrpcCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((TopicPath)ProducerSettings.this.topicPath(), (Partition)partition));
                    return client.publishCallable().splitCall(responseStream, (ApiCallContext)context);
                });
                return singlePartitionBuilder.build();
            }

            public void close() {
                client.close();
            }
        };
    }

    public Producer<byte[], byte[]> instantiate() throws ApiException {
        PartitionCountWatchingPublisherSettings publisherSettings = PartitionCountWatchingPublisherSettings.newBuilder().setTopic(this.topicPath()).setAdminClient(this.newAdminClient()).setPublisherFactory(this.getPartitionPublisherFactory()).build();
        SharedBehavior shared = new SharedBehavior(this.newAdminClient());
        return new PubsubLiteProducer((Publisher<MessageMetadata>)publisherSettings.instantiate(), shared, this.topicPath());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopicPath(TopicPath var1);

        public abstract ProducerSettings build();
    }
}

