/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.kafka.KafkaExceptionUtils;
import com.google.cloud.pubsublite.kafka.RecordTransforms;
import com.google.cloud.pubsublite.kafka.SharedBehavior;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;

class PubsubLiteProducer
implements Producer<byte[], byte[]> {
    private static final Duration INFINITE_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    private static final UnsupportedVersionException NO_TRANSACTIONS_EXCEPTION = new UnsupportedVersionException("Pub/Sub Lite is a non-transactional system and does not support producer transactions.");
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final SharedBehavior shared;
    private final Publisher<MessageMetadata> publisher;
    private final TopicPath topicPath;

    PubsubLiteProducer(Publisher<MessageMetadata> publisher, SharedBehavior shared, TopicPath topicPath) {
        this.publisher = publisher;
        this.shared = shared;
        this.topicPath = topicPath;
        this.publisher.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("Pub/Sub Lite Publisher failed.");
            }
        }, MoreExecutors.directExecutor());
        this.publisher.startAsync().awaitRunning();
    }

    public Uuid clientInstanceId(Duration timeout) {
        throw new IllegalStateException("Pub/Sub Lite Kafka Connector does not support telemetry");
    }

    public void initTransactions() {
        throw NO_TRANSACTIONS_EXCEPTION;
    }

    public void beginTransaction() {
        throw NO_TRANSACTIONS_EXCEPTION;
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, String s) {
        throw NO_TRANSACTIONS_EXCEPTION;
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, ConsumerGroupMetadata consumerGroupMetadata) {
        throw NO_TRANSACTIONS_EXCEPTION;
    }

    public void commitTransaction() {
        throw NO_TRANSACTIONS_EXCEPTION;
    }

    public void abortTransaction() {
        throw NO_TRANSACTIONS_EXCEPTION;
    }

    private void checkTopic(String topic) {
        try {
            TopicPath path = TopicPath.parse((String)topic);
            if (!path.equals(this.topicPath)) {
                throw new UnsupportedOperationException("Pub/Sub Lite producers may only interact with the one topic they are configured for.");
            }
        }
        catch (ApiException e) {
            throw KafkaExceptionUtils.toKafka(e);
        }
    }

    public ApiFuture<RecordMetadata> send(ProducerRecord<byte[], byte[]> producerRecord) {
        this.checkTopic(producerRecord.topic());
        if (producerRecord.partition() != null) {
            throw new UnsupportedOperationException("Pub/Sub Lite producers may not specify a partition in their records.");
        }
        ApiFuture future = this.publisher.publish(RecordTransforms.toMessage(producerRecord));
        return ApiFutures.transform((ApiFuture)future, meta -> new RecordMetadata(new TopicPartition(this.topicPath.toString(), (int)meta.partition().value()), meta.offset().value(), 0L, -1L, Long.valueOf(0L), ((byte[])producerRecord.key()).length, ((byte[])producerRecord.value()).length), (Executor)MoreExecutors.directExecutor());
    }

    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> producerRecord, final Callback callback) {
        ApiFuture<RecordMetadata> future = this.send(producerRecord);
        ApiFutures.addCallback(future, (ApiFutureCallback)new ApiFutureCallback<RecordMetadata>(){

            public void onFailure(Throwable throwable) {
                callback.onCompletion(null, (Exception)ExtractStatus.toCanonical((Throwable)throwable));
            }

            public void onSuccess(RecordMetadata recordMetadata) {
                callback.onCompletion(recordMetadata, null);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    public void flush() {
        try {
            this.publisher.flush();
        }
        catch (IOException e) {
            throw KafkaExceptionUtils.toKafka(e);
        }
    }

    public List<PartitionInfo> partitionsFor(String s) {
        this.checkTopic(s);
        return this.shared.partitionsFor(this.topicPath, INFINITE_DURATION);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return ImmutableMap.of();
    }

    public void close() {
        this.close(Duration.ofMillis(Long.MAX_VALUE));
    }

    public void close(Duration duration) {
        try {
            this.shared.close();
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Error closing admin client during Producer shutdown.");
        }
        try {
            this.publisher.stopAsync().awaitTerminated(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Failed to close publisher.");
        }
    }
}

