/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.kafka.LiteHeaders;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.common.collect.ImmutableListMultimap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;

class RecordTransforms {
    private RecordTransforms() {
    }

    static PubSubMessage toMessage(ProducerRecord<byte[], byte[]> record) {
        PubSubMessage.Builder builder = PubSubMessage.newBuilder().setKey(ByteString.copyFrom((byte[])((byte[])record.key()))).setData(ByteString.copyFrom((byte[])((byte[])record.value())));
        if (record.timestamp() != null) {
            builder.setEventTime(Timestamps.fromMillis((long)record.timestamp()));
        }
        ImmutableListMultimap.Builder attributes = ImmutableListMultimap.builder();
        record.headers().forEach(header -> attributes.put((Object)header.key(), (Object)ByteString.copyFrom((byte[])header.value())));
        attributes.build().asMap().forEach((key, values) -> builder.putAttributes(key, AttributeValues.newBuilder().addAllValues((Iterable)values).build()));
        return builder.build();
    }

    static ConsumerRecord<byte[], byte[]> fromMessage(SequencedMessage sequenced, TopicPath topic, Partition partition) {
        Timestamp timestamp;
        TimestampType type;
        PubSubMessage message = sequenced.getMessage();
        LiteHeaders headers = new LiteHeaders(message.getAttributesMap());
        if (message.hasEventTime()) {
            type = TimestampType.CREATE_TIME;
            timestamp = message.getEventTime();
        } else {
            type = TimestampType.LOG_APPEND_TIME;
            timestamp = sequenced.getPublishTime();
        }
        return new ConsumerRecord(topic.toString(), (int)partition.value(), sequenced.getCursor().getOffset(), Timestamps.toMillis((Timestamp)timestamp), type, Long.valueOf(0L), message.getKey().size(), message.getData().size(), (Object)message.getKey().toByteArray(), (Object)message.getData().toByteArray(), (Headers)headers);
    }
}

