/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.kafka;

import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.kafka.KafkaExceptionUtils;
import com.google.cloud.pubsublite.kafka.PubsubLiteNode;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.PartitionInfo;

final class SharedBehavior
implements AutoCloseable {
    private final AdminClient client;

    SharedBehavior(AdminClient client) {
        this.client = client;
    }

    private static PartitionInfo toPartitionInfo(TopicPath topic, Partition partition) {
        return new PartitionInfo(topic.toString(), (int)partition.value(), PubsubLiteNode.NODE, PubsubLiteNode.NODES, PubsubLiteNode.NODES);
    }

    List<PartitionInfo> partitionsFor(TopicPath topic, Duration timeout) {
        try {
            long partitionCount = (Long)this.client.getTopicPartitionCount(topic).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            ImmutableList.Builder result = ImmutableList.builder();
            int i = 0;
            while ((long)i < partitionCount) {
                result.add((Object)SharedBehavior.toPartitionInfo(topic, Partition.of((long)i)));
                ++i;
            }
            return result.build();
        }
        catch (Throwable t) {
            throw KafkaExceptionUtils.toKafka(t);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }
}

