/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.client.util.Base64;
import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.connector.common.AccessTokenProvider;
import com.google.cloud.bigquery.connector.common.AccessTokenProviderCredentials;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;

public class BigQueryCredentialsSupplier {
    private final Credentials credentials;

    public BigQueryCredentialsSupplier(Optional<String> accessTokenProviderFQCN, Optional<String> accessTokenProviderConfig, Optional<String> accessToken, Optional<String> credentialsKey, Optional<String> credentialsFile, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        if (accessTokenProviderFQCN.isPresent()) {
            AccessTokenProvider accessTokenProvider = accessTokenProviderConfig.map(config -> BigQueryUtil.createVerifiedInstance((String)accessTokenProviderFQCN.get(), AccessTokenProvider.class, config)).orElseGet(() -> BigQueryUtil.createVerifiedInstance((String)accessTokenProviderFQCN.get(), AccessTokenProvider.class, new Object[0]));
            this.credentials = new AccessTokenProviderCredentials(BigQueryUtil.verifySerialization(accessTokenProvider));
        } else {
            this.credentials = accessToken.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromAccessToken(accessToken.get()) : (credentialsKey.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromKey(credentialsKey.get(), proxyUri, proxyUsername, proxyPassword) : (credentialsFile.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromFile(credentialsFile.get(), proxyUri, proxyUsername, proxyPassword) : BigQueryCredentialsSupplier.createDefaultCredentials()));
        }
    }

    private static Credentials createCredentialsFromAccessToken(String accessToken) {
        return GoogleCredentials.create((AccessToken)new AccessToken(accessToken, null));
    }

    private static Credentials createCredentialsFromKey(String key, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        try {
            if (proxyUri.isPresent()) {
                HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyUri, proxyUsername, proxyPassword);
                return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)key)), (HttpTransportFactory)httpTransportFactory);
            }
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)key)));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from key", e);
        }
    }

    private static Credentials createCredentialsFromFile(String file, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        try {
            if (proxyUri.isPresent()) {
                HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyUri, proxyUsername, proxyPassword);
                return GoogleCredentials.fromStream((InputStream)new FileInputStream(file), (HttpTransportFactory)httpTransportFactory);
            }
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from file", e);
        }
    }

    public static Credentials createDefaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create default Credentials", e);
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }
}

