/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiFuture;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.DirectRetryingExecutor;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ApiResultRetryAlgorithm;
import com.google.common.base.Optional;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryDirectDataWriterHelper {
    final Logger logger = LoggerFactory.getLogger(BigQueryDirectDataWriterHelper.class);
    final long MAX_APPEND_ROWS_REQUEST_SIZE = (long)((double)StreamWriter.getApiMaxRequestBytes() * 0.95);
    private final BigQueryWriteClient writeClient;
    private final String tablePath;
    private final ProtoSchema protoSchema;
    private final RetrySettings retrySettings;
    private final Optional<String> traceId;
    private String writeStreamName;
    private StreamWriter streamWriter;
    private ProtoRows.Builder protoRows;
    private long appendRequestRowCount = 0L;
    private long appendRequestSizeBytes = 0L;
    private long writeStreamRowCount = 0L;

    public BigQueryDirectDataWriterHelper(BigQueryClientFactory writeClientFactory, String tablePath, ProtoSchema protoSchema, RetrySettings bigqueryDataWriterHelperRetrySettings, Optional<String> traceId) {
        this.writeClient = writeClientFactory.getBigQueryWriteClient();
        this.tablePath = tablePath;
        this.protoSchema = protoSchema;
        this.retrySettings = bigqueryDataWriterHelperRetrySettings;
        this.traceId = traceId;
        try {
            this.writeStreamName = this.retryCreateWriteStream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BigQueryConnectorException("Could not create write-stream after multiple retries", e);
        }
        this.streamWriter = this.createStreamWriter(this.writeStreamName);
        this.protoRows = ProtoRows.newBuilder();
    }

    private String retryCreateWriteStream() throws ExecutionException, InterruptedException {
        return this.retryCallable(() -> this.writeClient.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(this.tablePath).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.PENDING).build()).build()).getName());
    }

    private <V> V retryCallable(Callable<V> callable) throws ExecutionException, InterruptedException {
        DirectRetryingExecutor directRetryingExecutor = new DirectRetryingExecutor(new RetryAlgorithm((ResultRetryAlgorithm)new ApiResultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(this.retrySettings, NanoClock.getDefaultClock())));
        RetryingFuture retryingFuture = directRetryingExecutor.createFuture(callable);
        return (V)directRetryingExecutor.submit(retryingFuture).get();
    }

    private StreamWriter createStreamWriter(String writeStreamName) {
        try {
            StreamWriter.Builder streamWriter = StreamWriter.newBuilder((String)writeStreamName, (BigQueryWriteClient)this.writeClient).setWriterSchema(this.protoSchema);
            if (this.traceId.isPresent()) {
                streamWriter.setTraceId((String)this.traceId.get());
            }
            return streamWriter.build();
        }
        catch (IOException e) {
            throw new BigQueryConnectorException("Could not build stream-writer", e);
        }
    }

    public void addRow(ByteString message) throws IOException {
        int messageSize = message.size();
        if (this.appendRequestSizeBytes + (long)messageSize > this.MAX_APPEND_ROWS_REQUEST_SIZE) {
            if ((long)messageSize > this.MAX_APPEND_ROWS_REQUEST_SIZE) {
                throw new IOException(String.format("A single row of size %d bytes exceeded the maximum of %d bytes for an append-rows-request size", messageSize, this.MAX_APPEND_ROWS_REQUEST_SIZE));
            }
            this.sendAppendRowsRequest();
        }
        this.protoRows.addSerializedRows(message);
        this.appendRequestSizeBytes += (long)messageSize;
        ++this.appendRequestRowCount;
    }

    private void sendAppendRowsRequest() throws IOException {
        long offset = this.writeStreamRowCount;
        ApiFuture appendRowsResponseApiFuture = this.streamWriter.append(this.protoRows.build(), offset);
        this.validateAppendRowsResponse((ApiFuture<AppendRowsResponse>)appendRowsResponseApiFuture, offset);
        this.clearProtoRows();
        this.writeStreamRowCount += this.appendRequestRowCount;
        this.appendRequestRowCount = 0L;
        this.appendRequestSizeBytes = 0L;
    }

    private void validateAppendRowsResponse(ApiFuture<AppendRowsResponse> appendRowsResponseApiFuture, long expectedOffset) throws IOException {
        AppendRowsResponse appendRowsResponse = null;
        try {
            appendRowsResponse = (AppendRowsResponse)appendRowsResponseApiFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BigQueryConnectorException("Could not retrieve AppendRowsResponse", e);
        }
        if (appendRowsResponse.hasError()) {
            throw new IOException("Append request failed with error: " + appendRowsResponse.getError().getMessage());
        }
        AppendRowsResponse.AppendResult appendResult = appendRowsResponse.getAppendResult();
        long responseOffset = appendResult.getOffset().getValue();
        if (expectedOffset != responseOffset) {
            throw new IOException(String.format("On stream %s append-rows response, offset %d did not match expected offset %d", this.writeStreamName, responseOffset, expectedOffset));
        }
    }

    public long finalizeStream() throws IOException {
        if (this.protoRows.getSerializedRowsCount() != 0) {
            this.sendAppendRowsRequest();
        }
        this.waitBeforeFinalization();
        FinalizeWriteStreamRequest finalizeWriteStreamRequest = FinalizeWriteStreamRequest.newBuilder().setName(this.writeStreamName).build();
        FinalizeWriteStreamResponse finalizeResponse = this.retryFinalizeWriteStream(finalizeWriteStreamRequest);
        long expectedFinalizedRowCount = this.writeStreamRowCount;
        long responseFinalizedRowCount = finalizeResponse.getRowCount();
        if (responseFinalizedRowCount != expectedFinalizedRowCount) {
            throw new IOException(String.format("On stream %s finalization, expected finalized row count %d but received %d", this.writeStreamName, expectedFinalizedRowCount, responseFinalizedRowCount));
        }
        this.logger.debug("Write-stream {} finalized with row-count {}", (Object)this.writeStreamName, (Object)responseFinalizedRowCount);
        this.clean();
        return responseFinalizedRowCount;
    }

    private FinalizeWriteStreamResponse retryFinalizeWriteStream(FinalizeWriteStreamRequest finalizeWriteStreamRequest) {
        try {
            return this.retryCallable(() -> this.writeClient.finalizeWriteStream(finalizeWriteStreamRequest));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BigQueryConnectorException(String.format("Could not finalize stream %s.", this.writeStreamName), e);
        }
    }

    private void waitBeforeFinalization() {
        try {
            Sleeper.DEFAULT.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new BigQueryConnectorException(String.format("Interrupted while sleeping before finalizing write-stream %s", this.writeStreamName), e);
        }
    }

    public void abort() {
        this.clean();
        this.protoRows = null;
        this.writeStreamName = null;
    }

    private void clean() {
        this.clearProtoRows();
        if (this.streamWriter != null) {
            this.streamWriter.close();
        }
    }

    private void clearProtoRows() {
        if (this.protoRows != null) {
            this.protoRows.clear();
        }
    }

    public String getWriteStreamName() {
        return this.writeStreamName;
    }
}

